/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.b;
import org.apache.lucene.store.c;
import org.apache.lucene.store.e;
import org.apache.lucene.util.IOUtils;

final class Lucene50CompoundReader
extends c {
    private final c directory;
    private final String segmentName;
    private final Map<String, FileEntry> entries;
    private final IndexInput handle;
    private int version;

    public Lucene50CompoundReader(c c2, SegmentInfo segmentInfo, IOContext iOContext) throws IOException {
        this.directory = c2;
        this.segmentName = segmentInfo.name;
        String string = IndexFileNames.segmentFileName(this.segmentName, "", "cfs");
        String string2 = IndexFileNames.segmentFileName(this.segmentName, "", "cfe");
        this.entries = this.readEntries(segmentInfo.getId(), c2, string2);
        this.handle = c2.openInput(string, iOContext);
        try {
            CodecUtil.checkIndexHeader(this.handle, "Lucene50CompoundData", this.version, this.version, segmentInfo.getId(), "");
            CodecUtil.retrieveChecksum(this.handle);
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(this.handle);
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final Map<String, FileEntry> readEntries(byte[] object, c closeable, String object2) throws IOException {
        Throwable throwable;
        b b2;
        HashMap<String, FileEntry> hashMap = null;
        b2 = ((c)((Object)b2)).openChecksumInput((String)((Object)throwable), IOContext.READONCE);
        throwable = null;
        try {
            try {
                this.version = CodecUtil.checkIndexHeader(b2, "Lucene50CompoundEntries", 0, 0, object, "");
                int n2 = b2.readVInt();
                hashMap = new HashMap<String, FileEntry>(n2);
                for (int i2 = 0; i2 < n2; ++i2) {
                    FileEntry fileEntry = new FileEntry();
                    String string = b2.readString();
                    if (hashMap.put(string, fileEntry) != null) {
                        throw new CorruptIndexException("Duplicate cfs entry id=" + string + " in CFS ", b2);
                    }
                    fileEntry.offset = b2.readLong();
                    fileEntry.length = b2.readLong();
                }
            }
            catch (Throwable throwable2) {
                CodecUtil.checkFooter(b2, throwable2);
            }
            catch (Throwable throwable3) {
                CodecUtil.checkFooter(b2, null);
                throw throwable3;
            }
            CodecUtil.checkFooter(b2, null);
            if (b2 == null) return Collections.unmodifiableMap(hashMap);
        }
        catch (Throwable throwable4) {
            try {
                Throwable throwable5 = throwable4;
                throwable = throwable4;
                throw throwable5;
            }
            catch (Throwable throwable6) {
                if (b2 == null) throw throwable6;
                if (throwable != null) {
                    try {
                        b2.close();
                        throw throwable6;
                    }
                    catch (Throwable throwable7) {
                        throwable.addSuppressed(throwable7);
                    }
                    throw throwable6;
                } else {
                    b2.close();
                }
                throw throwable6;
            }
        }
        b2.close();
        return Collections.unmodifiableMap(hashMap);
    }

    @Override
    public final void close() throws IOException {
        IOUtils.close(this.handle);
    }

    @Override
    public final IndexInput openInput(String string, IOContext object) throws IOException {
        this.ensureOpen();
        object = IndexFileNames.stripSegmentName(string);
        FileEntry fileEntry = this.entries.get(object);
        if (fileEntry == null) {
            throw new FileNotFoundException("No sub-file with id " + (String)object + " found (fileName=" + string + " files: " + this.entries.keySet() + ")");
        }
        return this.handle.slice(string, fileEntry.offset, fileEntry.length);
    }

    @Override
    public final String[] listAll() {
        this.ensureOpen();
        String[] stringArray = this.entries.keySet().toArray(new String[this.entries.size()]);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = this.segmentName + stringArray[i2];
        }
        return stringArray;
    }

    @Override
    public final void deleteFile(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void renameFile(String string, String string2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long fileLength(String string) throws IOException {
        this.ensureOpen();
        FileEntry fileEntry = this.entries.get(IndexFileNames.stripSegmentName(string));
        if (fileEntry == null) {
            throw new FileNotFoundException(string);
        }
        return fileEntry.length;
    }

    @Override
    public final IndexOutput createOutput(String string, IOContext iOContext) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void sync(Collection<String> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final e obtainLock(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final String toString() {
        return "CompoundFileDirectory(segment=\"" + this.segmentName + "\" in dir=" + this.directory + ")";
    }

    public static final class FileEntry {
        long offset;
        long length;
    }
}

