/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.packed.PackedInts;

final class ForUtil {
    private static final int ALL_VALUES_EQUAL = 0;
    static final int MAX_ENCODED_SIZE = 512;
    static final int MAX_DATA_SIZE;
    private final int[] encodedSizes;
    private final PackedInts.b[] encoders;
    private final PackedInts.a[] decoders;
    private final int[] iterations;

    private static int computeIterations(PackedInts.a a2) {
        return (int)Math.ceil(128.0f / (float)a2.byteValueCount());
    }

    private static int encodedSize(PackedInts.Format format, int n2, int n3) {
        long l2 = format.byteCount(n2, 128, n3);
        assert (l2 >= 0L && l2 <= Integer.MAX_VALUE) : l2;
        return (int)l2;
    }

    ForUtil(float f2, DataOutput dataOutput) throws IOException {
        dataOutput.writeVInt(2);
        this.encodedSizes = new int[33];
        this.encoders = new PackedInts.b[33];
        this.decoders = new PackedInts.a[33];
        this.iterations = new int[33];
        for (int i2 = 1; i2 <= 32; ++i2) {
            PackedInts.FormatAndBits formatAndBits = PackedInts.fastestFormatAndBits(128, i2, f2);
            assert (formatAndBits.format.isSupported(formatAndBits.bitsPerValue));
            assert (formatAndBits.bitsPerValue <= 32);
            this.encodedSizes[i2] = ForUtil.encodedSize(formatAndBits.format, 2, formatAndBits.bitsPerValue);
            this.encoders[i2] = PackedInts.getEncoder(formatAndBits.format, 2, formatAndBits.bitsPerValue);
            this.decoders[i2] = PackedInts.getDecoder(formatAndBits.format, 2, formatAndBits.bitsPerValue);
            this.iterations[i2] = ForUtil.computeIterations(this.decoders[i2]);
            dataOutput.writeVInt(formatAndBits.format.getId() << 5 | formatAndBits.bitsPerValue - 1);
        }
    }

    ForUtil(DataInput dataInput) throws IOException {
        int n2 = dataInput.readVInt();
        PackedInts.checkVersion(n2);
        this.encodedSizes = new int[33];
        this.encoders = new PackedInts.b[33];
        this.decoders = new PackedInts.a[33];
        this.iterations = new int[33];
        for (int i2 = 1; i2 <= 32; ++i2) {
            int n3 = dataInput.readVInt();
            int n4 = n3 >>> 5;
            n3 = (n3 & 0x1F) + 1;
            PackedInts.Format format = PackedInts.Format.byId(n4);
            assert (format.isSupported(n3));
            this.encodedSizes[i2] = ForUtil.encodedSize(format, n2, n3);
            this.encoders[i2] = PackedInts.getEncoder(format, n2, n3);
            this.decoders[i2] = PackedInts.getDecoder(format, n2, n3);
            this.iterations[i2] = ForUtil.computeIterations(this.decoders[i2]);
        }
    }

    final void writeBlock(int[] nArray, byte[] byArray, IndexOutput indexOutput) throws IOException {
        if (ForUtil.isAllEqual(nArray)) {
            indexOutput.writeByte((byte)0);
            indexOutput.writeVInt(nArray[0]);
            return;
        }
        int n2 = ForUtil.bitsRequired(nArray);
        assert (n2 > 0 && n2 <= 32) : n2;
        PackedInts.b b2 = this.encoders[n2];
        int n3 = this.iterations[n2];
        assert (n3 * b2.byteValueCount() >= 128);
        int n4 = this.encodedSizes[n2];
        assert (n3 * b2.byteBlockCount() >= n4);
        indexOutput.writeByte((byte)n2);
        b2.encode(nArray, 0, byArray, 0, n3);
        indexOutput.writeBytes(byArray, n4);
    }

    final void readBlock(IndexInput object, byte[] byArray, int[] nArray) throws IOException {
        int n2 = ((DataInput)object).readByte();
        assert (n2 <= 32) : n2;
        if (n2 == 0) {
            int n3 = ((DataInput)object).readVInt();
            Arrays.fill(nArray, 0, 128, n3);
            return;
        }
        int n4 = this.encodedSizes[n2];
        ((DataInput)object).readBytes(byArray, 0, n4);
        object = this.decoders[n2];
        n2 = this.iterations[n2];
        assert (n2 * object.byteValueCount() >= 128);
        object.decode(byArray, 0, nArray, 0, n2);
    }

    final void skipBlock(IndexInput indexInput) throws IOException {
        int n2 = indexInput.readByte();
        if (n2 == 0) {
            indexInput.readVInt();
            return;
        }
        assert (n2 > 0 && n2 <= 32) : n2;
        n2 = this.encodedSizes[n2];
        indexInput.seek(indexInput.getFilePointer() + (long)n2);
    }

    private static boolean isAllEqual(int[] nArray) {
        int n2 = nArray[0];
        for (int i2 = 1; i2 < 128; ++i2) {
            if (nArray[i2] == n2) continue;
            return false;
        }
        return true;
    }

    private static int bitsRequired(int[] nArray) {
        long l2 = 0L;
        for (int i2 = 0; i2 < 128; ++i2) {
            assert (nArray[i2] >= 0);
            l2 |= (long)nArray[i2];
        }
        return PackedInts.bitsRequired(l2);
    }

    static {
        int n2 = 0;
        for (int i2 = 0; i2 <= 2; ++i2) {
            for (PackedInts.Format format : PackedInts.Format.values()) {
                for (int i3 = 1; i3 <= 32; ++i3) {
                    if (!format.isSupported(i3)) continue;
                    PackedInts.a a2 = PackedInts.getDecoder(format, i2, i3);
                    int n3 = ForUtil.computeIterations(a2);
                    n2 = Math.max(n2, n3 * a2.byteValueCount());
                }
            }
        }
        MAX_DATA_SIZE = n2;
    }
}

