/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.MergeState;

class MatchingReaders {
    final boolean[] matchingReaders;
    final int count;

    MatchingReaders(MergeState mergeState) {
        int n2 = mergeState.maxDocs.length;
        int n3 = 0;
        this.matchingReaders = new boolean[n2];
        block0: for (int i2 = 0; i2 < n2; ++i2) {
            for (FieldInfo fieldInfo : mergeState.fieldInfos[i2]) {
                FieldInfo fieldInfo2 = mergeState.mergeFieldInfos.fieldInfo(fieldInfo.number);
                if (fieldInfo2 == null || !fieldInfo2.name.equals(fieldInfo.name)) continue block0;
            }
            this.matchingReaders[i2] = true;
            ++n3;
        }
        this.count = n3;
        if (mergeState.infoStream.isEnabled("SM")) {
            mergeState.infoStream.message("SM", "merge store matchedCount=" + this.count + " vs " + n2);
            if (this.count != n2) {
                mergeState.infoStream.message("SM", n2 - this.count + " non-bulk merges");
            }
        }
    }
}

