/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.lucene.codecs.compressing.LZ4;
import org.apache.lucene.codecs.compressing.a;
import org.apache.lucene.codecs.compressing.b;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;

public abstract class CompressionMode {
    public static final CompressionMode FAST = new CompressionMode(){

        @Override
        public final a newCompressor() {
            return new LZ4FastCompressor();
        }

        @Override
        public final b newDecompressor() {
            return LZ4_DECOMPRESSOR;
        }

        public final String toString() {
            return "FAST";
        }
    };
    public static final CompressionMode HIGH_COMPRESSION = new CompressionMode(){

        @Override
        public final a newCompressor() {
            return new DeflateCompressor(6);
        }

        @Override
        public final b newDecompressor() {
            return new DeflateDecompressor();
        }

        public final String toString() {
            return "HIGH_COMPRESSION";
        }
    };
    public static final CompressionMode FAST_DECOMPRESSION = new CompressionMode(){

        @Override
        public final a newCompressor() {
            return new LZ4HighCompressor();
        }

        @Override
        public final b newDecompressor() {
            return LZ4_DECOMPRESSOR;
        }

        public final String toString() {
            return "FAST_DECOMPRESSION";
        }
    };
    private static final b LZ4_DECOMPRESSOR = new b(){

        @Override
        public final void decompress(DataInput dataInput, int n2, int n3, int n4, BytesRef bytesRef) throws IOException {
            int n5;
            assert (n3 + n4 <= n2);
            if (bytesRef.bytes.length < n2 + 7) {
                bytesRef.bytes = new byte[ArrayUtil.oversize(n2 + 7, 1)];
            }
            if ((n5 = LZ4.decompress(dataInput, n3 + n4, bytesRef.bytes, 0)) > n2) {
                throw new CorruptIndexException("Corrupted: lengths mismatch: " + n5 + " > " + n2, dataInput);
            }
            bytesRef.offset = n3;
            bytesRef.length = n4;
        }

        @Override
        public final b clone() {
            return this;
        }
    };

    protected CompressionMode() {
    }

    public abstract a newCompressor();

    public abstract b newDecompressor();

    private static class DeflateCompressor
    extends a {
        final Deflater compressor;
        byte[] compressed;

        DeflateCompressor(int n2) {
            this.compressor = new Deflater(n2, true);
            this.compressed = new byte[64];
        }

        @Override
        public void compress(byte[] byArray, int n2, int n3, DataOutput dataOutput) throws IOException {
            this.compressor.reset();
            this.compressor.setInput(byArray, n2, n3);
            this.compressor.finish();
            if (this.compressor.needsInput()) {
                assert (n3 == 0) : n3;
                dataOutput.writeVInt(0);
                return;
            }
            int n4 = 0;
            while (true) {
                n2 = this.compressor.deflate(this.compressed, n4, this.compressed.length - n4);
                assert ((n4 += n2) <= this.compressed.length);
                if (this.compressor.finished()) break;
                this.compressed = ArrayUtil.grow(this.compressed);
            }
            dataOutput.writeVInt(n4);
            dataOutput.writeBytes(this.compressed, n4);
        }
    }

    private static final class DeflateDecompressor
    extends b {
        final Inflater decompressor = new Inflater(true);
        byte[] compressed = new byte[0];

        DeflateDecompressor() {
        }

        @Override
        public final void decompress(DataInput dataInput, int n2, int n3, int n4, BytesRef bytesRef) throws IOException {
            assert (n3 + n4 <= n2);
            if (n4 == 0) {
                bytesRef.length = 0;
                return;
            }
            int n5 = dataInput.readVInt();
            int n6 = n5 + 1;
            this.compressed = ArrayUtil.grow(this.compressed, n6);
            dataInput.readBytes(this.compressed, 0, n5);
            this.compressed[n5] = 0;
            this.decompressor.reset();
            this.decompressor.setInput(this.compressed, 0, n6);
            bytesRef.length = 0;
            bytesRef.offset = 0;
            bytesRef.bytes = ArrayUtil.grow(bytesRef.bytes, n2);
            try {
                bytesRef.length = this.decompressor.inflate(bytesRef.bytes, bytesRef.length, n2);
            }
            catch (DataFormatException dataFormatException) {
                throw new IOException(dataFormatException);
            }
            if (!this.decompressor.finished()) {
                throw new CorruptIndexException("Invalid decoder state: needsInput=" + this.decompressor.needsInput() + ", needsDict=" + this.decompressor.needsDictionary(), dataInput);
            }
            if (bytesRef.length != n2) {
                throw new CorruptIndexException("Lengths mismatch: " + bytesRef.length + " != " + n2, dataInput);
            }
            bytesRef.offset = n3;
            bytesRef.length = n4;
        }

        @Override
        public final b clone() {
            return new DeflateDecompressor();
        }
    }

    private static final class LZ4HighCompressor
    extends a {
        private final LZ4.HCHashTable ht = new LZ4.HCHashTable();

        LZ4HighCompressor() {
        }

        @Override
        public final void compress(byte[] byArray, int n2, int n3, DataOutput dataOutput) throws IOException {
            LZ4.compressHC(byArray, n2, n3, dataOutput, this.ht);
        }
    }

    private static final class LZ4FastCompressor
    extends a {
        private final LZ4.HashTable ht = new LZ4.HashTable();

        LZ4FastCompressor() {
        }

        @Override
        public final void compress(byte[] byArray, int n2, int n3, DataOutput dataOutput) throws IOException {
            LZ4.compress(byArray, n2, n3, dataOutput, this.ht);
        }
    }
}

