/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Deque;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexReader;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexWriter;
import org.apache.lucene.codecs.compressing.CompressingTermVectorsReader;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.MatchingReaders;
import org.apache.lucene.codecs.compressing.a;
import org.apache.lucene.codecs.p;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.c;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.GrowableByteArrayDataOutput;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.packed.BlockPackedWriter;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingTermVectorsWriter
extends TermVectorsWriter {
    static final int FLAGS_BITS = PackedInts.bitsRequired(7L);
    private final String segment;
    private CompressingStoredFieldsIndexWriter indexWriter;
    private IndexOutput vectorsStream;
    private final CompressionMode compressionMode;
    private final a compressor;
    private final int chunkSize;
    private long numChunks;
    private long numDirtyChunks;
    private int numDocs;
    private final Deque<DocData> pendingDocs;
    private DocData curDoc;
    private FieldData curField;
    private final BytesRef lastTerm;
    private int[] positionsBuf;
    private int[] startOffsetsBuf;
    private int[] lengthsBuf;
    private int[] payloadLengthsBuf;
    private final GrowableByteArrayDataOutput termSuffixes;
    private final GrowableByteArrayDataOutput payloadBytes;
    private final BlockPackedWriter writer;
    static final String BULK_MERGE_ENABLED_SYSPROP = CompressingTermVectorsWriter.class.getName() + ".enableBulkMerge";
    static final boolean BULK_MERGE_ENABLED;

    private DocData addDocData(int n2) {
        FieldData fieldData = null;
        Object object = this.pendingDocs.descendingIterator();
        while (object.hasNext()) {
            DocData docData = object.next();
            if (docData.fields.isEmpty()) continue;
            fieldData = docData.fields.getLast();
            break;
        }
        if (fieldData == null) {
            object = new DocData(n2, 0, 0, 0);
        } else {
            int n3 = fieldData.posStart + (fieldData.hasPositions ? fieldData.totalPositions : 0);
            int n4 = fieldData.offStart + (fieldData.hasOffsets ? fieldData.totalPositions : 0);
            int n5 = fieldData.payStart + (fieldData.hasPayloads ? fieldData.totalPositions : 0);
            object = new DocData(n2, n3, n4, n5);
        }
        this.pendingDocs.add((DocData)object);
        return object;
    }

    public CompressingTermVectorsWriter(c object, SegmentInfo segmentInfo, String string, IOContext object2, String string2, CompressionMode object3, int n2, int n3) throws IOException {
        assert (object != null);
        this.segment = segmentInfo.name;
        this.compressionMode = object3;
        this.compressor = ((CompressionMode)object3).newCompressor();
        this.chunkSize = n2;
        this.numDocs = 0;
        this.pendingDocs = new ArrayDeque<DocData>();
        this.termSuffixes = new GrowableByteArrayDataOutput(ArrayUtil.oversize(n2, 1));
        this.payloadBytes = new GrowableByteArrayDataOutput(ArrayUtil.oversize(1, 1));
        this.lastTerm = new BytesRef(ArrayUtil.oversize(30, 1));
        object3 = ((c)object).createOutput(IndexFileNames.segmentFileName(this.segment, string, "tvx"), (IOContext)object2);
        try {
            this.vectorsStream = ((c)object).createOutput(IndexFileNames.segmentFileName(this.segment, string, "tvd"), (IOContext)object2);
            object = string2 + "Index";
            object2 = string2 + "Data";
            CodecUtil.writeIndexHeader((DataOutput)object3, (String)object, 1, segmentInfo.getId(), string);
            CodecUtil.writeIndexHeader(this.vectorsStream, (String)object2, 1, segmentInfo.getId(), string);
            assert ((long)CodecUtil.indexHeaderLength((String)object2, string) == this.vectorsStream.getFilePointer());
            assert ((long)CodecUtil.indexHeaderLength((String)object, string) == ((IndexOutput)object3).getFilePointer());
            this.indexWriter = new CompressingStoredFieldsIndexWriter((IndexOutput)object3, n3);
            object3 = null;
            this.vectorsStream.writeVInt(2);
            this.vectorsStream.writeVInt(n2);
            this.writer = new BlockPackedWriter(this.vectorsStream, 64);
            this.positionsBuf = new int[1024];
            this.startOffsetsBuf = new int[1024];
            this.lengthsBuf = new int[1024];
            this.payloadLengthsBuf = new int[1024];
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(new Closeable[]{this.vectorsStream, object3, this.indexWriter});
            throw throwable;
        }
    }

    @Override
    public final void close() throws IOException {
        try {
            IOUtils.close(this.vectorsStream, this.indexWriter);
            return;
        }
        finally {
            this.vectorsStream = null;
            this.indexWriter = null;
        }
    }

    @Override
    public final void startDocument(int n2) throws IOException {
        this.curDoc = this.addDocData(n2);
    }

    @Override
    public final void finishDocument() throws IOException {
        this.termSuffixes.writeBytes(this.payloadBytes.bytes, this.payloadBytes.length);
        this.payloadBytes.length = 0;
        ++this.numDocs;
        if (this.triggerFlush()) {
            this.flush();
        }
        this.curDoc = null;
    }

    @Override
    public final void startField(FieldInfo fieldInfo, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.curField = this.curDoc.addField(fieldInfo.number, n2, bl, bl2, bl3);
        this.lastTerm.length = 0;
    }

    @Override
    public final void finishField() throws IOException {
        this.curField = null;
    }

    @Override
    public final void startTerm(BytesRef bytesRef, int n2) throws IOException {
        assert (n2 > 0);
        int n3 = StringHelper.bytesDifference(this.lastTerm, bytesRef);
        this.curField.addTerm(n2, n3, bytesRef.length - n3);
        this.termSuffixes.writeBytes(bytesRef.bytes, bytesRef.offset + n3, bytesRef.length - n3);
        if (this.lastTerm.bytes.length < bytesRef.length) {
            this.lastTerm.bytes = new byte[ArrayUtil.oversize(bytesRef.length, 1)];
        }
        this.lastTerm.offset = 0;
        this.lastTerm.length = bytesRef.length;
        System.arraycopy(bytesRef.bytes, bytesRef.offset, this.lastTerm.bytes, 0, bytesRef.length);
    }

    @Override
    public final void addPosition(int n2, int n3, int n4, BytesRef bytesRef) throws IOException {
        assert (this.curField.flags != 0);
        this.curField.addPosition(n2, n3, n4 - n3, bytesRef == null ? 0 : bytesRef.length);
        if (this.curField.hasPayloads && bytesRef != null) {
            this.payloadBytes.writeBytes(bytesRef.bytes, bytesRef.offset, bytesRef.length);
        }
    }

    private boolean triggerFlush() {
        return this.termSuffixes.length >= this.chunkSize || this.pendingDocs.size() >= 128;
    }

    private void flush() throws IOException {
        int n2 = this.pendingDocs.size();
        assert (n2 > 0) : n2;
        this.indexWriter.writeIndex(n2, this.vectorsStream.getFilePointer());
        int n3 = this.numDocs - n2;
        this.vectorsStream.writeVInt(n3);
        this.vectorsStream.writeVInt(n2);
        n2 = this.flushNumFields(n2);
        if (n2 > 0) {
            int[] nArray = this.flushFieldNums();
            this.flushFields(n2, nArray);
            this.flushFlags(n2, nArray);
            this.flushNumTerms(n2);
            this.flushTermLengths();
            this.flushTermFreqs();
            this.flushPositions();
            this.flushOffsets(nArray);
            this.flushPayloadLengths();
            this.compressor.compress(this.termSuffixes.bytes, 0, this.termSuffixes.length, this.vectorsStream);
        }
        this.pendingDocs.clear();
        this.curDoc = null;
        this.curField = null;
        this.termSuffixes.length = 0;
        ++this.numChunks;
    }

    private int flushNumFields(int n2) throws IOException {
        if (n2 == 1) {
            n2 = this.pendingDocs.getFirst().numFields;
            this.vectorsStream.writeVInt(n2);
            return n2;
        }
        this.writer.reset(this.vectorsStream);
        n2 = 0;
        for (DocData docData : this.pendingDocs) {
            this.writer.add(docData.numFields);
            n2 += docData.numFields;
        }
        this.writer.finish();
        return n2;
    }

    private int[] flushFieldNums() throws IOException {
        Object object = new TreeSet<Integer>();
        Iterator<DocData> iterator = this.pendingDocs.iterator();
        while (iterator.hasNext()) {
            for (FieldData fieldData : iterator.next().fields) {
                object.add(fieldData.fieldNum);
            }
        }
        int n2 = object.size();
        assert (n2 > 0);
        int n3 = PackedInts.bitsRequired(((Integer)object.last()).intValue());
        int n4 = Math.min(n2 - 1, 7) << 5 | n3;
        this.vectorsStream.writeByte((byte)n4);
        if (n2 - 1 >= 7) {
            this.vectorsStream.writeVInt(n2 - 1 - 7);
        }
        Object object2 = PackedInts.getWriterNoHeader(this.vectorsStream, PackedInts.Format.PACKED, object.size(), n3, 1);
        Object object3 = object.iterator();
        while (object3.hasNext()) {
            Integer n5 = (Integer)object3.next();
            ((PackedInts.Writer)object2).add(n5.intValue());
        }
        ((PackedInts.Writer)object2).finish();
        object3 = new int[object.size()];
        int n6 = 0;
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (Integer)object.next();
            object3[n6++] = (Integer)object2;
        }
        return object3;
    }

    private void flushFields(int n2, int[] nArray) throws IOException {
        PackedInts.Writer writer = PackedInts.getWriterNoHeader(this.vectorsStream, PackedInts.Format.PACKED, n2, PackedInts.bitsRequired(nArray.length - 1), 1);
        Iterator<DocData> iterator = this.pendingDocs.iterator();
        while (iterator.hasNext()) {
            for (FieldData fieldData : iterator.next().fields) {
                int n3 = Arrays.binarySearch(nArray, fieldData.fieldNum);
                assert (n3 >= 0);
                writer.add(n3);
            }
        }
        writer.finish();
    }

    /*
     * WARNING - void declaration
     */
    private void flushFlags(int n2, int[] object) throws IOException {
        Object object2;
        boolean bl = true;
        int[] nArray = new int[((Object)object).length];
        Arrays.fill(nArray, -1);
        Object object3 = this.pendingDocs.iterator();
        block0: while (object3.hasNext()) {
            for (FieldData object4 : object3.next().fields) {
                object2 = Arrays.binarySearch((int[])object, object4.fieldNum);
                assert (object2 >= 0);
                if (nArray[object2] == -1) {
                    nArray[object2] = object4.flags;
                    continue;
                }
                if (nArray[object2] == object4.flags) continue;
                bl = false;
                break block0;
            }
        }
        if (bl) {
            void var7_10;
            this.vectorsStream.writeVInt(0);
            object3 = PackedInts.getWriterNoHeader(this.vectorsStream, PackedInts.Format.PACKED, nArray.length, FLAGS_BITS, 1);
            object = nArray;
            int n3 = nArray.length;
            boolean i2 = false;
            while (var7_10 < n3) {
                object2 = object[var7_10];
                assert (object2 >= 0);
                ((PackedInts.Writer)object3).add((long)object2);
                ++var7_10;
            }
            assert (((PackedInts.Writer)object3).ord() == n3 - 1);
            ((PackedInts.Writer)object3).finish();
            return;
        }
        this.vectorsStream.writeVInt(1);
        object3 = PackedInts.getWriterNoHeader(this.vectorsStream, PackedInts.Format.PACKED, n2, FLAGS_BITS, 1);
        object = this.pendingDocs.iterator();
        while (object.hasNext()) {
            for (FieldData fieldData : ((DocData)object.next()).fields) {
                ((PackedInts.Writer)object3).add(fieldData.flags);
            }
        }
        assert (((PackedInts.Writer)object3).ord() == n2 - 1);
        ((PackedInts.Writer)object3).finish();
    }

    private void flushNumTerms(int n2) throws IOException {
        int n3 = 0;
        Iterator<DocData> iterator = this.pendingDocs.iterator();
        while (iterator.hasNext()) {
            for (FieldData object2 : iterator.next().fields) {
                n3 |= object2.numTerms;
            }
        }
        int n4 = PackedInts.bitsRequired(n3);
        this.vectorsStream.writeVInt(n4);
        PackedInts.Writer writer = PackedInts.getWriterNoHeader(this.vectorsStream, PackedInts.Format.PACKED, n2, n4, 1);
        Iterator<Object> iterator2 = this.pendingDocs.iterator();
        while (iterator2.hasNext()) {
            for (FieldData fieldData : ((DocData)iterator2.next()).fields) {
                writer.add(fieldData.numTerms);
            }
        }
        assert (writer.ord() == n2 - 1);
        writer.finish();
    }

    private void flushTermLengths() throws IOException {
        int n2;
        this.writer.reset(this.vectorsStream);
        Iterator<DocData> iterator = this.pendingDocs.iterator();
        while (iterator.hasNext()) {
            for (FieldData fieldData : iterator.next().fields) {
                for (n2 = 0; n2 < fieldData.numTerms; ++n2) {
                    this.writer.add(fieldData.prefixLengths[n2]);
                }
            }
        }
        this.writer.finish();
        this.writer.reset(this.vectorsStream);
        iterator = this.pendingDocs.iterator();
        while (iterator.hasNext()) {
            for (FieldData fieldData : iterator.next().fields) {
                for (n2 = 0; n2 < fieldData.numTerms; ++n2) {
                    this.writer.add(fieldData.suffixLengths[n2]);
                }
            }
        }
        this.writer.finish();
    }

    private void flushTermFreqs() throws IOException {
        this.writer.reset(this.vectorsStream);
        Iterator<DocData> iterator = this.pendingDocs.iterator();
        while (iterator.hasNext()) {
            for (FieldData fieldData : iterator.next().fields) {
                for (int i2 = 0; i2 < fieldData.numTerms; ++i2) {
                    this.writer.add(fieldData.freqs[i2] - 1);
                }
            }
        }
        this.writer.finish();
    }

    private void flushPositions() throws IOException {
        this.writer.reset(this.vectorsStream);
        Iterator<DocData> iterator = this.pendingDocs.iterator();
        while (iterator.hasNext()) {
            for (FieldData fieldData : iterator.next().fields) {
                if (!fieldData.hasPositions) continue;
                int n2 = 0;
                for (int i2 = 0; i2 < fieldData.numTerms; ++i2) {
                    int n3 = 0;
                    for (int i3 = 0; i3 < fieldData.freqs[i2]; ++i3) {
                        int n4 = this.positionsBuf[fieldData.posStart + n2++];
                        this.writer.add(n4 - n3);
                        n3 = n4;
                    }
                }
                assert (n2 == fieldData.totalPositions);
            }
        }
        this.writer.finish();
    }

    private void flushOffsets(int[] nArray) throws IOException {
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = 0;
        long[] lArray = new long[nArray.length];
        long[] lArray2 = new long[nArray.length];
        Object object = this.pendingDocs.iterator();
        while (object.hasNext()) {
            for (FieldData iterator : object.next().fields) {
                n9 |= iterator.hasOffsets;
                if (!iterator.hasOffsets || !iterator.hasPositions) continue;
                int n10 = Arrays.binarySearch(nArray, iterator.fieldNum);
                n8 = 0;
                for (int i2 = 0; i2 < iterator.numTerms; ++i2) {
                    n7 = 0;
                    n6 = 0;
                    for (n5 = 0; n5 < iterator.freqs[i2]; ++n5) {
                        n4 = this.positionsBuf[iterator.posStart + n8];
                        n3 = this.startOffsetsBuf[iterator.offStart + n8];
                        int n11 = n10;
                        lArray[n11] = lArray[n11] + (long)(n4 - n7);
                        int n12 = n10;
                        lArray2[n12] = lArray2[n12] + (long)(n3 - n6);
                        n7 = n4;
                        n6 = n3;
                        ++n8;
                    }
                }
                assert (n8 == iterator.totalPositions);
            }
        }
        if (n9 == 0) {
            return;
        }
        object = new float[nArray.length];
        for (n2 = 0; n2 < nArray.length; ++n2) {
            object[n2] = lArray[n2] <= 0L || lArray2[n2] <= 0L ? 0.0f : (float)((double)lArray2[n2] / (double)lArray[n2]);
        }
        for (n2 = 0; n2 < nArray.length; ++n2) {
            this.vectorsStream.writeInt(Float.floatToRawIntBits((float)object[n2]));
        }
        this.writer.reset(this.vectorsStream);
        Iterator<DocData> iterator = this.pendingDocs.iterator();
        while (iterator.hasNext()) {
            for (FieldData fieldData : iterator.next().fields) {
                if ((fieldData.flags & 2) == 0) continue;
                n8 = Arrays.binarySearch(nArray, fieldData.fieldNum);
                Object object2 = object[n8];
                n7 = 0;
                for (n6 = 0; n6 < fieldData.numTerms; ++n6) {
                    n5 = 0;
                    n4 = 0;
                    for (n3 = 0; n3 < fieldData.freqs[n6]; ++n3) {
                        n9 = fieldData.hasPositions ? this.positionsBuf[fieldData.posStart + n7] : 0;
                        int n13 = this.startOffsetsBuf[fieldData.offStart + n7];
                        this.writer.add(n13 - n4 - (int)(object2 * (float)(n9 - n5)));
                        n5 = n9;
                        n4 = n13;
                        ++n7;
                    }
                }
            }
        }
        this.writer.finish();
        this.writer.reset(this.vectorsStream);
        iterator = this.pendingDocs.iterator();
        while (iterator.hasNext()) {
            for (FieldData fieldData : iterator.next().fields) {
                if ((fieldData.flags & 2) == 0) continue;
                n8 = 0;
                for (int i3 = 0; i3 < fieldData.numTerms; ++i3) {
                    for (n7 = 0; n7 < fieldData.freqs[i3]; ++n7) {
                        this.writer.add(this.lengthsBuf[fieldData.offStart + n8++] - fieldData.prefixLengths[i3] - fieldData.suffixLengths[i3]);
                    }
                }
                assert (n8 == fieldData.totalPositions);
            }
        }
        this.writer.finish();
    }

    private void flushPayloadLengths() throws IOException {
        this.writer.reset(this.vectorsStream);
        Iterator<DocData> iterator = this.pendingDocs.iterator();
        while (iterator.hasNext()) {
            for (FieldData fieldData : iterator.next().fields) {
                if (!fieldData.hasPayloads) continue;
                for (int i2 = 0; i2 < fieldData.totalPositions; ++i2) {
                    this.writer.add(this.payloadLengthsBuf[fieldData.payStart + i2]);
                }
            }
        }
        this.writer.finish();
    }

    @Override
    public final void finish(FieldInfos fieldInfos, int n2) throws IOException {
        if (!this.pendingDocs.isEmpty()) {
            this.flush();
            ++this.numDirtyChunks;
        }
        if (n2 != this.numDocs) {
            throw new RuntimeException("Wrote " + this.numDocs + " docs, finish called with numDocs=" + n2);
        }
        this.indexWriter.finish(n2, this.vectorsStream.getFilePointer());
        this.vectorsStream.writeVLong(this.numChunks);
        this.vectorsStream.writeVLong(this.numDirtyChunks);
        CodecUtil.writeFooter(this.vectorsStream);
    }

    @Override
    public final void addProx(int n2, DataInput dataInput, DataInput dataInput2) throws IOException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        assert (this.curField.hasPositions == (dataInput != null));
        assert (this.curField.hasOffsets == (dataInput2 != null));
        if (this.curField.hasPositions) {
            n7 = this.curField.posStart + this.curField.totalPositions;
            if (n7 + n2 > this.positionsBuf.length) {
                this.positionsBuf = ArrayUtil.grow(this.positionsBuf, n7 + n2);
            }
            n6 = 0;
            if (this.curField.hasPayloads) {
                n5 = this.curField.payStart + this.curField.totalPositions;
                if (n5 + n2 > this.payloadLengthsBuf.length) {
                    this.payloadLengthsBuf = ArrayUtil.grow(this.payloadLengthsBuf, n5 + n2);
                }
                for (n4 = 0; n4 < n2; ++n4) {
                    n3 = dataInput.readVInt();
                    if ((n3 & 1) != 0) {
                        int n8;
                        this.payloadLengthsBuf[n5 + n4] = n8 = dataInput.readVInt();
                        this.payloadBytes.copyBytes(dataInput, n8);
                    } else {
                        this.payloadLengthsBuf[n5 + n4] = 0;
                    }
                    this.positionsBuf[n7 + n4] = n6 += n3 >>> 1;
                }
            } else {
                for (n5 = 0; n5 < n2; ++n5) {
                    this.positionsBuf[n7 + n5] = n6 += dataInput.readVInt() >>> 1;
                }
            }
        }
        if (this.curField.hasOffsets) {
            n7 = this.curField.offStart + this.curField.totalPositions;
            if (n7 + n2 > this.startOffsetsBuf.length) {
                n6 = ArrayUtil.oversize(n7 + n2, 4);
                this.startOffsetsBuf = Arrays.copyOf(this.startOffsetsBuf, n6);
                this.lengthsBuf = Arrays.copyOf(this.lengthsBuf, n6);
            }
            n6 = 0;
            for (n3 = 0; n3 < n2; ++n3) {
                n5 = n6 + dataInput2.readVInt();
                n6 = n4 = n5 + dataInput2.readVInt();
                this.startOffsetsBuf[n7 + n3] = n5;
                this.lengthsBuf[n7 + n3] = n4 - n5;
            }
        }
        this.curField.totalPositions += n2;
    }

    @Override
    public final int merge(MergeState mergeState) throws IOException {
        int n2 = 0;
        int n3 = mergeState.maxDocs.length;
        MatchingReaders matchingReaders = new MatchingReaders(mergeState);
        for (int i2 = 0; i2 < n3; ++i2) {
            Object object;
            CompressingTermVectorsReader compressingTermVectorsReader = null;
            p p2 = mergeState.termVectorsReaders[i2];
            if (matchingReaders.matchingReaders[i2] && p2 != null && p2 instanceof CompressingTermVectorsReader) {
                compressingTermVectorsReader = (CompressingTermVectorsReader)p2;
            }
            int n4 = mergeState.maxDocs[i2];
            Bits bits = mergeState.liveDocs[i2];
            if (compressingTermVectorsReader != null && compressingTermVectorsReader.getCompressionMode() == this.compressionMode && compressingTermVectorsReader.getChunkSize() == this.chunkSize && compressingTermVectorsReader.getVersion() == 1 && compressingTermVectorsReader.getPackedIntsVersion() == 2 && BULK_MERGE_ENABLED && bits == null && !this.tooDirty(compressingTermVectorsReader)) {
                compressingTermVectorsReader.checkIntegrity();
                if (!this.pendingDocs.isEmpty()) {
                    this.flush();
                    ++this.numDirtyChunks;
                }
                IndexInput indexInput = compressingTermVectorsReader.getVectorsStream();
                object = compressingTermVectorsReader.getIndexReader();
                indexInput.seek(((CompressingStoredFieldsIndexReader)object).getStartPointer(0));
                int n5 = 0;
                while (n5 < n4) {
                    int n6 = indexInput.readVInt();
                    if (n6 != n5) {
                        throw new CorruptIndexException("invalid state: base=" + n6 + ", docID=" + n5, indexInput);
                    }
                    int n7 = indexInput.readVInt();
                    this.indexWriter.writeIndex(n7, this.vectorsStream.getFilePointer());
                    this.vectorsStream.writeVInt(n2);
                    this.vectorsStream.writeVInt(n7);
                    n2 += n7;
                    this.numDocs += n7;
                    if ((n5 += n7) > n4) {
                        throw new CorruptIndexException("invalid state: base=" + n6 + ", count=" + n7 + ", maxDoc=" + n4, indexInput);
                    }
                    long l2 = n5 == n4 ? compressingTermVectorsReader.getMaxPointer() : ((CompressingStoredFieldsIndexReader)object).getStartPointer(n5);
                    this.vectorsStream.copyBytes(indexInput, l2 - indexInput.getFilePointer());
                }
                if (indexInput.getFilePointer() != compressingTermVectorsReader.getMaxPointer()) {
                    throw new CorruptIndexException("invalid state: pos=" + indexInput.getFilePointer() + ", max=" + compressingTermVectorsReader.getMaxPointer(), indexInput);
                }
                this.numChunks += compressingTermVectorsReader.getNumChunks();
                this.numDirtyChunks += compressingTermVectorsReader.getNumDirtyChunks();
                continue;
            }
            if (p2 != null) {
                p2.checkIntegrity();
            }
            for (int i3 = 0; i3 < n4; ++i3) {
                if (bits != null && !bits.get(i3)) continue;
                object = p2 == null ? null : p2.get(i3);
                this.addAllDocVectors((Fields)object, mergeState);
                ++n2;
            }
        }
        this.finish(mergeState.mergeFieldInfos, n2);
        return n2;
    }

    final boolean tooDirty(CompressingTermVectorsReader compressingTermVectorsReader) {
        return compressingTermVectorsReader.getNumDirtyChunks() > 1024L || compressingTermVectorsReader.getNumDirtyChunks() * 100L > compressingTermVectorsReader.getNumChunks();
    }

    static /* synthetic */ int[] access$002(CompressingTermVectorsWriter compressingTermVectorsWriter, int[] nArray) {
        compressingTermVectorsWriter.positionsBuf = nArray;
        return nArray;
    }

    static /* synthetic */ int[] access$102(CompressingTermVectorsWriter compressingTermVectorsWriter, int[] nArray) {
        compressingTermVectorsWriter.startOffsetsBuf = nArray;
        return nArray;
    }

    static /* synthetic */ int[] access$202(CompressingTermVectorsWriter compressingTermVectorsWriter, int[] nArray) {
        compressingTermVectorsWriter.lengthsBuf = nArray;
        return nArray;
    }

    static /* synthetic */ int[] access$302(CompressingTermVectorsWriter compressingTermVectorsWriter, int[] nArray) {
        compressingTermVectorsWriter.payloadLengthsBuf = nArray;
        return nArray;
    }

    static {
        boolean bl = true;
        try {
            bl = Boolean.parseBoolean(System.getProperty(BULK_MERGE_ENABLED_SYSPROP, "true"));
        }
        catch (SecurityException securityException) {}
        BULK_MERGE_ENABLED = bl;
    }

    private class FieldData {
        final boolean hasPositions;
        final boolean hasOffsets;
        final boolean hasPayloads;
        final int fieldNum;
        final int flags;
        final int numTerms;
        final int[] freqs;
        final int[] prefixLengths;
        final int[] suffixLengths;
        final int posStart;
        final int offStart;
        final int payStart;
        int totalPositions;
        int ord;

        FieldData(int n2, int n3, boolean bl, boolean bl2, boolean bl3, int n4, int n5, int n6) {
            this.fieldNum = n2;
            this.numTerms = n3;
            this.hasPositions = bl;
            this.hasOffsets = bl2;
            this.hasPayloads = bl3;
            this.flags = (bl ? 1 : 0) | (bl2 ? 2 : 0) | (bl3 ? 4 : 0);
            this.freqs = new int[n3];
            this.prefixLengths = new int[n3];
            this.suffixLengths = new int[n3];
            this.posStart = n4;
            this.offStart = n5;
            this.payStart = n6;
            this.totalPositions = 0;
            this.ord = 0;
        }

        void addTerm(int n2, int n3, int n4) {
            this.freqs[this.ord] = n2;
            this.prefixLengths[this.ord] = n3;
            this.suffixLengths[this.ord] = n4;
            ++this.ord;
        }

        void addPosition(int n2, int n3, int n4, int n5) {
            if (this.hasPositions) {
                if (this.posStart + this.totalPositions == CompressingTermVectorsWriter.this.positionsBuf.length) {
                    CompressingTermVectorsWriter.access$002(CompressingTermVectorsWriter.this, ArrayUtil.grow(CompressingTermVectorsWriter.this.positionsBuf));
                }
                ((CompressingTermVectorsWriter)CompressingTermVectorsWriter.this).positionsBuf[this.posStart + this.totalPositions] = n2;
            }
            if (this.hasOffsets) {
                if (this.offStart + this.totalPositions == CompressingTermVectorsWriter.this.startOffsetsBuf.length) {
                    n2 = ArrayUtil.oversize(this.offStart + this.totalPositions, 4);
                    CompressingTermVectorsWriter.access$102(CompressingTermVectorsWriter.this, Arrays.copyOf(CompressingTermVectorsWriter.this.startOffsetsBuf, n2));
                    CompressingTermVectorsWriter.access$202(CompressingTermVectorsWriter.this, Arrays.copyOf(CompressingTermVectorsWriter.this.lengthsBuf, n2));
                }
                ((CompressingTermVectorsWriter)CompressingTermVectorsWriter.this).startOffsetsBuf[this.offStart + this.totalPositions] = n3;
                ((CompressingTermVectorsWriter)CompressingTermVectorsWriter.this).lengthsBuf[this.offStart + this.totalPositions] = n4;
            }
            if (this.hasPayloads) {
                if (this.payStart + this.totalPositions == CompressingTermVectorsWriter.this.payloadLengthsBuf.length) {
                    CompressingTermVectorsWriter.access$302(CompressingTermVectorsWriter.this, ArrayUtil.grow(CompressingTermVectorsWriter.this.payloadLengthsBuf));
                }
                ((CompressingTermVectorsWriter)CompressingTermVectorsWriter.this).payloadLengthsBuf[this.payStart + this.totalPositions] = n5;
            }
            ++this.totalPositions;
        }
    }

    private class DocData {
        final int numFields;
        final Deque<FieldData> fields;
        final int posStart;
        final int offStart;
        final int payStart;

        DocData(int n2, int n3, int n4, int n5) {
            this.numFields = n2;
            this.fields = new ArrayDeque<FieldData>(n2);
            this.posStart = n3;
            this.offStart = n4;
            this.payStart = n5;
        }

        FieldData addField(int n2, int n3, boolean bl, boolean bl2, boolean bl3) {
            FieldData fieldData;
            if (this.fields.isEmpty()) {
                fieldData = new FieldData(n2, n3, bl, bl2, bl3, this.posStart, this.offStart, this.payStart);
            } else {
                FieldData fieldData2 = this.fields.getLast();
                int n4 = fieldData2.posStart + (fieldData2.hasPositions ? fieldData2.totalPositions : 0);
                int n5 = fieldData2.offStart + (fieldData2.hasOffsets ? fieldData2.totalPositions : 0);
                int n6 = fieldData2.payStart + (fieldData2.hasPayloads ? fieldData2.totalPositions : 0);
                fieldData = new FieldData(n2, n3, bl, bl2, bl3, n4, n5, n6);
            }
            this.fields.add(fieldData);
            return fieldData;
        }
    }
}

