/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexReader;
import org.apache.lucene.codecs.compressing.CompressingTermVectorsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.b;
import org.apache.lucene.codecs.p;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.m;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.a;
import org.apache.lucene.store.c;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.BlockPackedReaderIterator;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingTermVectorsReader
extends p
implements Closeable {
    private final FieldInfos fieldInfos;
    final CompressingStoredFieldsIndexReader indexReader;
    final IndexInput vectorsStream;
    private final int version;
    private final int packedIntsVersion;
    private final CompressionMode compressionMode;
    private final b decompressor;
    private final int chunkSize;
    private final int numDocs;
    private boolean closed;
    private final BlockPackedReaderIterator reader;
    private final long numChunks;
    private final long numDirtyChunks;
    private final long maxPointer;

    private CompressingTermVectorsReader(CompressingTermVectorsReader compressingTermVectorsReader) {
        this.fieldInfos = compressingTermVectorsReader.fieldInfos;
        this.vectorsStream = compressingTermVectorsReader.vectorsStream.clone();
        this.indexReader = compressingTermVectorsReader.indexReader.clone();
        this.packedIntsVersion = compressingTermVectorsReader.packedIntsVersion;
        this.compressionMode = compressingTermVectorsReader.compressionMode;
        this.decompressor = compressingTermVectorsReader.decompressor.clone();
        this.chunkSize = compressingTermVectorsReader.chunkSize;
        this.numDocs = compressingTermVectorsReader.numDocs;
        this.reader = new BlockPackedReaderIterator(this.vectorsStream, this.packedIntsVersion, 64, 0L);
        this.version = compressingTermVectorsReader.version;
        this.numChunks = compressingTermVectorsReader.numChunks;
        this.numDirtyChunks = compressingTermVectorsReader.numDirtyChunks;
        this.maxPointer = compressingTermVectorsReader.maxPointer;
        this.closed = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompressingTermVectorsReader(c c2, SegmentInfo segmentInfo, String string, FieldInfos fieldInfos, IOContext iOContext, String string2, CompressionMode compressionMode) throws IOException {
        Object object;
        Object object2;
        long l2;
        CompressingStoredFieldsIndexReader compressingStoredFieldsIndexReader;
        int n2;
        String string3;
        block19: {
            this.compressionMode = compressionMode;
            string3 = segmentInfo.name;
            this.fieldInfos = fieldInfos;
            this.numDocs = segmentInfo.maxDoc();
            n2 = -1;
            compressingStoredFieldsIndexReader = null;
            l2 = -1L;
            object2 = IndexFileNames.segmentFileName(string3, string, "tvx");
            object2 = c2.openChecksumInput((String)object2, iOContext);
            object = null;
            try {
                block18: {
                    try {
                        String string4 = string2 + "Index";
                        n2 = CodecUtil.checkIndexHeader((DataInput)object2, string4, 0, 1, segmentInfo.getId(), string);
                        assert ((long)CodecUtil.indexHeaderLength(string4, string) == ((IndexInput)object2).getFilePointer());
                        compressingStoredFieldsIndexReader = new CompressingStoredFieldsIndexReader((IndexInput)object2, segmentInfo);
                        l2 = ((DataInput)object2).readVLong();
                    }
                    catch (Throwable throwable) {
                        CodecUtil.checkFooter((org.apache.lucene.store.b)object2, throwable);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        CodecUtil.checkFooter((org.apache.lucene.store.b)object2, null);
                        throw throwable;
                    }
                    CodecUtil.checkFooter((org.apache.lucene.store.b)object2, null);
                }
                if (object2 == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    object = throwable;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (object2 == null) throw throwable3;
                    if (object == null) {
                        ((IndexInput)object2).close();
                        throw throwable3;
                    }
                    try {
                        ((IndexInput)object2).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ((Throwable)object).addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
            }
            ((IndexInput)object2).close();
        }
        this.version = n2;
        this.indexReader = compressingStoredFieldsIndexReader;
        this.maxPointer = l2;
        try {
            object2 = IndexFileNames.segmentFileName(string3, string, "tvd");
            this.vectorsStream = c2.openInput((String)object2, iOContext);
            object = string2 + "Data";
            int n3 = CodecUtil.checkIndexHeader(this.vectorsStream, (String)object, 0, 1, segmentInfo.getId(), string);
            if (n2 != n3) {
                throw new CorruptIndexException("Version mismatch between stored fields index and data: " + n2 + " != " + n3, this.vectorsStream);
            }
            assert ((long)CodecUtil.indexHeaderLength((String)object, string) == this.vectorsStream.getFilePointer());
            long l3 = this.vectorsStream.getFilePointer();
            if (n2 > 0) {
                this.vectorsStream.seek(l2);
                this.numChunks = this.vectorsStream.readVLong();
                this.numDirtyChunks = this.vectorsStream.readVLong();
                if (this.numDirtyChunks > this.numChunks) {
                    throw new CorruptIndexException("invalid chunk counts: dirty=" + this.numDirtyChunks + ", total=" + this.numChunks, this.vectorsStream);
                }
            } else {
                this.numDirtyChunks = -1L;
                this.numChunks = -1L;
            }
            CodecUtil.retrieveChecksum(this.vectorsStream);
            this.vectorsStream.seek(l3);
            this.packedIntsVersion = this.vectorsStream.readVInt();
            this.chunkSize = this.vectorsStream.readVInt();
            this.decompressor = compressionMode.newDecompressor();
            this.reader = new BlockPackedReaderIterator(this.vectorsStream, this.packedIntsVersion, 64, 0L);
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    final CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    final int getChunkSize() {
        return this.chunkSize;
    }

    final int getPackedIntsVersion() {
        return this.packedIntsVersion;
    }

    final int getVersion() {
        return this.version;
    }

    final CompressingStoredFieldsIndexReader getIndexReader() {
        return this.indexReader;
    }

    final IndexInput getVectorsStream() {
        return this.vectorsStream;
    }

    final long getMaxPointer() {
        return this.maxPointer;
    }

    final long getNumChunks() {
        return this.numChunks;
    }

    final long getNumDirtyChunks() {
        return this.numDirtyChunks;
    }

    private void ensureOpen() throws a {
        if (this.closed) {
            throw new a("this FieldsReader is closed");
        }
    }

    @Override
    public final void close() throws IOException {
        if (!this.closed) {
            IOUtils.close(this.vectorsStream);
            this.closed = true;
        }
    }

    @Override
    public final p clone() {
        return new CompressingTermVectorsReader(this);
    }

    @Override
    public final Fields get(int n2) throws IOException {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        Object object;
        Object object2;
        int n8;
        int n9;
        LongsRef longsRef;
        int n10;
        int[] nArray;
        int n11;
        int n12;
        int n13;
        PackedInts.Reader reader;
        int n14;
        int n15;
        int n16;
        int n17;
        this.ensureOpen();
        long l2 = this.indexReader.getStartPointer(n2);
        this.vectorsStream.seek(l2);
        int n18 = this.vectorsStream.readVInt();
        int n19 = this.vectorsStream.readVInt();
        if (n2 < n18 || n2 >= n18 + n19 || n18 + n19 > this.numDocs) {
            throw new CorruptIndexException("docBase=" + n18 + ",chunkDocs=" + n19 + ",doc=" + n2, this.vectorsStream);
        }
        if (n19 == 1) {
            n17 = 0;
            n16 = n2 = this.vectorsStream.readVInt();
        } else {
            this.reader.reset(this.vectorsStream, n19);
            int n20 = 0;
            for (n15 = n18; n15 < n2; ++n15) {
                n20 = (int)((long)n20 + this.reader.next());
            }
            n17 = n20;
            n16 = (int)this.reader.next();
            n20 += n16;
            for (n15 = n2 + 1; n15 < n18 + n19; ++n15) {
                n20 = (int)((long)n20 + this.reader.next());
            }
            n2 = n20;
        }
        if (n16 == 0) {
            return null;
        }
        n15 = this.vectorsStream.readByte() & 0xFF;
        assert (n15 != 0);
        n18 = n15 & 0x1F;
        n19 = n15 >>> 5;
        if (n19 == 7) {
            n19 += this.vectorsStream.readVInt();
        }
        Object object3 = PackedInts.getReaderIteratorNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, ++n19, n18, 1);
        int[] nArray2 = new int[n19];
        for (int i2 = 0; i2 < n19; ++i2) {
            nArray2[i2] = (int)object3.next();
        }
        int[] nArray3 = new int[n16];
        n19 = PackedInts.bitsRequired(nArray2.length - 1);
        object3 = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, n2, n19);
        switch (this.vectorsStream.readVInt()) {
            case 0: {
                PackedInts.Reader reader2 = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, nArray2.length, CompressingTermVectorsWriter.FLAGS_BITS);
                PackedInts.Mutable mutable = PackedInts.getMutable(n2, CompressingTermVectorsWriter.FLAGS_BITS, 0.0f);
                for (n14 = 0; n14 < n2; ++n14) {
                    int n21 = (int)((m)object3).get(n14);
                    assert (n21 >= 0 && n21 < nArray2.length);
                    int n22 = (int)reader2.get(n21);
                    mutable.set(n14, n22);
                }
                reader = mutable;
                break;
            }
            case 1: {
                reader = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, n2, CompressingTermVectorsWriter.FLAGS_BITS);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        for (n13 = 0; n13 < n16; ++n13) {
            nArray3[n13] = (int)((m)object3).get(n17 + n13);
        }
        n13 = this.vectorsStream.readVInt();
        PackedInts.Reader reader3 = PackedInts.getReaderNoHeader(this.vectorsStream, PackedInts.Format.PACKED, this.packedIntsVersion, n2, n13);
        int n23 = 0;
        for (n14 = 0; n14 < n2; ++n14) {
            n23 = (int)((long)n23 + reader3.get(n14));
        }
        int n24 = n23;
        n13 = 0;
        n23 = 0;
        int[] nArray4 = new int[n16];
        int[][] nArrayArray = new int[n16][];
        int[][] nArrayArray2 = new int[n16][];
        this.reader.reset(this.vectorsStream, n24);
        int n25 = 0;
        for (n12 = 0; n12 < n17; ++n12) {
            n25 = (int)((long)n25 + reader3.get(n12));
        }
        this.reader.skip(n25);
        for (n12 = 0; n12 < n16; ++n12) {
            n11 = (int)reader3.get(n17 + n12);
            nArray = new int[n11];
            nArrayArray[n12] = nArray;
            n10 = 0;
            while (n10 < n11) {
                longsRef = this.reader.next(n11 - n10);
                for (n9 = 0; n9 < longsRef.length; ++n9) {
                    nArray[n10++] = (int)longsRef.longs[longsRef.offset + n9];
                }
            }
        }
        this.reader.skip((long)n24 - this.reader.ord());
        this.reader.reset(this.vectorsStream, n24);
        for (n12 = 0; n12 < n17; ++n12) {
            n11 = 0;
            while ((long)n11 < reader3.get(n12)) {
                n13 = (int)((long)n13 + this.reader.next());
                ++n11;
            }
        }
        for (n12 = 0; n12 < n16; ++n12) {
            n11 = (int)reader3.get(n17 + n12);
            nArray = new int[n11];
            nArrayArray2[n12] = nArray;
            n10 = 0;
            while (n10 < n11) {
                longsRef = this.reader.next(n11 - n10);
                for (n9 = 0; n9 < longsRef.length; ++n9) {
                    nArray[n10++] = (int)longsRef.longs[longsRef.offset + n9];
                }
            }
            nArray4[n12] = CompressingTermVectorsReader.sum(nArrayArray2[n12]);
            n23 += nArray4[n12];
        }
        n14 = n13 + n23;
        for (n12 = n17 + n16; n12 < n2; ++n12) {
            n11 = 0;
            while ((long)n11 < reader3.get(n12)) {
                n14 = (int)((long)n14 + this.reader.next());
                ++n11;
            }
        }
        int[] nArray5 = new int[n24];
        this.reader.reset(this.vectorsStream, n24);
        n12 = 0;
        while (n12 < n24) {
            LongsRef longsRef2 = this.reader.next(n24 - n12);
            for (int i3 = 0; i3 < longsRef2.length; ++i3) {
                nArray5[n12++] = 1 + (int)longsRef2.longs[longsRef2.offset + i3];
            }
        }
        n12 = 0;
        int n26 = 0;
        int n27 = 0;
        int n28 = 0;
        for (n10 = 0; n10 < n2; ++n10) {
            n9 = (int)reader.get(n10);
            int n29 = (int)reader3.get(n10);
            for (int i4 = 0; i4 < n29; ++i4) {
                n8 = nArray5[n28++];
                if ((n9 & 1) != 0) {
                    n12 += n8;
                }
                if ((n9 & 2) != 0) {
                    n26 += n8;
                }
                if ((n9 & 4) == 0) continue;
                n27 += n8;
            }
            assert (n10 != n2 - 1 || n28 == n24) : n28 + " " + n24;
        }
        int[][] nArray6 = this.positionIndex(n17, n16, reader3, nArray5);
        Object object4 = n12 > 0 ? (Object)this.readPositions(n17, n16, reader, reader3, nArray5, 1, n12, nArray6) : new int[n16][];
        if (n26 > 0) {
            float[] fArray = new float[nArray2.length];
            for (n8 = 0; n8 < fArray.length; ++n8) {
                fArray[n8] = Float.intBitsToFloat(this.vectorsStream.readInt());
            }
            object2 = this.readPositions(n17, n16, reader, reader3, nArray5, 2, n26, nArray6);
            object = this.readPositions(n17, n16, reader, reader3, nArray5, 2, n26, nArray6);
            for (n8 = 0; n8 < n16; ++n8) {
                int[] nArray7 = object2[n8];
                int[] nArray8 = object4[n8];
                if (nArray7 != null && nArray8 != null) {
                    float f2 = fArray[nArray3[n8]];
                    for (n7 = 0; n7 < object2[n8].length; ++n7) {
                        int n30 = n7;
                        nArray7[n30] = nArray7[n30] + (int)(f2 * (float)nArray8[n7]);
                    }
                }
                if (nArray7 == null) continue;
                int[] nArray9 = nArrayArray[n8];
                int[] nArray10 = nArrayArray2[n8];
                int[] nArray11 = object[n8];
                n6 = (int)reader3.get(n17 + n8);
                for (n5 = 0; n5 < n6; ++n5) {
                    n4 = nArray9[n5] + nArray10[n5];
                    int[] nArray12 = object[n8];
                    int n31 = nArray6[n8][n5];
                    nArray12[n31] = nArray12[n31] + n4;
                    n3 = nArray6[n8][n5] + 1;
                    while (n3 < nArray6[n8][n5 + 1]) {
                        int n32 = n3;
                        nArray7[n32] = nArray7[n32] + nArray7[n3 - 1];
                        int n33 = n3++;
                        nArray11[n33] = nArray11[n33] + n4;
                    }
                }
            }
        } else {
            object2 = object = new int[n16][];
        }
        if (n12 > 0) {
            for (int i5 = 0; i5 < n16; ++i5) {
                int[] nArray13 = object4[i5];
                int[] nArray14 = nArray6[i5];
                if (nArray13 == null) continue;
                int n34 = (int)reader3.get(n17 + i5);
                for (int i6 = 0; i6 < n34; ++i6) {
                    for (n7 = nArray14[i6] + 1; n7 < nArray14[i6 + 1]; ++n7) {
                        int n35 = n7;
                        nArray13[n35] = nArray13[n35] + nArray13[n7 - 1];
                    }
                }
            }
        }
        int[][] nArrayArray3 = new int[n16][];
        int n36 = 0;
        int n37 = 0;
        int n38 = 0;
        if (n27 > 0) {
            this.reader.reset(this.vectorsStream, n27);
            int n39 = 0;
            for (n7 = 0; n7 < n17; ++n7) {
                int n40 = (int)reader.get(n7);
                n5 = (int)reader3.get(n7);
                if ((n40 & 4) != 0) {
                    for (n6 = 0; n6 < n5; ++n6) {
                        n4 = nArray5[n39 + n6];
                        for (n3 = 0; n3 < n4; ++n3) {
                            n12 = (int)this.reader.next();
                            n37 += n12;
                        }
                    }
                }
                n39 += n5;
            }
            n36 = n37;
            for (n7 = 0; n7 < n16; ++n7) {
                int n41 = (int)reader.get(n17 + n7);
                n5 = (int)reader3.get(n17 + n7);
                if ((n41 & 4) != 0) {
                    n6 = nArray6[n7][n5];
                    nArrayArray3[n7] = new int[n6 + 1];
                    n4 = 0;
                    nArrayArray3[n7][0] = n38;
                    for (n3 = 0; n3 < n5; ++n3) {
                        n12 = nArray5[n39 + n3];
                        for (n27 = 0; n27 < n12; ++n27) {
                            n41 = (int)this.reader.next();
                            nArrayArray3[n7][n4 + 1] = n38 += n41;
                            ++n4;
                        }
                    }
                    assert (n4 == n6);
                }
                n39 += n5;
            }
            n36 += n38;
            for (n7 = n17 + n16; n7 < n2; ++n7) {
                int n42 = (int)reader.get(n7);
                n5 = (int)reader3.get(n7);
                if ((n42 & 4) != 0) {
                    for (n6 = 0; n6 < n5; ++n6) {
                        n4 = nArray5[n39 + n6];
                        for (n3 = 0; n3 < n4; ++n3) {
                            n36 = (int)((long)n36 + this.reader.next());
                        }
                    }
                }
                n39 += n5;
            }
            assert (n39 == n24) : n39 + " " + n24;
        }
        BytesRef bytesRef = new BytesRef();
        this.decompressor.decompress(this.vectorsStream, n14 + n36, n13 + n37, n23 + n38, bytesRef);
        bytesRef.length = n23;
        BytesRef bytesRef2 = new BytesRef(bytesRef.bytes, bytesRef.offset + n23, n38);
        int[] nArray15 = new int[n16];
        for (n5 = 0; n5 < n16; ++n5) {
            nArray15[n5] = (int)reader.get(n17 + n5);
        }
        int[] nArray16 = new int[n16];
        for (n6 = 0; n6 < n16; ++n6) {
            nArray16[n6] = (int)reader3.get(n17 + n6);
        }
        int[][] nArrayArray4 = new int[n16][];
        n4 = 0;
        for (n3 = 0; n3 < n17; ++n3) {
            n4 = (int)((long)n4 + reader3.get(n3));
        }
        for (n3 = 0; n3 < n16; ++n3) {
            n12 = (int)reader3.get(n17 + n3);
            nArrayArray4[n3] = new int[n12];
            for (n27 = 0; n27 < n12; ++n27) {
                nArrayArray4[n3][n27] = nArray5[n4++];
            }
        }
        assert (CompressingTermVectorsReader.sum(nArray4) == n23) : CompressingTermVectorsReader.sum(nArray4) + " != " + n23;
        return new TVFields(nArray2, nArray15, nArray3, nArray16, nArray4, nArrayArray, nArrayArray2, nArrayArray4, nArray6, (int[][])object4, (int[][])object2, (int[][])object, bytesRef2, nArrayArray3, bytesRef);
    }

    private int[][] positionIndex(int n2, int n3, PackedInts.Reader reader, int[] nArray) {
        int n4;
        int n5;
        int[][] nArrayArray = new int[n3][];
        int n6 = 0;
        for (n5 = 0; n5 < n2; ++n5) {
            n4 = (int)reader.get(n5);
            n6 += n4;
        }
        for (n5 = 0; n5 < n3; ++n5) {
            n4 = (int)reader.get(n2 + n5);
            nArrayArray[n5] = new int[n4 + 1];
            for (int i2 = 0; i2 < n4; ++i2) {
                int n7 = nArray[n6 + i2];
                nArrayArray[n5][i2 + 1] = nArrayArray[n5][i2] + n7;
            }
            n6 += n4;
        }
        return nArrayArray;
    }

    private int[][] readPositions(int n2, int n3, PackedInts.Reader reader, PackedInts.Reader reader2, int[] nArray, int n4, int n5, int[][] nArray2) throws IOException {
        int n6;
        int n7;
        int n8;
        int[][] nArrayArray = new int[n3][];
        this.reader.reset(this.vectorsStream, n5);
        int n9 = 0;
        int n10 = 0;
        for (n8 = 0; n8 < n2; ++n8) {
            n7 = (int)reader.get(n8);
            n6 = (int)reader2.get(n8);
            if ((n7 & n4) != 0) {
                for (n7 = 0; n7 < n6; ++n7) {
                    int n11 = nArray[n10 + n7];
                    n9 += n11;
                }
            }
            n10 += n6;
        }
        this.reader.skip(n9);
        for (n8 = 0; n8 < n3; ++n8) {
            n7 = (int)reader.get(n2 + n8);
            n6 = (int)reader2.get(n2 + n8);
            if ((n7 & n4) == 0) continue;
            n7 = nArray2[n8][n6];
            int[] nArray3 = new int[n7];
            nArrayArray[n8] = nArray3;
            int n12 = 0;
            while (n12 < n7) {
                LongsRef longsRef = this.reader.next(n7 - n12);
                for (n10 = 0; n10 < longsRef.length; ++n10) {
                    nArray3[n12++] = (int)longsRef.longs[longsRef.offset + n10];
                }
            }
        }
        this.reader.skip((long)n5 - this.reader.ord());
        return nArrayArray;
    }

    private static int sum(int[] nArray) {
        int n2 = 0;
        for (int n3 : nArray) {
            n2 += n3;
        }
        return n2;
    }

    @Override
    public final long ramBytesUsed() {
        return this.indexReader.ramBytesUsed();
    }

    @Override
    public final Collection<org.apache.lucene.util.a> getChildResources() {
        return Collections.singleton(org.apache.lucene.util.b.a("term vector index", this.indexReader));
    }

    @Override
    public final void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.vectorsStream);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(mode=" + this.compressionMode + ",chunksize=" + this.chunkSize + ")";
    }

    private static class TVPostingsEnum
    extends PostingsEnum {
        private int doc = -1;
        private int termFreq;
        private int positionIndex;
        private int[] positions;
        private int[] startOffsets;
        private int[] lengths;
        private final BytesRef payload = new BytesRef();
        private int[] payloadIndex;
        private int basePayloadOffset;
        private int i;

        TVPostingsEnum() {
        }

        public void reset(int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, BytesRef bytesRef, int[] nArray4) {
            this.termFreq = n2;
            this.positionIndex = n3;
            this.positions = nArray;
            this.startOffsets = nArray2;
            this.lengths = nArray3;
            this.basePayloadOffset = bytesRef.offset;
            this.payload.bytes = bytesRef.bytes;
            this.payload.length = 0;
            this.payload.offset = 0;
            this.payloadIndex = nArray4;
            this.i = -1;
            this.doc = -1;
        }

        private void checkDoc() {
            if (this.doc == Integer.MAX_VALUE) {
                throw new IllegalStateException("DocsEnum exhausted");
            }
            if (this.doc == -1) {
                throw new IllegalStateException("DocsEnum not started");
            }
        }

        private void checkPosition() {
            this.checkDoc();
            if (this.i < 0) {
                throw new IllegalStateException("Position enum not started");
            }
            if (this.i >= this.termFreq) {
                throw new IllegalStateException("Read past last position");
            }
        }

        @Override
        public int nextPosition() throws IOException {
            if (this.doc != 0) {
                throw new IllegalStateException();
            }
            if (this.i >= this.termFreq - 1) {
                throw new IllegalStateException("Read past last position");
            }
            ++this.i;
            if (this.payloadIndex != null) {
                this.payload.offset = this.basePayloadOffset + this.payloadIndex[this.positionIndex + this.i];
                this.payload.length = this.payloadIndex[this.positionIndex + this.i + 1] - this.payloadIndex[this.positionIndex + this.i];
            }
            if (this.positions == null) {
                return -1;
            }
            return this.positions[this.positionIndex + this.i];
        }

        @Override
        public int startOffset() throws IOException {
            this.checkPosition();
            if (this.startOffsets == null) {
                return -1;
            }
            return this.startOffsets[this.positionIndex + this.i];
        }

        @Override
        public int endOffset() throws IOException {
            this.checkPosition();
            if (this.startOffsets == null) {
                return -1;
            }
            return this.startOffsets[this.positionIndex + this.i] + this.lengths[this.positionIndex + this.i];
        }

        @Override
        public BytesRef getPayload() throws IOException {
            this.checkPosition();
            if (this.payloadIndex == null || this.payload.length == 0) {
                return null;
            }
            return this.payload;
        }

        @Override
        public int freq() throws IOException {
            this.checkDoc();
            return this.termFreq;
        }

        @Override
        public int docID() {
            return this.doc;
        }

        @Override
        public int nextDoc() throws IOException {
            if (this.doc == -1) {
                this.doc = 0;
                return 0;
            }
            this.doc = Integer.MAX_VALUE;
            return Integer.MAX_VALUE;
        }

        @Override
        public int advance(int n2) throws IOException {
            return this.slowAdvance(n2);
        }

        @Override
        public long cost() {
            return 1L;
        }
    }

    private static class TVTermsEnum
    extends TermsEnum {
        private int numTerms;
        private int startPos;
        private int ord;
        private int[] prefixLengths;
        private int[] suffixLengths;
        private int[] termFreqs;
        private int[] positionIndex;
        private int[] positions;
        private int[] startOffsets;
        private int[] lengths;
        private int[] payloadIndex;
        private ByteArrayDataInput in;
        private BytesRef payloads;
        private final BytesRef term = new BytesRef(16);

        private TVTermsEnum() {
        }

        void reset(int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8, BytesRef bytesRef, ByteArrayDataInput byteArrayDataInput) {
            this.numTerms = n2;
            this.prefixLengths = nArray;
            this.suffixLengths = nArray2;
            this.termFreqs = nArray3;
            this.positionIndex = nArray4;
            this.positions = nArray5;
            this.startOffsets = nArray6;
            this.lengths = nArray7;
            this.payloadIndex = nArray8;
            this.payloads = bytesRef;
            this.in = byteArrayDataInput;
            this.startPos = byteArrayDataInput.getPosition();
            this.reset();
        }

        void reset() {
            this.term.length = 0;
            this.in.setPosition(this.startPos);
            this.ord = -1;
        }

        @Override
        public BytesRef next() throws IOException {
            if (this.ord == this.numTerms - 1) {
                return null;
            }
            assert (this.ord < this.numTerms);
            ++this.ord;
            this.term.offset = 0;
            this.term.length = this.prefixLengths[this.ord] + this.suffixLengths[this.ord];
            if (this.term.length > this.term.bytes.length) {
                this.term.bytes = ArrayUtil.grow(this.term.bytes, this.term.length);
            }
            this.in.readBytes(this.term.bytes, this.prefixLengths[this.ord], this.suffixLengths[this.ord]);
            return this.term;
        }

        @Override
        public TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) throws IOException {
            int n2;
            if (this.ord < this.numTerms && this.ord >= 0) {
                n2 = this.term().compareTo(bytesRef);
                if (n2 == 0) {
                    return TermsEnum.SeekStatus.FOUND;
                }
                if (n2 > 0) {
                    this.reset();
                }
            }
            do {
                BytesRef bytesRef2;
                if ((bytesRef2 = this.next()) == null) {
                    return TermsEnum.SeekStatus.END;
                }
                n2 = bytesRef2.compareTo(bytesRef);
                if (n2 <= 0) continue;
                return TermsEnum.SeekStatus.NOT_FOUND;
            } while (n2 != 0);
            return TermsEnum.SeekStatus.FOUND;
        }

        @Override
        public void seekExact(long l2) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public BytesRef term() throws IOException {
            return this.term;
        }

        @Override
        public long ord() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int docFreq() throws IOException {
            return 1;
        }

        @Override
        public long totalTermFreq() throws IOException {
            return this.termFreqs[this.ord];
        }

        @Override
        public final PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
            if (PostingsEnum.featureRequested(n2, (short)16384) && this.positions == null && this.startOffsets == null) {
                return null;
            }
            postingsEnum = postingsEnum != null && postingsEnum instanceof TVPostingsEnum ? (TVPostingsEnum)postingsEnum : new TVPostingsEnum();
            ((TVPostingsEnum)postingsEnum).reset(this.termFreqs[this.ord], this.positionIndex[this.ord], this.positions, this.startOffsets, this.lengths, this.payloads, this.payloadIndex);
            return postingsEnum;
        }
    }

    private class TVTerms
    extends Terms {
        private final int numTerms;
        private final int flags;
        private final int[] prefixLengths;
        private final int[] suffixLengths;
        private final int[] termFreqs;
        private final int[] positionIndex;
        private final int[] positions;
        private final int[] startOffsets;
        private final int[] lengths;
        private final int[] payloadIndex;
        private final BytesRef termBytes;
        private final BytesRef payloadBytes;

        TVTerms(int n2, int n3, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[] nArray6, int[] nArray7, int[] nArray8, BytesRef bytesRef, BytesRef bytesRef2) {
            this.numTerms = n2;
            this.flags = n3;
            this.prefixLengths = nArray;
            this.suffixLengths = nArray2;
            this.termFreqs = nArray3;
            this.positionIndex = nArray4;
            this.positions = nArray5;
            this.startOffsets = nArray6;
            this.lengths = nArray7;
            this.payloadIndex = nArray8;
            this.payloadBytes = bytesRef;
            this.termBytes = bytesRef2;
        }

        @Override
        public TermsEnum iterator() throws IOException {
            TVTermsEnum tVTermsEnum = new TVTermsEnum();
            tVTermsEnum.reset(this.numTerms, this.flags, this.prefixLengths, this.suffixLengths, this.termFreqs, this.positionIndex, this.positions, this.startOffsets, this.lengths, this.payloadIndex, this.payloadBytes, new ByteArrayDataInput(this.termBytes.bytes, this.termBytes.offset, this.termBytes.length));
            return tVTermsEnum;
        }

        @Override
        public long size() throws IOException {
            return this.numTerms;
        }

        @Override
        public long getSumTotalTermFreq() throws IOException {
            return -1L;
        }

        @Override
        public long getSumDocFreq() throws IOException {
            return this.numTerms;
        }

        @Override
        public int getDocCount() throws IOException {
            return 1;
        }

        @Override
        public boolean hasFreqs() {
            return true;
        }

        @Override
        public boolean hasOffsets() {
            return (this.flags & 2) != 0;
        }

        @Override
        public boolean hasPositions() {
            return (this.flags & 1) != 0;
        }

        @Override
        public boolean hasPayloads() {
            return (this.flags & 4) != 0;
        }
    }

    private class TVFields
    extends Fields {
        private final int[] fieldNums;
        private final int[] fieldFlags;
        private final int[] fieldNumOffs;
        private final int[] numTerms;
        private final int[] fieldLengths;
        private final int[][] prefixLengths;
        private final int[][] suffixLengths;
        private final int[][] termFreqs;
        private final int[][] positionIndex;
        private final int[][] positions;
        private final int[][] startOffsets;
        private final int[][] lengths;
        private final int[][] payloadIndex;
        private final BytesRef suffixBytes;
        private final BytesRef payloadBytes;

        public TVFields(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, int[] nArray5, int[][] nArray6, int[][] nArray7, int[][] nArray8, int[][] nArray9, int[][] nArray10, int[][] nArray11, int[][] nArray12, BytesRef bytesRef, int[][] nArray13, BytesRef bytesRef2) {
            this.fieldNums = nArray;
            this.fieldFlags = nArray2;
            this.fieldNumOffs = nArray3;
            this.numTerms = nArray4;
            this.fieldLengths = nArray5;
            this.prefixLengths = nArray6;
            this.suffixLengths = nArray7;
            this.termFreqs = nArray8;
            this.positionIndex = nArray9;
            this.positions = nArray10;
            this.startOffsets = nArray11;
            this.lengths = nArray12;
            this.payloadBytes = bytesRef;
            this.payloadIndex = nArray13;
            this.suffixBytes = bytesRef2;
        }

        @Override
        public Iterator<String> iterator() {
            return new Iterator<String>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < TVFields.this.fieldNumOffs.length;
                }

                @Override
                public String next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int n2 = TVFields.this.fieldNums[TVFields.this.fieldNumOffs[this.i++]];
                    return ((CompressingTermVectorsReader)CompressingTermVectorsReader.this).fieldInfos.fieldInfo((int)n2).name;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public Terms terms(String object) throws IOException {
            int n2;
            object = CompressingTermVectorsReader.this.fieldInfos.fieldInfo((String)object);
            if (object == null) {
                return null;
            }
            int n3 = -1;
            for (n2 = 0; n2 < this.fieldNumOffs.length; ++n2) {
                if (this.fieldNums[this.fieldNumOffs[n2]] != ((FieldInfo)object).number) continue;
                n3 = n2;
                break;
            }
            if (n3 == -1 || this.numTerms[n3] == 0) {
                return null;
            }
            n2 = 0;
            int n4 = -1;
            for (int i2 = 0; i2 < this.fieldNumOffs.length; ++i2) {
                if (i2 < n3) {
                    n2 += this.fieldLengths[i2];
                    continue;
                }
                n4 = this.fieldLengths[i2];
                break;
            }
            assert (n4 >= 0);
            return new TVTerms(this.numTerms[n3], this.fieldFlags[n3], this.prefixLengths[n3], this.suffixLengths[n3], this.termFreqs[n3], this.positionIndex[n3], this.positions[n3], this.startOffsets[n3], this.lengths[n3], this.payloadIndex[n3], this.payloadBytes, new BytesRef(this.suffixBytes.bytes, this.suffixBytes.offset + n2, n4));
        }

        @Override
        public int size() {
            return this.fieldNumOffs.length;
        }
    }
}

