/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsIndexReader;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.compressing.b;
import org.apache.lucene.codecs.n;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.c;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.a;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingStoredFieldsReader
extends n {
    private final int version;
    private final FieldInfos fieldInfos;
    private final CompressingStoredFieldsIndexReader indexReader;
    private final long maxPointer;
    private final IndexInput fieldsStream;
    private final int chunkSize;
    private final int packedIntsVersion;
    private final CompressionMode compressionMode;
    private final b decompressor;
    private final int numDocs;
    private final boolean merging;
    private final BlockState state;
    private final long numChunks;
    private final long numDirtyChunks;
    private boolean closed;

    private CompressingStoredFieldsReader(CompressingStoredFieldsReader compressingStoredFieldsReader, boolean bl) {
        this.version = compressingStoredFieldsReader.version;
        this.fieldInfos = compressingStoredFieldsReader.fieldInfos;
        this.fieldsStream = compressingStoredFieldsReader.fieldsStream.clone();
        this.indexReader = compressingStoredFieldsReader.indexReader.clone();
        this.maxPointer = compressingStoredFieldsReader.maxPointer;
        this.chunkSize = compressingStoredFieldsReader.chunkSize;
        this.packedIntsVersion = compressingStoredFieldsReader.packedIntsVersion;
        this.compressionMode = compressingStoredFieldsReader.compressionMode;
        this.decompressor = compressingStoredFieldsReader.decompressor.clone();
        this.numDocs = compressingStoredFieldsReader.numDocs;
        this.numChunks = compressingStoredFieldsReader.numChunks;
        this.numDirtyChunks = compressingStoredFieldsReader.numDirtyChunks;
        this.merging = bl;
        this.state = new BlockState();
        this.closed = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CompressingStoredFieldsReader(c c2, SegmentInfo segmentInfo, String string, FieldInfos fieldInfos, IOContext iOContext, String string2, CompressionMode compressionMode) throws IOException {
        Object object;
        Object object2;
        CompressingStoredFieldsIndexReader compressingStoredFieldsIndexReader;
        long l2;
        int n2;
        String string3;
        block19: {
            this.compressionMode = compressionMode;
            string3 = segmentInfo.name;
            this.fieldInfos = fieldInfos;
            this.numDocs = segmentInfo.maxDoc();
            n2 = -1;
            l2 = -1L;
            compressingStoredFieldsIndexReader = null;
            object2 = IndexFileNames.segmentFileName(string3, string, "fdx");
            object2 = c2.openChecksumInput((String)object2, iOContext);
            object = null;
            try {
                block18: {
                    try {
                        String string4 = string2 + "Index";
                        n2 = CodecUtil.checkIndexHeader((DataInput)object2, string4, 0, 1, segmentInfo.getId(), string);
                        assert ((long)CodecUtil.indexHeaderLength(string4, string) == ((IndexInput)object2).getFilePointer());
                        compressingStoredFieldsIndexReader = new CompressingStoredFieldsIndexReader((IndexInput)object2, segmentInfo);
                        l2 = ((DataInput)object2).readVLong();
                    }
                    catch (Throwable throwable) {
                        CodecUtil.checkFooter((org.apache.lucene.store.b)object2, throwable);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        CodecUtil.checkFooter((org.apache.lucene.store.b)object2, null);
                        throw throwable;
                    }
                    CodecUtil.checkFooter((org.apache.lucene.store.b)object2, null);
                }
                if (object2 == null) break block19;
            }
            catch (Throwable throwable) {
                try {
                    Throwable throwable2 = throwable;
                    object = throwable;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    if (object2 == null) throw throwable3;
                    if (object == null) {
                        ((IndexInput)object2).close();
                        throw throwable3;
                    }
                    try {
                        ((IndexInput)object2).close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        ((Throwable)object).addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
            }
            ((IndexInput)object2).close();
        }
        this.version = n2;
        this.maxPointer = l2;
        this.indexReader = compressingStoredFieldsIndexReader;
        object2 = IndexFileNames.segmentFileName(string3, string, "fdt");
        try {
            this.fieldsStream = c2.openInput((String)object2, iOContext);
            object = string2 + "Data";
            int n3 = CodecUtil.checkIndexHeader(this.fieldsStream, (String)object, 0, 1, segmentInfo.getId(), string);
            if (n2 != n3) {
                throw new CorruptIndexException("Version mismatch between stored fields index and data: " + n2 + " != " + n3, this.fieldsStream);
            }
            assert ((long)CodecUtil.indexHeaderLength((String)object, string) == this.fieldsStream.getFilePointer());
            this.chunkSize = this.fieldsStream.readVInt();
            this.packedIntsVersion = this.fieldsStream.readVInt();
            this.decompressor = compressionMode.newDecompressor();
            this.merging = false;
            this.state = new BlockState();
            if (n2 > 0) {
                this.fieldsStream.seek(l2);
                this.numChunks = this.fieldsStream.readVLong();
                this.numDirtyChunks = this.fieldsStream.readVLong();
                if (this.numDirtyChunks > this.numChunks) {
                    throw new CorruptIndexException("invalid chunk counts: dirty=" + this.numDirtyChunks + ", total=" + this.numChunks, this.fieldsStream);
                }
            } else {
                this.numDirtyChunks = -1L;
                this.numChunks = -1L;
            }
            CodecUtil.retrieveChecksum(this.fieldsStream);
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    private void ensureOpen() throws org.apache.lucene.store.a {
        if (this.closed) {
            throw new org.apache.lucene.store.a("this FieldsReader is closed");
        }
    }

    @Override
    public final void close() throws IOException {
        if (!this.closed) {
            IOUtils.close(this.fieldsStream);
            this.closed = true;
        }
    }

    private static void readField(DataInput dataInput, StoredFieldVisitor storedFieldVisitor, FieldInfo fieldInfo, int n2) throws IOException {
        switch (n2 & CompressingStoredFieldsWriter.TYPE_MASK) {
            case 1: {
                n2 = dataInput.readVInt();
                byte[] byArray = new byte[n2];
                dataInput.readBytes(byArray, 0, n2);
                storedFieldVisitor.binaryField(fieldInfo, byArray);
                return;
            }
            case 0: {
                n2 = dataInput.readVInt();
                byte[] byArray = new byte[n2];
                dataInput.readBytes(byArray, 0, n2);
                storedFieldVisitor.stringField(fieldInfo, byArray);
                return;
            }
            case 2: {
                storedFieldVisitor.intField(fieldInfo, dataInput.readZInt());
                return;
            }
            case 3: {
                storedFieldVisitor.floatField(fieldInfo, CompressingStoredFieldsReader.readZFloat(dataInput));
                return;
            }
            case 4: {
                storedFieldVisitor.longField(fieldInfo, CompressingStoredFieldsReader.readTLong(dataInput));
                return;
            }
            case 5: {
                storedFieldVisitor.doubleField(fieldInfo, CompressingStoredFieldsReader.readZDouble(dataInput));
                return;
            }
        }
        throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(n2)));
    }

    private static void skipField(DataInput dataInput, int n2) throws IOException {
        switch (n2 & CompressingStoredFieldsWriter.TYPE_MASK) {
            case 0: 
            case 1: {
                n2 = dataInput.readVInt();
                dataInput.skipBytes(n2);
                return;
            }
            case 2: {
                dataInput.readZInt();
                return;
            }
            case 3: {
                CompressingStoredFieldsReader.readZFloat(dataInput);
                return;
            }
            case 4: {
                CompressingStoredFieldsReader.readTLong(dataInput);
                return;
            }
            case 5: {
                CompressingStoredFieldsReader.readZDouble(dataInput);
                return;
            }
        }
        throw new AssertionError((Object)("Unknown type flag: " + Integer.toHexString(n2)));
    }

    static float readZFloat(DataInput dataInput) throws IOException {
        int n2 = dataInput.readByte() & 0xFF;
        if (n2 == 255) {
            return Float.intBitsToFloat(dataInput.readInt());
        }
        if ((n2 & 0x80) != 0) {
            return (n2 & 0x7F) - 1;
        }
        return Float.intBitsToFloat(n2 << 24 | (dataInput.readShort() & 0xFFFF) << 8 | dataInput.readByte() & 0xFF);
    }

    static double readZDouble(DataInput dataInput) throws IOException {
        int n2 = dataInput.readByte() & 0xFF;
        if (n2 == 255) {
            return Double.longBitsToDouble(dataInput.readLong());
        }
        if (n2 == 254) {
            return Float.intBitsToFloat(dataInput.readInt());
        }
        if ((n2 & 0x80) != 0) {
            return (n2 & 0x7F) - 1;
        }
        return Double.longBitsToDouble((long)n2 << 56 | ((long)dataInput.readInt() & 0xFFFFFFFFL) << 24 | ((long)dataInput.readShort() & 0xFFFFL) << 8 | (long)dataInput.readByte() & 0xFFL);
    }

    static long readTLong(DataInput dataInput) throws IOException {
        int n2 = dataInput.readByte() & 0xFF;
        long l2 = n2 & 0x1F;
        if ((n2 & 0x20) != 0) {
            l2 |= dataInput.readVLong() << 5;
        }
        long l3 = BitUtil.zigZagDecode(l2);
        switch (n2 & 0xC0) {
            case 64: {
                l3 *= 1000L;
                break;
            }
            case 128: {
                l3 *= 3600000L;
                break;
            }
            case 192: {
                l3 *= 86400000L;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return l3;
    }

    final SerializedDocument document(int n2) throws IOException {
        if (!this.state.contains(n2)) {
            this.fieldsStream.seek(this.indexReader.getStartPointer(n2));
            this.state.reset(n2);
        }
        assert (this.state.contains(n2));
        return this.state.document(n2);
    }

    @Override
    public final void visitDocument(int n2, StoredFieldVisitor storedFieldVisitor) throws IOException {
        SerializedDocument serializedDocument = this.document(n2);
        block5: for (int i2 = 0; i2 < serializedDocument.numStoredFields; ++i2) {
            long l2 = serializedDocument.in.readVLong();
            int n3 = (int)(l2 >>> CompressingStoredFieldsWriter.TYPE_BITS);
            FieldInfo fieldInfo = this.fieldInfos.fieldInfo(n3);
            int n4 = (int)(l2 & (long)CompressingStoredFieldsWriter.TYPE_MASK);
            assert (n4 <= 5) : "bits=" + Integer.toHexString(n4);
            switch (storedFieldVisitor.needsField(fieldInfo)) {
                case YES: {
                    CompressingStoredFieldsReader.readField(serializedDocument.in, storedFieldVisitor, fieldInfo, n4);
                    continue block5;
                }
                case NO: {
                    CompressingStoredFieldsReader.skipField(serializedDocument.in, n4);
                    continue block5;
                }
                case STOP: {
                    return;
                }
            }
        }
    }

    @Override
    public final n clone() {
        this.ensureOpen();
        return new CompressingStoredFieldsReader(this, false);
    }

    @Override
    public final n getMergeInstance() {
        this.ensureOpen();
        return new CompressingStoredFieldsReader(this, true);
    }

    final int getVersion() {
        return this.version;
    }

    final CompressionMode getCompressionMode() {
        return this.compressionMode;
    }

    final CompressingStoredFieldsIndexReader getIndexReader() {
        return this.indexReader;
    }

    final long getMaxPointer() {
        return this.maxPointer;
    }

    final IndexInput getFieldsStream() {
        return this.fieldsStream;
    }

    final int getChunkSize() {
        return this.chunkSize;
    }

    final long getNumChunks() {
        return this.numChunks;
    }

    final long getNumDirtyChunks() {
        return this.numDirtyChunks;
    }

    final int getPackedIntsVersion() {
        return this.packedIntsVersion;
    }

    @Override
    public final long ramBytesUsed() {
        return this.indexReader.ramBytesUsed();
    }

    @Override
    public final Collection<a> getChildResources() {
        return Collections.singleton(org.apache.lucene.util.b.a("stored field index", this.indexReader));
    }

    @Override
    public final void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.fieldsStream);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(mode=" + this.compressionMode + ",chunksize=" + this.chunkSize + ")";
    }

    private class BlockState {
        private int docBase;
        private int chunkDocs;
        private boolean sliced;
        private int[] offsets = IntsRef.EMPTY_INTS;
        private int[] numStoredFields = IntsRef.EMPTY_INTS;
        private long startPointer;
        private final BytesRef spare = new BytesRef();
        private final BytesRef bytes = new BytesRef();

        private BlockState() {
        }

        boolean contains(int n2) {
            return n2 >= this.docBase && n2 < this.docBase + this.chunkDocs;
        }

        void reset(int n2) throws IOException {
            try {
                this.doReset(n2);
                return;
            }
            catch (Throwable throwable) {
                this.chunkDocs = 0;
                throw throwable;
            }
        }

        private void doReset(int n2) throws IOException {
            int n3;
            this.docBase = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            int n4 = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            this.chunkDocs = n4 >>> 1;
            if (!this.contains(n2) || this.docBase + this.chunkDocs > CompressingStoredFieldsReader.this.numDocs) {
                throw new CorruptIndexException("Corrupted: docID=" + n2 + ", docBase=" + this.docBase + ", chunkDocs=" + this.chunkDocs + ", numDocs=" + CompressingStoredFieldsReader.this.numDocs, CompressingStoredFieldsReader.this.fieldsStream);
            }
            this.sliced = (n4 & 1) != 0;
            this.offsets = ArrayUtil.grow(this.offsets, this.chunkDocs + 1);
            this.numStoredFields = ArrayUtil.grow(this.numStoredFields, this.chunkDocs);
            if (this.chunkDocs == 1) {
                this.numStoredFields[0] = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                this.offsets[1] = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
            } else {
                int n5;
                n2 = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (n2 == 0) {
                    Arrays.fill(this.numStoredFields, 0, this.chunkDocs, CompressingStoredFieldsReader.this.fieldsStream.readVInt());
                } else {
                    if (n2 > 31) {
                        throw new CorruptIndexException("bitsPerStoredFields=" + n2, CompressingStoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.c c2 = PackedInts.getReaderIteratorNoHeader(CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, CompressingStoredFieldsReader.this.packedIntsVersion, this.chunkDocs, n2, 1);
                    for (n5 = 0; n5 < this.chunkDocs; ++n5) {
                        this.numStoredFields[n5] = (int)c2.next();
                    }
                }
                n4 = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                if (n4 == 0) {
                    n5 = CompressingStoredFieldsReader.this.fieldsStream.readVInt();
                    for (n2 = 0; n2 < this.chunkDocs; ++n2) {
                        this.offsets[n2 + 1] = (n2 + 1) * n5;
                    }
                } else {
                    if (n2 > 31) {
                        throw new CorruptIndexException("bitsPerLength=" + n4, CompressingStoredFieldsReader.this.fieldsStream);
                    }
                    PackedInts.c c3 = PackedInts.getReaderIteratorNoHeader(CompressingStoredFieldsReader.this.fieldsStream, PackedInts.Format.PACKED, CompressingStoredFieldsReader.this.packedIntsVersion, this.chunkDocs, n4, 1);
                    for (n2 = 0; n2 < this.chunkDocs; ++n2) {
                        this.offsets[n2 + 1] = (int)c3.next();
                    }
                    for (n2 = 0; n2 < this.chunkDocs; ++n2) {
                        int n6 = n2 + 1;
                        this.offsets[n6] = this.offsets[n6] + this.offsets[n2];
                    }
                }
                for (n3 = 0; n3 < this.chunkDocs; ++n3) {
                    n2 = this.offsets[n3 + 1] - this.offsets[n3];
                    if (n2 == 0 == ((n4 = this.numStoredFields[n3]) == 0)) continue;
                    throw new CorruptIndexException("length=" + n2 + ", numStoredFields=" + n4, CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
            this.startPointer = CompressingStoredFieldsReader.this.fieldsStream.getFilePointer();
            if (CompressingStoredFieldsReader.this.merging) {
                n2 = this.offsets[this.chunkDocs];
                if (this.sliced) {
                    this.bytes.length = 0;
                    this.bytes.offset = 0;
                    for (n4 = 0; n4 < n2; n4 += n3) {
                        n3 = Math.min(n2 - n4, CompressingStoredFieldsReader.this.chunkSize);
                        CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, n3, 0, n3, this.spare);
                        this.bytes.bytes = ArrayUtil.grow(this.bytes.bytes, this.bytes.length + this.spare.length);
                        System.arraycopy(this.spare.bytes, this.spare.offset, this.bytes.bytes, this.bytes.length, this.spare.length);
                        this.bytes.length += this.spare.length;
                    }
                } else {
                    CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, n2, 0, n2, this.bytes);
                }
                if (this.bytes.length != n2) {
                    throw new CorruptIndexException("Corrupted: expected chunk size = " + n2 + ", got " + this.bytes.length, CompressingStoredFieldsReader.this.fieldsStream);
                }
            }
        }

        SerializedDocument document(int n2) throws IOException {
            DataInput dataInput;
            if (!this.contains(n2)) {
                throw new IllegalArgumentException();
            }
            int n3 = this.offsets[n2 -= this.docBase];
            final int n4 = this.offsets[n2 + 1] - n3;
            int n5 = this.offsets[this.chunkDocs];
            n2 = this.numStoredFields[n2];
            if (n4 == 0) {
                dataInput = new ByteArrayDataInput();
            } else if (CompressingStoredFieldsReader.this.merging) {
                dataInput = new ByteArrayDataInput(this.bytes.bytes, this.bytes.offset + n3, n4);
            } else if (this.sliced) {
                CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, CompressingStoredFieldsReader.this.chunkSize, n3, Math.min(n4, CompressingStoredFieldsReader.this.chunkSize - n3), this.bytes);
                dataInput = new DataInput(){
                    int decompressed;
                    {
                        this.decompressed = ((BlockState)BlockState.this).bytes.length;
                    }

                    void fillBuffer() throws IOException {
                        assert (this.decompressed <= n4);
                        if (this.decompressed == n4) {
                            throw new EOFException();
                        }
                        int n2 = Math.min(n4 - this.decompressed, CompressingStoredFieldsReader.this.chunkSize);
                        CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, n2, 0, n2, BlockState.this.bytes);
                        this.decompressed += n2;
                    }

                    @Override
                    public byte readByte() throws IOException {
                        if (((BlockState)BlockState.this).bytes.length == 0) {
                            this.fillBuffer();
                        }
                        --((BlockState)BlockState.this).bytes.length;
                        return ((BlockState)BlockState.this).bytes.bytes[((BlockState)BlockState.this).bytes.offset++];
                    }

                    @Override
                    public void readBytes(byte[] byArray, int n2, int n3) throws IOException {
                        while (n3 > ((BlockState)BlockState.this).bytes.length) {
                            System.arraycopy(((BlockState)BlockState.this).bytes.bytes, ((BlockState)BlockState.this).bytes.offset, byArray, n2, ((BlockState)BlockState.this).bytes.length);
                            n3 -= ((BlockState)BlockState.this).bytes.length;
                            n2 += ((BlockState)BlockState.this).bytes.length;
                            this.fillBuffer();
                        }
                        System.arraycopy(((BlockState)BlockState.this).bytes.bytes, ((BlockState)BlockState.this).bytes.offset, byArray, n2, n3);
                        ((BlockState)BlockState.this).bytes.offset += n3;
                        ((BlockState)BlockState.this).bytes.length -= n3;
                    }
                };
            } else {
                CompressingStoredFieldsReader.this.fieldsStream.seek(this.startPointer);
                CompressingStoredFieldsReader.this.decompressor.decompress(CompressingStoredFieldsReader.this.fieldsStream, n5, n3, n4, this.bytes);
                assert (this.bytes.length == n4);
                dataInput = new ByteArrayDataInput(this.bytes.bytes, this.bytes.offset, this.bytes.length);
            }
            return new SerializedDocument(dataInput, n4, n2);
        }
    }

    static class SerializedDocument {
        final DataInput in;
        final int length;
        final int numStoredFields;

        private SerializedDocument(DataInput dataInput, int n2, int n3) {
            this.in = dataInput;
            this.length = n2;
            this.numStoredFields = n3;
        }
    }
}

