/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;
import org.apache.lucene.util.b;
import org.apache.lucene.util.packed.PackedInts;

public final class CompressingStoredFieldsIndexReader
implements Cloneable,
a {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(CompressingStoredFieldsIndexReader.class);
    final int maxDoc;
    final int[] docBases;
    final long[] startPointers;
    final int[] avgChunkDocs;
    final long[] avgChunkSizes;
    final PackedInts.Reader[] docBasesDeltas;
    final PackedInts.Reader[] startPointersDeltas;

    CompressingStoredFieldsIndexReader(IndexInput indexInput, SegmentInfo object) throws IOException {
        int n2;
        this.maxDoc = ((SegmentInfo)object).maxDoc();
        object = new int[16];
        long[] lArray = new long[16];
        int[] nArray = new int[16];
        long[] lArray2 = new long[16];
        PackedInts.Reader[] readerArray = new PackedInts.Reader[16];
        PackedInts.Reader[] readerArray2 = new PackedInts.Reader[16];
        int n3 = indexInput.readVInt();
        int n4 = 0;
        while ((n2 = indexInput.readVInt()) != 0) {
            int n5;
            if (n4 == ((Object)object).length) {
                n5 = ArrayUtil.oversize(n4 + 1, 8);
                object = Arrays.copyOf((int[])object, n5);
                lArray = Arrays.copyOf(lArray, n5);
                nArray = Arrays.copyOf(nArray, n5);
                lArray2 = Arrays.copyOf(lArray2, n5);
                readerArray = Arrays.copyOf(readerArray, n5);
                readerArray2 = Arrays.copyOf(readerArray2, n5);
            }
            object[n4] = indexInput.readVInt();
            nArray[n4] = indexInput.readVInt();
            n5 = indexInput.readVInt();
            if (n5 > 32) {
                throw new CorruptIndexException("Corrupted bitsPerDocBase: " + n5, indexInput);
            }
            readerArray[n4] = PackedInts.getReaderNoHeader(indexInput, PackedInts.Format.PACKED, n3, n2, n5);
            lArray[n4] = indexInput.readVLong();
            lArray2[n4] = indexInput.readVLong();
            n5 = indexInput.readVInt();
            if (n5 > 64) {
                throw new CorruptIndexException("Corrupted bitsPerStartPointer: " + n5, indexInput);
            }
            readerArray2[n4] = PackedInts.getReaderNoHeader(indexInput, PackedInts.Format.PACKED, n3, n2, n5);
            ++n4;
        }
        this.docBases = Arrays.copyOf((int[])object, n4);
        this.startPointers = Arrays.copyOf(lArray, n4);
        this.avgChunkDocs = Arrays.copyOf(nArray, n4);
        this.avgChunkSizes = Arrays.copyOf(lArray2, n4);
        this.docBasesDeltas = Arrays.copyOf(readerArray, n4);
        this.startPointersDeltas = Arrays.copyOf(readerArray2, n4);
    }

    private int block(int n2) {
        int n3 = 0;
        int n4 = this.docBases.length - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            int n6 = this.docBases[n5];
            if (n6 == n2) {
                return n5;
            }
            if (n6 < n2) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5 - 1;
        }
        return n4;
    }

    private int relativeDocBase(int n2, int n3) {
        int n4 = this.avgChunkDocs[n2] * n3;
        long l2 = BitUtil.zigZagDecode(this.docBasesDeltas[n2].get(n3));
        return n4 + (int)l2;
    }

    private long relativeStartPointer(int n2, int n3) {
        long l2 = this.avgChunkSizes[n2] * (long)n3;
        long l3 = BitUtil.zigZagDecode(this.startPointersDeltas[n2].get(n3));
        return l2 + l3;
    }

    private int relativeChunk(int n2, int n3) {
        int n4 = 0;
        int n5 = this.docBasesDeltas[n2].size() - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            int n7 = this.relativeDocBase(n2, n6);
            if (n7 == n3) {
                return n6;
            }
            if (n7 < n3) {
                n4 = n6 + 1;
                continue;
            }
            n5 = n6 - 1;
        }
        return n5;
    }

    final long getStartPointer(int n2) {
        if (n2 < 0 || n2 >= this.maxDoc) {
            throw new IllegalArgumentException("docID out of range [0-" + this.maxDoc + "]: " + n2);
        }
        int n3 = this.block(n2);
        n2 = this.relativeChunk(n3, n2 - this.docBases[n3]);
        return this.startPointers[n3] + this.relativeStartPointer(n3, n2);
    }

    public final CompressingStoredFieldsIndexReader clone() {
        return this;
    }

    @Override
    public final long ramBytesUsed() {
        PackedInts.Reader reader;
        int n2;
        long l2 = BASE_RAM_BYTES_USED + RamUsageEstimator.shallowSizeOf(this.docBasesDeltas);
        PackedInts.Reader[] readerArray = this.docBasesDeltas;
        int n3 = this.docBasesDeltas.length;
        for (n2 = 0; n2 < n3; ++n2) {
            reader = readerArray[n2];
            l2 += reader.ramBytesUsed();
        }
        l2 += RamUsageEstimator.shallowSizeOf(this.startPointersDeltas);
        readerArray = this.startPointersDeltas;
        n3 = this.startPointersDeltas.length;
        for (n2 = 0; n2 < n3; ++n2) {
            reader = readerArray[n2];
            l2 += reader.ramBytesUsed();
        }
        return l2 + RamUsageEstimator.sizeOf(this.docBases) + RamUsageEstimator.sizeOf(this.startPointers) + RamUsageEstimator.sizeOf(this.avgChunkDocs) + RamUsageEstimator.sizeOf(this.avgChunkSizes);
    }

    @Override
    public final Collection<a> getChildResources() {
        ArrayList<a> arrayList = new ArrayList<a>();
        long l2 = RamUsageEstimator.shallowSizeOf(this.docBasesDeltas);
        PackedInts.Reader[] readerArray = this.docBasesDeltas;
        int n2 = this.docBasesDeltas.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            PackedInts.Reader reader = readerArray[i2];
            l2 += reader.ramBytesUsed();
        }
        arrayList.add(b.a("doc base deltas", l2));
        long l3 = RamUsageEstimator.shallowSizeOf(this.startPointersDeltas);
        PackedInts.Reader[] readerArray2 = this.startPointersDeltas;
        int n3 = this.startPointersDeltas.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            PackedInts.Reader reader = readerArray2[i3];
            l3 += reader.ramBytesUsed();
        }
        arrayList.add(b.a("start pointer deltas", l3));
        return Collections.unmodifiableList(arrayList);
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(blocks=" + this.docBases.length + ")";
    }
}

