/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.compressing;

import java.io.IOException;
import org.apache.lucene.codecs.StoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsReader;
import org.apache.lucene.codecs.compressing.CompressingStoredFieldsWriter;
import org.apache.lucene.codecs.compressing.CompressionMode;
import org.apache.lucene.codecs.m;
import org.apache.lucene.codecs.n;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.c;

public class CompressingStoredFieldsFormat
extends m {
    private final String formatName;
    private final String segmentSuffix;
    private final CompressionMode compressionMode;
    private final int chunkSize;
    private final int maxDocsPerChunk;
    private final int blockSize;

    public CompressingStoredFieldsFormat(String string, CompressionMode compressionMode, int n2, int n3, int n4) {
        this(string, "", compressionMode, n2, n3, n4);
    }

    public CompressingStoredFieldsFormat(String string, String string2, CompressionMode compressionMode, int n2, int n3, int n4) {
        this.formatName = string;
        this.segmentSuffix = string2;
        this.compressionMode = compressionMode;
        if (n2 <= 0) {
            throw new IllegalArgumentException("chunkSize must be >= 1");
        }
        this.chunkSize = n2;
        if (n3 <= 0) {
            throw new IllegalArgumentException("maxDocsPerChunk must be >= 1");
        }
        this.maxDocsPerChunk = n3;
        if (n4 <= 0) {
            throw new IllegalArgumentException("blockSize must be >= 1");
        }
        this.blockSize = n4;
    }

    @Override
    public n fieldsReader(c c2, SegmentInfo segmentInfo, FieldInfos fieldInfos, IOContext iOContext) throws IOException {
        return new CompressingStoredFieldsReader(c2, segmentInfo, this.segmentSuffix, fieldInfos, iOContext, this.formatName, this.compressionMode);
    }

    @Override
    public StoredFieldsWriter fieldsWriter(c c2, SegmentInfo segmentInfo, IOContext iOContext) throws IOException {
        return new CompressingStoredFieldsWriter(c2, segmentInfo, this.segmentSuffix, iOContext, this.formatName, this.compressionMode, this.chunkSize, this.maxDocsPerChunk, this.blockSize);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(compressionMode=" + this.compressionMode + ", chunkSize=" + this.chunkSize + ", maxDocsPerChunk=" + this.maxDocsPerChunk + ", blockSize=" + this.blockSize + ")";
    }
}

