/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import org.apache.lucene.codecs.blocktree.FieldReader;
import org.apache.lucene.codecs.blocktree.IntersectTermsEnumFrame;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.RunAutomaton;
import org.apache.lucene.util.automaton.Transition;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.a;

final class IntersectTermsEnum
extends TermsEnum {
    final IndexInput in;
    static final a<BytesRef> fstOutputs = ByteSequenceOutputs.getSingleton();
    IntersectTermsEnumFrame[] stack;
    private FST.Arc<BytesRef>[] arcs = new FST.Arc[5];
    final RunAutomaton runAutomaton;
    final Automaton automaton;
    final BytesRef commonSuffix;
    private IntersectTermsEnumFrame currentFrame;
    private Transition currentTransition;
    private final BytesRef term = new BytesRef();
    private final FST.a fstReader;
    private final boolean allowAutoPrefixTerms;
    final FieldReader fr;
    private final int sinkState;
    private BytesRef savedStartTerm;
    private boolean useAutoPrefixTerm;
    private final Transition scratchTransition = new Transition();

    public IntersectTermsEnum(FieldReader fieldReader, Automaton automaton, RunAutomaton runAutomaton, BytesRef object, BytesRef bytesRef, int n2) throws IOException {
        int n3;
        this.fr = fieldReader;
        this.sinkState = n2;
        assert (automaton != null);
        assert (runAutomaton != null);
        this.runAutomaton = runAutomaton;
        this.allowAutoPrefixTerms = n2 != -1;
        this.automaton = automaton;
        this.commonSuffix = object;
        this.in = fieldReader.parent.termsIn.clone();
        this.stack = new IntersectTermsEnumFrame[5];
        for (n3 = 0; n3 < this.stack.length; ++n3) {
            this.stack[n3] = new IntersectTermsEnumFrame(this, n3);
        }
        for (n3 = 0; n3 < this.arcs.length; ++n3) {
            this.arcs[n3] = new FST.Arc();
        }
        this.fstReader = fieldReader.index == null ? null : fieldReader.index.getBytesReader();
        FST.Arc<BytesRef> arc = fieldReader.index.getFirstArc(this.arcs[0]);
        assert (arc.isFinal());
        object = this.stack[0];
        this.stack[0].fp = this.stack[0].fpOrig = fieldReader.rootBlockFP;
        ((IntersectTermsEnumFrame)object).prefix = 0;
        ((IntersectTermsEnumFrame)object).setState(runAutomaton.getInitialState());
        ((IntersectTermsEnumFrame)object).arc = arc;
        ((IntersectTermsEnumFrame)object).outputPrefix = (BytesRef)arc.output;
        ((IntersectTermsEnumFrame)object).load(fieldReader.rootCode);
        assert (this.setSavedStartTerm(bytesRef));
        this.currentFrame = object;
        if (bytesRef != null) {
            this.seekToStartTerm(bytesRef);
        }
        this.currentTransition = this.currentFrame.transition;
    }

    private boolean setSavedStartTerm(BytesRef bytesRef) {
        this.savedStartTerm = bytesRef == null ? null : BytesRef.deepCopyOf(bytesRef);
        return true;
    }

    @Override
    public final q termState() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.clone();
    }

    private IntersectTermsEnumFrame getFrame(int n2) throws IOException {
        if (n2 >= this.stack.length) {
            IntersectTermsEnumFrame[] intersectTermsEnumFrameArray = new IntersectTermsEnumFrame[ArrayUtil.oversize(n2 + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.stack, 0, intersectTermsEnumFrameArray, 0, this.stack.length);
            for (int i2 = this.stack.length; i2 < intersectTermsEnumFrameArray.length; ++i2) {
                intersectTermsEnumFrameArray[i2] = new IntersectTermsEnumFrame(this, i2);
            }
            this.stack = intersectTermsEnumFrameArray;
        }
        assert (this.stack[n2].ord == n2);
        return this.stack[n2];
    }

    private FST.Arc<BytesRef> getArc(int n2) {
        if (n2 >= this.arcs.length) {
            FST.Arc[] arcArray = new FST.Arc[ArrayUtil.oversize(n2 + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.arcs, 0, arcArray, 0, this.arcs.length);
            for (int i2 = this.arcs.length; i2 < arcArray.length; ++i2) {
                arcArray[i2] = new FST.Arc();
            }
            this.arcs = arcArray;
        }
        return this.arcs[n2];
    }

    private IntersectTermsEnumFrame pushFrame(int n2) throws IOException {
        assert (this.currentFrame != null);
        IntersectTermsEnumFrame intersectTermsEnumFrame = this.getFrame(this.currentFrame == null ? 0 : 1 + this.currentFrame.ord);
        this.getFrame(this.currentFrame == null ? 0 : 1 + this.currentFrame.ord).fp = this.getFrame(this.currentFrame == null ? 0 : 1 + this.currentFrame.ord).fpOrig = this.currentFrame.lastSubFP;
        intersectTermsEnumFrame.prefix = this.currentFrame.prefix + this.currentFrame.suffix;
        intersectTermsEnumFrame.setState(n2);
        FST.Arc<BytesRef> arc = this.currentFrame.arc;
        assert (this.currentFrame.suffix > 0);
        BytesRef bytesRef = this.currentFrame.outputPrefix;
        for (int i2 = this.currentFrame.prefix; i2 < intersectTermsEnumFrame.prefix; ++i2) {
            int n3 = this.term.bytes[i2] & 0xFF;
            arc = this.fr.index.findTargetArc(n3, arc, this.getArc(i2 + 1), this.fstReader);
            assert (arc != null);
            bytesRef = fstOutputs.add(bytesRef, (BytesRef)arc.output);
        }
        intersectTermsEnumFrame.arc = arc;
        intersectTermsEnumFrame.outputPrefix = bytesRef;
        assert (arc.isFinal());
        intersectTermsEnumFrame.load(fstOutputs.add(bytesRef, (BytesRef)arc.nextFinalOutput));
        return intersectTermsEnumFrame;
    }

    @Override
    public final BytesRef term() {
        return this.term;
    }

    @Override
    public final int docFreq() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.docFreq;
    }

    @Override
    public final long totalTermFreq() throws IOException {
        this.currentFrame.decodeMetaData();
        return this.currentFrame.termState.totalTermFreq;
    }

    @Override
    public final PostingsEnum postings(PostingsEnum postingsEnum, int n2) throws IOException {
        this.currentFrame.decodeMetaData();
        return this.fr.parent.postingsReader.postings(this.fr.fieldInfo, this.currentFrame.termState, postingsEnum, n2);
    }

    private int getState() {
        int n2 = this.currentFrame.state;
        for (int i2 = 0; i2 < this.currentFrame.suffix; ++i2) {
            n2 = this.runAutomaton.step(n2, this.currentFrame.suffixBytes[this.currentFrame.startBytePos + i2] & 0xFF);
            assert (n2 != -1);
        }
        return n2;
    }

    private void seekToStartTerm(BytesRef bytesRef) throws IOException {
        assert (this.currentFrame.ord == 0);
        if (this.term.length < bytesRef.length) {
            this.term.bytes = ArrayUtil.grow(this.term.bytes, bytesRef.length);
        }
        FST.Arc<BytesRef> arc = this.arcs[0];
        assert (arc == this.currentFrame.arc);
        for (int i2 = 0; i2 <= bytesRef.length; ++i2) {
            block10: {
                boolean bl;
                int n2;
                long l2;
                int n3;
                int n4;
                int n5;
                int n6;
                while (true) {
                    n6 = this.currentFrame.nextEnt;
                    n5 = this.currentFrame.suffixesReader.getPosition();
                    n4 = this.currentFrame.startBytePos;
                    n3 = this.currentFrame.suffix;
                    l2 = this.currentFrame.lastSubFP;
                    n2 = this.currentFrame.termState.termBlockOrd;
                    bl = this.currentFrame.isAutoPrefixTerm;
                    int n7 = this.currentFrame.next();
                    this.term.length = this.currentFrame.prefix + this.currentFrame.suffix;
                    if (this.term.bytes.length < this.term.length) {
                        this.term.bytes = ArrayUtil.grow(this.term.bytes, this.term.length);
                    }
                    System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
                    if (n7 != 0 && StringHelper.startsWith(bytesRef, this.term)) break block10;
                    n7 = this.term.compareTo(bytesRef);
                    if (n7 < 0) {
                        if (this.currentFrame.nextEnt != this.currentFrame.entCount) continue;
                        if (!this.currentFrame.isLastInFloor) {
                            this.currentFrame.loadNextFloorBlock();
                            continue;
                        }
                        return;
                    }
                    if (n7 == 0) {
                        if (!this.allowAutoPrefixTerms && this.currentFrame.isAutoPrefixTerm) continue;
                        return;
                    }
                    if (this.allowAutoPrefixTerms || !this.currentFrame.isAutoPrefixTerm) break;
                }
                this.currentFrame.nextEnt = n6;
                this.currentFrame.lastSubFP = l2;
                this.currentFrame.startBytePos = n4;
                this.currentFrame.suffix = n3;
                this.currentFrame.suffixesReader.setPosition(n5);
                this.currentFrame.termState.termBlockOrd = n2;
                this.currentFrame.isAutoPrefixTerm = bl;
                System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
                this.term.length = this.currentFrame.prefix + this.currentFrame.suffix;
                return;
            }
            this.currentFrame = this.pushFrame(this.getState());
        }
        assert (false);
    }

    private boolean popPushNext() throws IOException {
        while (this.currentFrame.nextEnt == this.currentFrame.entCount) {
            if (!this.currentFrame.isLastInFloor) {
                this.currentFrame.loadNextFloorBlock();
                break;
            }
            if (this.currentFrame.ord == 0) {
                throw NoMoreTermsException.INSTANCE;
            }
            long l2 = this.currentFrame.fpOrig;
            this.currentFrame = this.stack[this.currentFrame.ord - 1];
            this.currentTransition = this.currentFrame.transition;
            assert (this.currentFrame.lastSubFP == l2);
        }
        return this.currentFrame.next();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean skipPastLastAutoPrefixTerm() throws IOException {
        boolean bl;
        assert (this.currentFrame.isAutoPrefixTerm);
        this.useAutoPrefixTerm = false;
        this.currentFrame.termState.isRealTerm = true;
        int n2 = this.currentFrame.floorSuffixLeadEnd;
        if (n2 == -1) {
            int n3 = this.currentFrame.prefix;
            int n4 = this.currentFrame.suffix;
            if (n4 == 0) {
                if (this.currentFrame.ord == 0) {
                    throw NoMoreTermsException.INSTANCE;
                }
                this.currentFrame = this.stack[this.currentFrame.ord - 1];
                this.currentTransition = this.currentFrame.transition;
                return this.popPushNext();
            }
            block0: while (true) {
                if (this.currentFrame.nextEnt == this.currentFrame.entCount) {
                    if (!this.currentFrame.isLastInFloor) {
                        this.currentFrame.loadNextFloorBlock();
                    } else {
                        if (this.currentFrame.ord == 0) {
                            throw NoMoreTermsException.INSTANCE;
                        }
                        this.currentFrame = this.stack[this.currentFrame.ord - 1];
                        this.currentTransition = this.currentFrame.transition;
                        return this.popPushNext();
                    }
                }
                bl = this.currentFrame.next();
                int n5 = 0;
                while (true) {
                    if (n5 >= n4) continue block0;
                    if (this.term.bytes[n3 + n5] != this.currentFrame.suffixBytes[this.currentFrame.startBytePos + n5]) return bl;
                    ++n5;
                }
                break;
            }
        }
        int n6 = this.currentFrame.prefix;
        int n7 = this.currentFrame.suffix;
        if (this.currentFrame.floorSuffixLeadStart == -1) {
            ++n7;
        }
        if (n7 == 0) {
            if (this.currentFrame.ord == 0) {
                throw NoMoreTermsException.INSTANCE;
            }
            this.currentFrame = this.stack[this.currentFrame.ord - 1];
            this.currentTransition = this.currentFrame.transition;
            n6 = this.currentFrame.prefix;
            n7 = this.term.length - this.currentFrame.prefix;
        }
        do {
            if (this.currentFrame.nextEnt == this.currentFrame.entCount) {
                if (!this.currentFrame.isLastInFloor) {
                    this.currentFrame.loadNextFloorBlock();
                } else {
                    if (this.currentFrame.ord == 0) {
                        throw NoMoreTermsException.INSTANCE;
                    }
                    this.currentFrame = this.stack[this.currentFrame.ord - 1];
                    this.currentTransition = this.currentFrame.transition;
                    return this.popPushNext();
                }
            }
            bl = this.currentFrame.next();
            for (int i2 = 0; i2 < n7 - 1; ++i2) {
                if (this.term.bytes[n6 + i2] != this.currentFrame.suffixBytes[this.currentFrame.startBytePos + i2]) return bl;
            }
        } while (this.currentFrame.suffix < n7 || (this.currentFrame.suffixBytes[this.currentFrame.startBytePos + n7 - 1] & 0xFF) <= n2);
        return bl;
    }

    @Override
    public final BytesRef next() throws IOException {
        try {
            return this._next();
        }
        catch (NoMoreTermsException noMoreTermsException) {
            this.currentFrame = null;
            return null;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    private BytesRef _next() throws IOException {
        block27: {
            if (!this.useAutoPrefixTerm) break block27;
            var1_1 = this.skipPastLastAutoPrefixTerm();
            if (!IntersectTermsEnum.$assertionsDisabled && this.useAutoPrefixTerm) {
                throw new AssertionError();
            }
            ** GOTO lbl9
        }
        block0: while (true) {
            var1_1 = this.popPushNext();
lbl9:
            // 2 sources

            block1: while (true) {
                block32: {
                    block33: {
                        block31: {
                            block30: {
                                block29: {
                                    block28: {
                                        if (!IntersectTermsEnum.$assertionsDisabled && this.currentFrame.transition != this.currentTransition) {
                                            throw new AssertionError();
                                        }
                                        if (this.currentFrame.suffix == 0) break block28;
                                        var4_4 = this.currentFrame.suffixBytes;
                                        var2_2 = this.currentFrame.suffixBytes[this.currentFrame.startBytePos] & 255;
                                        if (var2_2 < this.currentTransition.min) {
                                            var5_5 = this.currentTransition.min;
                                            while (this.currentFrame.nextEnt < this.currentFrame.entCount) {
                                                var1_1 = this.currentFrame.next();
                                                if ((var4_4[this.currentFrame.startBytePos] & 255) < var5_5) continue;
                                                continue block1;
                                            }
                                            var1_1 = this.popPushNext();
                                            continue;
                                        }
                                        break block29;
                                    }
                                    var2_2 = this.currentFrame.state;
                                    var3_3 = this.currentFrame.lastState;
                                    break block30;
                                }
                                while (var2_2 > this.currentTransition.max) {
                                    if (this.currentFrame.transitionIndex >= this.currentFrame.transitionCount - 1) {
                                        if (this.currentFrame.ord == 0) {
                                            this.currentFrame = null;
                                            return null;
                                        }
                                        this.currentFrame = this.stack[this.currentFrame.ord - 1];
                                        this.currentTransition = this.currentFrame.transition;
                                        continue block0;
                                    }
                                    ++this.currentFrame.transitionIndex;
                                    this.automaton.getNextTransition(this.currentTransition);
                                    if (var2_2 >= this.currentTransition.min) continue;
                                    var5_5 = this.currentTransition.min;
                                    while (this.currentFrame.nextEnt < this.currentFrame.entCount) {
                                        var1_1 = this.currentFrame.next();
                                        if ((var4_4[this.currentFrame.startBytePos] & 255) < var5_5) continue;
                                        continue block1;
                                    }
                                    var1_1 = this.popPushNext();
                                    continue block1;
                                }
                                if (this.commonSuffix != null && !var1_1) {
                                    if (this.currentFrame.prefix + this.currentFrame.suffix < this.commonSuffix.length) continue block0;
                                    var6_8 = this.commonSuffix.bytes;
                                    var2_2 = this.commonSuffix.length - this.currentFrame.suffix;
                                    if (!IntersectTermsEnum.$assertionsDisabled && this.commonSuffix.offset != 0) {
                                        throw new AssertionError();
                                    }
                                    var3_3 = 0;
                                    if (var2_2 > 0) {
                                        var5_6 = this.term.bytes;
                                        var2_2 = this.currentFrame.prefix - var2_2;
                                        if (!IntersectTermsEnum.$assertionsDisabled && var2_2 < 0) {
                                            throw new AssertionError();
                                        }
                                        var7_10 = this.currentFrame.prefix;
                                        while (var2_2 < var7_10) {
                                            if (var5_6[var2_2++] == var6_8[var3_3++]) continue;
                                            continue block0;
                                        }
                                        var2_2 = this.currentFrame.startBytePos;
                                    } else {
                                        var2_2 = this.currentFrame.startBytePos + this.currentFrame.suffix - this.commonSuffix.length;
                                    }
                                    var5_7 = this.commonSuffix.length;
                                    while (var3_3 < var5_7) {
                                        if (var4_4[var2_2++] == var6_8[var3_3++]) continue;
                                        continue block0;
                                    }
                                }
                                var3_3 = this.currentFrame.state;
                                var2_2 = this.currentTransition.dest;
                                var5_5 = this.currentFrame.startBytePos + this.currentFrame.suffix;
                                for (var6_9 = this.currentFrame.startBytePos + 1; var6_9 < var5_5; ++var6_9) {
                                    var3_3 = var2_2;
                                    if ((var2_2 = this.runAutomaton.step(var2_2, var4_4[var6_9] & 255)) != -1) continue;
                                    continue block0;
                                }
                            }
                            if (!var1_1) break block31;
                            this.copyTerm();
                            this.currentFrame = this.pushFrame(var2_2);
                            this.currentTransition = this.currentFrame.transition;
                            this.currentFrame.lastState = var3_3;
                            break block32;
                        }
                        if (!this.currentFrame.isAutoPrefixTerm) break block33;
                        if (this.allowAutoPrefixTerms) {
                            if (this.currentFrame.floorSuffixLeadEnd == -1) {
                                this.useAutoPrefixTerm = var2_2 == this.sinkState;
                            } else if (this.currentFrame.floorSuffixLeadStart == -1) {
                                if (this.automaton.isAccept(var2_2)) {
                                    this.useAutoPrefixTerm = this.acceptsSuffixRange(var2_2, 0, this.currentFrame.floorSuffixLeadEnd);
                                }
                            } else {
                                this.useAutoPrefixTerm = this.acceptsSuffixRange(var3_3, this.currentFrame.floorSuffixLeadStart, this.currentFrame.floorSuffixLeadEnd);
                            }
                            if (this.useAutoPrefixTerm) {
                                this.copyTerm();
                                this.currentFrame.termState.isRealTerm = false;
                                return this.term;
                            }
                        }
                        break block32;
                    }
                    if (this.runAutomaton.isAccept(var2_2)) {
                        this.copyTerm();
                        if (!IntersectTermsEnum.$assertionsDisabled && this.savedStartTerm != null && this.term.compareTo(this.savedStartTerm) <= 0) {
                            throw new AssertionError((Object)("saveStartTerm=" + this.savedStartTerm.utf8ToString() + " term=" + this.term.utf8ToString()));
                        }
                        return this.term;
                    }
                }
                var1_1 = this.popPushNext();
            }
            break;
        }
    }

    private boolean acceptsSuffixRange(int n2, int n3, int n4) {
        n2 = this.automaton.initTransition(n2, this.scratchTransition);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.automaton.getNextTransition(this.scratchTransition);
            if (n3 < this.scratchTransition.min || n4 > this.scratchTransition.max || this.scratchTransition.dest != this.sinkState) continue;
            return true;
        }
        return false;
    }

    private void copyTerm() {
        int n2 = this.currentFrame.prefix + this.currentFrame.suffix;
        if (this.term.bytes.length < n2) {
            this.term.bytes = ArrayUtil.grow(this.term.bytes, n2);
        }
        System.arraycopy(this.currentFrame.suffixBytes, this.currentFrame.startBytePos, this.term.bytes, this.currentFrame.prefix, this.currentFrame.suffix);
        this.term.length = n2;
    }

    @Override
    public final boolean seekExact(BytesRef bytesRef) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void seekExact(long l2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final long ord() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final TermsEnum.SeekStatus seekCeil(BytesRef bytesRef) {
        throw new UnsupportedOperationException();
    }

    private static final class NoMoreTermsException
    extends RuntimeException {
        public static final NoMoreTermsException INSTANCE = new NoMoreTermsException();

        private NoMoreTermsException() {
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }
}

