/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsReader;
import org.apache.lucene.codecs.blocktree.IntersectTermsEnum;
import org.apache.lucene.codecs.blocktree.SegmentTermsEnum;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.portmobile.annotations.Weak;
import org.apache.lucene.store.ByteArrayDataInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.a;
import org.apache.lucene.util.automaton.CompiledAutomaton;
import org.apache.lucene.util.b;
import org.apache.lucene.util.fst.ByteSequenceOutputs;
import org.apache.lucene.util.fst.FST;

public final class FieldReader
extends Terms
implements a {
    private static final long BASE_RAM_BYTES_USED = RamUsageEstimator.shallowSizeOfInstance(FieldReader.class) + 3L * RamUsageEstimator.shallowSizeOfInstance(BytesRef.class);
    final long numTerms;
    final FieldInfo fieldInfo;
    final long sumTotalTermFreq;
    final long sumDocFreq;
    final int docCount;
    final long indexStartFP;
    final long rootBlockFP;
    final BytesRef rootCode;
    final BytesRef minTerm;
    final BytesRef maxTerm;
    final int longsSize;
    @Weak
    final BlockTreeTermsReader parent;
    final FST<BytesRef> index;

    FieldReader(BlockTreeTermsReader closeable, FieldInfo fieldInfo, long l2, BytesRef bytesRef, long l3, long l4, int n2, long l5, int n3, IndexInput indexInput, BytesRef bytesRef2, BytesRef bytesRef3) throws IOException {
        assert (l2 > 0L);
        this.fieldInfo = fieldInfo;
        this.parent = closeable;
        this.numTerms = l2;
        this.sumTotalTermFreq = l3;
        this.sumDocFreq = l4;
        this.docCount = n2;
        this.indexStartFP = l5;
        this.rootCode = bytesRef;
        this.longsSize = n3;
        this.minTerm = bytesRef2;
        this.maxTerm = bytesRef3;
        this.rootBlockFP = new ByteArrayDataInput(bytesRef.bytes, bytesRef.offset, bytesRef.length).readVLong() >>> 2;
        if (indexInput != null) {
            closeable = indexInput.clone();
            ((IndexInput)closeable).seek(l5);
            this.index = new FST<BytesRef>((DataInput)((Object)closeable), ByteSequenceOutputs.getSingleton());
            return;
        }
        this.index = null;
    }

    @Override
    public final boolean hasFreqs() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
    }

    @Override
    public final boolean hasOffsets() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
    }

    @Override
    public final boolean hasPositions() {
        return this.fieldInfo.getIndexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
    }

    @Override
    public final boolean hasPayloads() {
        return this.fieldInfo.hasPayloads();
    }

    @Override
    public final TermsEnum iterator() throws IOException {
        return new SegmentTermsEnum(this);
    }

    @Override
    public final long size() {
        return this.numTerms;
    }

    @Override
    public final long getSumTotalTermFreq() {
        return this.sumTotalTermFreq;
    }

    @Override
    public final long getSumDocFreq() {
        return this.sumDocFreq;
    }

    @Override
    public final int getDocCount() {
        return this.docCount;
    }

    @Override
    public final TermsEnum intersect(CompiledAutomaton compiledAutomaton, BytesRef bytesRef) throws IOException {
        return new IntersectTermsEnum(this, compiledAutomaton.automaton, compiledAutomaton.runAutomaton, compiledAutomaton.commonSuffixRef, bytesRef, compiledAutomaton.sinkState);
    }

    @Override
    public final long ramBytesUsed() {
        return BASE_RAM_BYTES_USED + (this.index != null ? this.index.ramBytesUsed() : 0L);
    }

    @Override
    public final Collection<a> getChildResources() {
        if (this.index == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(b.a("term index", this.index));
    }

    public final String toString() {
        return "BlockTreeTerms(terms=" + this.numTerms + ",postings=" + this.sumDocFreq + ",positions=" + this.sumTotalTermFreq + ",docs=" + this.docCount + ")";
    }
}

