/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.blocktree.FieldReader;
import org.apache.lucene.codecs.e;
import org.apache.lucene.codecs.j;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.a;
import org.apache.lucene.util.b;
import org.apache.lucene.util.fst.ByteSequenceOutputs;

public final class BlockTreeTermsReader
extends e {
    static final org.apache.lucene.util.fst.a<BytesRef> FST_OUTPUTS = ByteSequenceOutputs.getSingleton();
    static final BytesRef NO_OUTPUT = (BytesRef)((org.apache.lucene.util.fst.a)FST_OUTPUTS).getNoOutput();
    final IndexInput termsIn;
    final j postingsReader;
    private final TreeMap<String, FieldReader> fields = new TreeMap();
    private long dirOffset;
    private long indexDirOffset;
    final String segment;
    final int version;
    final boolean anyAutoPrefixTerms;

    public BlockTreeTermsReader(j j2, SegmentReadState segmentReadState) throws IOException {
        IndexInput indexInput = null;
        this.postingsReader = j2;
        this.segment = segmentReadState.segmentInfo.name;
        String string = IndexFileNames.segmentFileName(this.segment, segmentReadState.segmentSuffix, "tim");
        try {
            this.termsIn = segmentReadState.directory.openInput(string, segmentReadState.context);
            this.version = CodecUtil.checkIndexHeader(this.termsIn, "BlockTreeTermsDict", 0, 2, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
            if (this.version <= 0) {
                this.anyAutoPrefixTerms = false;
            } else if (this.version == 1) {
                this.anyAutoPrefixTerms = true;
            } else {
                assert (this.version >= 2);
                byte by = this.termsIn.readByte();
                if (by == 0) {
                    this.anyAutoPrefixTerms = false;
                } else if (by == 1) {
                    this.anyAutoPrefixTerms = true;
                } else {
                    throw new CorruptIndexException("invalid anyAutoPrefixTerms: expected 0 or 1 but got " + by, this.termsIn);
                }
            }
            String string2 = IndexFileNames.segmentFileName(this.segment, segmentReadState.segmentSuffix, "tip");
            indexInput = segmentReadState.directory.openInput(string2, segmentReadState.context);
            CodecUtil.checkIndexHeader(indexInput, "BlockTreeTermsIndex", this.version, this.version, segmentReadState.segmentInfo.getId(), segmentReadState.segmentSuffix);
            CodecUtil.checksumEntireFile(indexInput);
            j2.init(this.termsIn, segmentReadState);
            CodecUtil.retrieveChecksum(this.termsIn);
            this.seekDir(this.termsIn, this.dirOffset);
            this.seekDir(indexInput, this.indexDirOffset);
            int n2 = this.termsIn.readVInt();
            if (n2 < 0) {
                throw new CorruptIndexException("invalid numFields: " + n2, this.termsIn);
            }
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.termsIn.readVInt();
                long l2 = this.termsIn.readVLong();
                if (l2 <= 0L) {
                    throw new CorruptIndexException("Illegal numTerms for field number: " + n3, this.termsIn);
                }
                int n4 = this.termsIn.readVInt();
                if (n4 < 0) {
                    throw new CorruptIndexException("invalid rootCode for field number: " + n3 + ", numBytes=" + n4, this.termsIn);
                }
                BytesRef bytesRef = new BytesRef(new byte[n4]);
                this.termsIn.readBytes(bytesRef.bytes, 0, n4);
                bytesRef.length = n4;
                FieldInfo fieldInfo = segmentReadState.fieldInfos.fieldInfo(n3);
                if (fieldInfo == null) {
                    throw new CorruptIndexException("invalid field number: " + n3, this.termsIn);
                }
                long l3 = fieldInfo.getIndexOptions() == IndexOptions.DOCS ? -1L : this.termsIn.readVLong();
                long l4 = this.termsIn.readVLong();
                n3 = this.termsIn.readVInt();
                int n5 = this.termsIn.readVInt();
                if (n5 < 0) {
                    throw new CorruptIndexException("invalid longsSize for field: " + fieldInfo.name + ", longsSize=" + n5, this.termsIn);
                }
                BytesRef bytesRef2 = BlockTreeTermsReader.readBytesRef(this.termsIn);
                BytesRef bytesRef3 = BlockTreeTermsReader.readBytesRef(this.termsIn);
                if (n3 < 0 || n3 > segmentReadState.segmentInfo.maxDoc()) {
                    throw new CorruptIndexException("invalid docCount: " + n3 + " maxDoc: " + segmentReadState.segmentInfo.maxDoc(), this.termsIn);
                }
                if (l4 < (long)n3) {
                    throw new CorruptIndexException("invalid sumDocFreq: " + l4 + " docCount: " + n3, this.termsIn);
                }
                if (l3 != -1L && l3 < l4) {
                    throw new CorruptIndexException("invalid sumTotalTermFreq: " + l3 + " sumDocFreq: " + l4, this.termsIn);
                }
                long l5 = indexInput.readVLong();
                if (this.fields.put(fieldInfo.name, new FieldReader(this, fieldInfo, l2, bytesRef, l3, l4, n3, l5, n5, indexInput, bytesRef2, bytesRef3)) == null) continue;
                throw new CorruptIndexException("duplicate field: " + fieldInfo.name, this.termsIn);
            }
            indexInput.close();
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeWhileHandlingException(indexInput, this);
            throw throwable;
        }
    }

    private static BytesRef readBytesRef(IndexInput indexInput) throws IOException {
        BytesRef bytesRef = new BytesRef();
        new BytesRef().length = indexInput.readVInt();
        bytesRef.bytes = new byte[bytesRef.length];
        indexInput.readBytes(bytesRef.bytes, 0, bytesRef.length);
        return bytesRef;
    }

    private void seekDir(IndexInput indexInput, long l2) throws IOException {
        indexInput.seek(indexInput.length() - (long)CodecUtil.footerLength() - 8L);
        l2 = indexInput.readLong();
        indexInput.seek(l2);
    }

    @Override
    public final void close() throws IOException {
        try {
            IOUtils.close(this.termsIn, this.postingsReader);
            return;
        }
        finally {
            this.fields.clear();
        }
    }

    @Override
    public final Iterator<String> iterator() {
        return Collections.unmodifiableSet(this.fields.keySet()).iterator();
    }

    @Override
    public final Terms terms(String string) throws IOException {
        assert (string != null);
        return this.fields.get(string);
    }

    @Override
    public final int size() {
        return this.fields.size();
    }

    @Override
    public final long ramBytesUsed() {
        long l2 = this.postingsReader.ramBytesUsed();
        for (FieldReader fieldReader : this.fields.values()) {
            l2 += fieldReader.ramBytesUsed();
        }
        return l2;
    }

    @Override
    public final Collection<a> getChildResources() {
        ArrayList<a> arrayList = new ArrayList<a>();
        arrayList.addAll(b.a("field", this.fields));
        arrayList.add(b.a("delegate", this.postingsReader));
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public final void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.termsIn);
        this.postingsReader.checkIntegrity();
    }

    public final String toString() {
        return this.getClass().getSimpleName() + "(fields=" + this.fields.size() + ",delegate=" + this.postingsReader + ")";
    }
}

