/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.blocktree;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.lucene.codecs.blocktree.BlockTreeTermsWriter;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.StringHelper;

class AutoPrefixTermsWriter {
    final List<PrefixTerm> prefixes = new ArrayList<PrefixTerm>();
    private final int minItemsInPrefix;
    private final int maxItemsInPrefix;
    private final BytesRefBuilder lastTerm = new BytesRefBuilder();
    private int[] prefixStarts = new int[8];
    private List<Object> pending = new ArrayList<Object>();

    static String brToString(BytesRef bytesRef) {
        try {
            return bytesRef.utf8ToString() + " " + bytesRef;
        }
        catch (Throwable throwable) {
            return bytesRef.toString();
        }
    }

    public AutoPrefixTermsWriter(Terms object, int n2, int n3) throws IOException {
        BytesRef bytesRef;
        this.minItemsInPrefix = n2;
        this.maxItemsInPrefix = n3;
        object = ((Terms)object).iterator();
        while ((bytesRef = object.next()) != null) {
            this.pushTerm(bytesRef);
        }
        if (this.pending.size() > 1) {
            this.pushTerm(BlockTreeTermsWriter.EMPTY_BYTES_REF);
            while (this.pending.size() >= n2) {
                this.savePrefixes(0, this.pending.size());
            }
        }
        Collections.sort(this.prefixes);
    }

    private void pushTerm(BytesRef bytesRef) throws IOException {
        int n2;
        int n3 = Math.min(this.lastTerm.length(), bytesRef.length);
        for (n2 = 0; n2 < n3 && this.lastTerm.byteAt(n2) == bytesRef.bytes[bytesRef.offset + n2]; ++n2) {
        }
        for (n3 = this.lastTerm.length() - 1; n3 >= n2; --n3) {
            int n4 = this.pending.size() - this.prefixStarts[n3];
            while (n4 >= this.minItemsInPrefix) {
                this.savePrefixes(n3 + 1, n4);
                n4 = this.pending.size() - this.prefixStarts[n3];
            }
        }
        if (this.prefixStarts.length < bytesRef.length) {
            this.prefixStarts = ArrayUtil.grow(this.prefixStarts, bytesRef.length);
        }
        for (n3 = n2; n3 < bytesRef.length; ++n3) {
            this.prefixStarts[n3] = this.pending.size();
        }
        this.lastTerm.copyBytes(bytesRef);
        if (bytesRef.length > 0 || this.pending.isEmpty()) {
            byte[] byArray = new byte[bytesRef.length];
            System.arraycopy(bytesRef.bytes, bytesRef.offset, byArray, 0, bytesRef.length);
            this.pending.add(byArray);
        }
    }

    void savePrefixes(int n2, int n3) throws IOException {
        assert (n3 > 0);
        int n4 = -2;
        int n5 = this.pending.size() - n3;
        assert (n5 >= 0);
        Object object = this.pending.get(n5);
        boolean bl = false;
        if (object instanceof byte[]) {
            if (((byte[])object).length == n2) {
                ++n5;
                --n3;
                bl = true;
            }
        } else if (((PrefixTerm)object).term.bytes.length == n2) {
            ++n5;
            --n3;
            bl = true;
        }
        int n6 = this.pending.size();
        int n7 = n5;
        int n8 = -1;
        int n9 = 0;
        PrefixTerm prefixTerm = null;
        while (n5 < n6) {
            PrefixTerm prefixTerm2;
            object = this.pending.get(n5);
            if (object instanceof byte[]) {
                prefixTerm2 = null;
                object = (byte[])object;
            } else {
                prefixTerm2 = (PrefixTerm)object;
                object = prefixTerm2.term.bytes;
                if (prefixTerm2.prefix.length != n2) {
                    assert (prefixTerm2.prefix.length > n2);
                    prefixTerm2 = null;
                }
            }
            assert (((Object)object).length > n2);
            int n10 = object[n2] & 0xFF;
            if (n10 != n4) {
                assert (n10 > n4) : "suffixLeadLabel=" + n10 + " vs lastSuffixLeadLabel=" + n4;
                if (n5 - n7 >= this.minItemsInPrefix && n6 - n7 > this.maxItemsInPrefix) {
                    if (prefixTerm != null) {
                        n4 = prefixTerm.floorLeadEnd;
                    }
                    this.savePrefix(n2, n8, n4);
                    ++n9;
                    n8 = n10;
                    n7 = n5;
                }
                if (n8 == -1) {
                    n8 = n10;
                }
                n4 = n10;
            }
            prefixTerm = prefixTerm2;
            ++n5;
        }
        if (n7 < n6) {
            if (prefixTerm != null) {
                n4 = prefixTerm.floorLeadEnd;
            }
            assert (n4 >= n8) : "lastSuffixLeadLabel=" + n4 + " nextFloorLeadLabel=" + n8;
            if (n9 == 0) {
                if (n2 > 0) {
                    this.savePrefix(n2, -2, 255);
                    ++n9;
                    if (bl) {
                        ++n3;
                    }
                }
            } else {
                if (n4 == -2) {
                    n4 = 255;
                }
                this.savePrefix(n2, n8, n4);
                ++n9;
            }
        }
        this.pending.subList(this.pending.size() - n3, this.pending.size()).clear();
        for (n5 = 0; n5 < n9; ++n5) {
            object = this.prefixes.get(this.prefixes.size() - (n9 - n5));
            this.pending.add(object);
        }
    }

    private void savePrefix(int n2, int n3, int n4) {
        byte[] byArray = new byte[n2];
        System.arraycopy(this.lastTerm.bytes(), 0, byArray, 0, n2);
        assert (n3 != -1);
        assert (n4 != -1);
        PrefixTerm prefixTerm = new PrefixTerm(byArray, n3, n4);
        this.prefixes.add(prefixTerm);
    }

    public static final class PrefixTerm
    implements Comparable<PrefixTerm> {
        public final byte[] prefix;
        public final int floorLeadStart;
        public final int floorLeadEnd;
        public final BytesRef term;

        public PrefixTerm(byte[] byArray, int n2, int n3) {
            this.prefix = byArray;
            this.floorLeadStart = n2;
            this.floorLeadEnd = n3;
            this.term = PrefixTerm.toBytesRef(byArray, n2);
            assert (n3 >= n2);
            assert (n3 >= 0);
            assert (n2 == -2 || n2 >= 0);
            assert (byArray.length > 0 || n2 != -2 || n3 != 255);
        }

        public final String toString() {
            String string = AutoPrefixTermsWriter.brToString(new BytesRef(this.prefix));
            string = this.floorLeadStart == -2 ? string + "[-" + Integer.toHexString(this.floorLeadEnd) + "]" : string + "[" + Integer.toHexString(this.floorLeadStart) + "-" + Integer.toHexString(this.floorLeadEnd) + "]";
            return string;
        }

        @Override
        public final int compareTo(PrefixTerm prefixTerm) {
            int n2 = this.term.compareTo(prefixTerm.term);
            if (n2 == 0) {
                if (this.prefix.length != prefixTerm.prefix.length) {
                    return this.prefix.length - prefixTerm.prefix.length;
                }
                n2 = prefixTerm.floorLeadEnd - this.floorLeadEnd;
            }
            return n2;
        }

        private static BytesRef toBytesRef(byte[] byArray, int n2) {
            BytesRef bytesRef;
            if (n2 != -2) {
                assert (n2 >= 0);
                bytesRef = new BytesRef(byArray.length + 1);
            } else {
                bytesRef = new BytesRef(byArray.length);
            }
            System.arraycopy(byArray, 0, bytesRef.bytes, 0, byArray.length);
            bytesRef.length = byArray.length;
            if (n2 != -2) {
                assert (n2 >= 0);
                bytesRef.bytes[bytesRef.length++] = (byte)n2;
            }
            return bytesRef;
        }

        @Override
        public final int compareTo(BytesRef bytesRef) {
            return this.term.compareTo(bytesRef);
        }

        public final TermsEnum getTermsEnum(TermsEnum termsEnum) {
            final BytesRef bytesRef = new BytesRef(this.prefix);
            return new FilteredTermsEnum(termsEnum){
                {
                    super(termsEnum);
                    this.setInitialSeekTerm(PrefixTerm.this.term);
                }

                @Override
                protected FilteredTermsEnum.AcceptStatus accept(BytesRef bytesRef2) {
                    if (StringHelper.startsWith(bytesRef2, bytesRef) && (PrefixTerm.this.floorLeadEnd == -1 || bytesRef2.length == bytesRef.length || (bytesRef2.bytes[bytesRef2.offset + bytesRef.length] & 0xFF) <= PrefixTerm.this.floorLeadEnd)) {
                        return FilteredTermsEnum.AcceptStatus.YES;
                    }
                    return FilteredTermsEnum.AcceptStatus.END;
                }
            };
        }
    }
}

