/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.codecs.p;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.Fields;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public abstract class TermVectorsWriter
implements Closeable {
    protected TermVectorsWriter() {
    }

    public abstract void startDocument(int var1) throws IOException;

    public void finishDocument() throws IOException {
    }

    public abstract void startField(FieldInfo var1, int var2, boolean var3, boolean var4, boolean var5) throws IOException;

    public void finishField() throws IOException {
    }

    public abstract void startTerm(BytesRef var1, int var2) throws IOException;

    public void finishTerm() throws IOException {
    }

    public abstract void addPosition(int var1, int var2, int var3, BytesRef var4) throws IOException;

    public abstract void finish(FieldInfos var1, int var2) throws IOException;

    /*
     * Unable to fully structure code
     */
    public void addProx(int var1_1, DataInput var2_2, DataInput var3_3) throws IOException {
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = null;
        for (var7_7 = 0; var7_7 < var1_1; ++var7_7) {
            block6: {
                if (var2_2 != null) break block6;
                var4_4 = -1;
                ** GOTO lbl-1000
            }
            var8_8 = var2_2.readVInt();
            var4_4 += var8_8 >>> 1;
            if ((var8_8 & 1) != 0) {
                var8_8 = var2_2.readVInt();
                if (var6_6 == null) {
                    var6_6 = new BytesRefBuilder();
                }
                var6_6.grow(var8_8);
                var2_2.readBytes(var6_6.bytes(), 0, var8_8);
                var6_6.setLength(var8_8);
                var10_10 = var6_6.get();
            } else lbl-1000:
            // 2 sources

            {
                var10_10 = null;
            }
            if (var3_3 == null) {
                var9_9 = -1;
                var8_8 = -1;
            } else {
                var8_8 = var5_5 + var3_3.readVInt();
                var5_5 = var9_9 = var8_8 + var3_3.readVInt();
            }
            this.addPosition(var4_4, var8_8, var9_9, var10_10);
        }
    }

    public int merge(MergeState mergeState) throws IOException {
        int n2 = 0;
        int n3 = mergeState.maxDocs.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = mergeState.maxDocs[i2];
            Bits bits = mergeState.liveDocs[i2];
            p p2 = mergeState.termVectorsReaders[i2];
            if (p2 != null) {
                p2.checkIntegrity();
            }
            for (int i3 = 0; i3 < n4; ++i3) {
                if (bits != null && !bits.get(i3)) continue;
                Fields fields = p2 == null ? null : p2.get(i3);
                this.addAllDocVectors(fields, mergeState);
                ++n2;
            }
        }
        this.finish(mergeState.mergeFieldInfos, n2);
        return n2;
    }

    protected final void addAllDocVectors(Fields fields, MergeState mergeState) throws IOException {
        Object object;
        if (fields == null) {
            this.startDocument(0);
            this.finishDocument();
            return;
        }
        int n2 = fields.size();
        if (n2 == -1) {
            n2 = 0;
            object = fields.iterator();
            while (object.hasNext()) {
                object.next();
                ++n2;
            }
        }
        this.startDocument(n2);
        object = null;
        PostingsEnum postingsEnum = null;
        int n3 = 0;
        for (Object object2 : fields) {
            ++n3;
            FieldInfo fieldInfo = mergeState.mergeFieldInfos.fieldInfo((String)object2);
            assert (object == null || ((String)object2).compareTo((String)object) > 0) : "lastFieldName=" + (String)object + " fieldName=" + (String)object2;
            object = object2;
            Terms terms = fields.terms((String)object2);
            if (terms == null) continue;
            boolean bl = terms.hasPositions();
            boolean bl2 = terms.hasOffsets();
            int n4 = terms.hasPayloads();
            assert (n4 == 0 || bl);
            int n5 = (int)terms.size();
            if (n5 == -1) {
                n5 = 0;
                object2 = terms.iterator();
                while (object2.next() != null) {
                    ++n5;
                }
            }
            this.startField(fieldInfo, n5, bl, bl2, n4 != 0);
            object2 = terms.iterator();
            int n6 = 0;
            while (object2.next() != null) {
                ++n6;
                int n7 = (int)((TermsEnum)object2).totalTermFreq();
                this.startTerm(((TermsEnum)object2).term(), n7);
                if (bl || bl2) {
                    postingsEnum = ((TermsEnum)object2).postings(postingsEnum, 120);
                    assert (postingsEnum != null);
                    n4 = postingsEnum.nextDoc();
                    assert (n4 != Integer.MAX_VALUE);
                    assert (postingsEnum.freq() == n7);
                    for (n4 = 0; n4 < n7; ++n4) {
                        int n8 = postingsEnum.nextPosition();
                        int n9 = postingsEnum.startOffset();
                        int n10 = postingsEnum.endOffset();
                        BytesRef bytesRef = postingsEnum.getPayload();
                        assert (!bl || n8 >= 0);
                        this.addPosition(n8, n9, n10, bytesRef);
                    }
                }
                this.finishTerm();
            }
            assert (n6 == n5);
            this.finishField();
        }
        assert (n3 == n2);
        this.finishDocument();
    }

    @Override
    public abstract void close() throws IOException;
}

