/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.codecs.n;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.j;
import org.apache.lucene.index.k;
import org.apache.lucene.portmobile.charset.StandardCharsets;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;

public abstract class StoredFieldsWriter
implements Closeable {
    protected StoredFieldsWriter() {
    }

    public abstract void startDocument() throws IOException;

    public void finishDocument() throws IOException {
    }

    public abstract void writeField(FieldInfo var1, j var2) throws IOException;

    public abstract void finish(FieldInfos var1, int var2) throws IOException;

    public int merge(MergeState mergeState) throws IOException {
        int n2 = 0;
        for (int i2 = 0; i2 < mergeState.storedFieldsReaders.length; ++i2) {
            n n3 = mergeState.storedFieldsReaders[i2];
            n3.checkIntegrity();
            MergeVisitor mergeVisitor = new MergeVisitor(mergeState, i2);
            int n4 = mergeState.maxDocs[i2];
            Bits bits = mergeState.liveDocs[i2];
            for (int i3 = 0; i3 < n4; ++i3) {
                if (bits != null && !bits.get(i3)) continue;
                this.startDocument();
                n3.visitDocument(i3, mergeVisitor);
                this.finishDocument();
                ++n2;
            }
        }
        this.finish(mergeState.mergeFieldInfos, n2);
        return n2;
    }

    @Override
    public abstract void close() throws IOException;

    protected class MergeVisitor
    extends StoredFieldVisitor
    implements j {
        BytesRef binaryValue;
        String stringValue;
        Number numericValue;
        FieldInfo currentField;
        FieldInfos remapper;

        public MergeVisitor(MergeState mergeState, int n2) {
            for (FieldInfo fieldInfo : mergeState.fieldInfos[n2]) {
                FieldInfo fieldInfo2 = mergeState.mergeFieldInfos.fieldInfo(fieldInfo.number);
                if (fieldInfo2 != null && fieldInfo2.name.equals(fieldInfo.name)) continue;
                this.remapper = mergeState.mergeFieldInfos;
                return;
            }
        }

        @Override
        public void binaryField(FieldInfo fieldInfo, byte[] byArray) throws IOException {
            this.reset(fieldInfo);
            this.binaryValue = new BytesRef(byArray);
            this.write();
        }

        @Override
        public void stringField(FieldInfo fieldInfo, byte[] byArray) throws IOException {
            this.reset(fieldInfo);
            this.stringValue = new String(byArray, StandardCharsets.UTF_8);
            this.write();
        }

        @Override
        public void intField(FieldInfo fieldInfo, int n2) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = n2;
            this.write();
        }

        @Override
        public void longField(FieldInfo fieldInfo, long l2) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = l2;
            this.write();
        }

        @Override
        public void floatField(FieldInfo fieldInfo, float f2) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = Float.valueOf(f2);
            this.write();
        }

        @Override
        public void doubleField(FieldInfo fieldInfo, double d2) throws IOException {
            this.reset(fieldInfo);
            this.numericValue = d2;
            this.write();
        }

        @Override
        public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) throws IOException {
            return StoredFieldVisitor.Status.YES;
        }

        @Override
        public String name() {
            return this.currentField.name;
        }

        @Override
        public k fieldType() {
            return StoredField.TYPE;
        }

        @Override
        public BytesRef binaryValue() {
            return this.binaryValue;
        }

        @Override
        public String stringValue() {
            return this.stringValue;
        }

        @Override
        public Number numericValue() {
            return this.numericValue;
        }

        @Override
        public float boost() {
            return 1.0f;
        }

        @Override
        public TokenStream tokenStream(Analyzer analyzer, TokenStream tokenStream) throws IOException {
            return null;
        }

        void reset(FieldInfo fieldInfo) {
            this.currentField = this.remapper != null ? this.remapper.fieldInfo(fieldInfo.name) : fieldInfo;
            this.binaryValue = null;
            this.stringValue = null;
            this.numericValue = null;
        }

        void write() throws IOException {
            StoredFieldsWriter.this.writeField(this.currentField, this);
        }
    }
}

