/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import org.apache.lucene.codecs.BlockTermState;
import org.apache.lucene.codecs.k;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.FixedBitSet;

public abstract class PushPostingsWriterBase
extends k {
    private PostingsEnum postingsEnum;
    private int enumFlags;
    protected FieldInfo fieldInfo;
    protected IndexOptions indexOptions;
    protected boolean writeFreqs;
    protected boolean writePositions;
    protected boolean writePayloads;
    protected boolean writeOffsets;

    protected PushPostingsWriterBase() {
    }

    public abstract BlockTermState newTermState() throws IOException;

    public abstract void startTerm() throws IOException;

    public abstract void finishTerm(BlockTermState var1) throws IOException;

    @Override
    public int setField(FieldInfo fieldInfo) {
        this.fieldInfo = fieldInfo;
        this.indexOptions = fieldInfo.getIndexOptions();
        this.writeFreqs = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS) >= 0;
        this.writePositions = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0;
        this.writeOffsets = this.indexOptions.compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) >= 0;
        this.writePayloads = fieldInfo.hasPayloads();
        this.enumFlags = !this.writeFreqs ? 0 : (!this.writePositions ? 8 : (!this.writeOffsets ? (this.writePayloads ? 88 : 24) : (this.writePayloads ? 120 : 56)));
        return 0;
    }

    @Override
    public final BlockTermState writeTerm(BytesRef bytesRef, TermsEnum termsEnum, FixedBitSet fixedBitSet) throws IOException {
        int n2;
        this.startTerm();
        this.postingsEnum = termsEnum.postings(this.postingsEnum, this.enumFlags);
        assert (this.postingsEnum != null);
        int n3 = 0;
        long l2 = 0L;
        while ((n2 = this.postingsEnum.nextDoc()) != Integer.MAX_VALUE) {
            int n4;
            ++n3;
            fixedBitSet.set(n2);
            if (this.writeFreqs) {
                n4 = this.postingsEnum.freq();
                l2 += (long)n4;
            } else {
                n4 = -1;
            }
            this.startDoc(n2, n4);
            if (this.writePositions) {
                for (n2 = 0; n2 < n4; ++n2) {
                    int n5;
                    int n6;
                    BytesRef bytesRef2;
                    int n7 = this.postingsEnum.nextPosition();
                    BytesRef bytesRef3 = bytesRef2 = this.writePayloads ? this.postingsEnum.getPayload() : null;
                    if (this.writeOffsets) {
                        n6 = this.postingsEnum.startOffset();
                        n5 = this.postingsEnum.endOffset();
                    } else {
                        n6 = -1;
                        n5 = -1;
                    }
                    this.addPosition(n7, bytesRef2, n6, n5);
                }
            }
            this.finishDoc();
        }
        if (n3 == 0) {
            return null;
        }
        BlockTermState blockTermState = this.newTermState();
        this.newTermState().docFreq = n3;
        blockTermState.totalTermFreq = this.writeFreqs ? l2 : -1L;
        this.finishTerm(blockTermState);
        return blockTermState;
    }

    public abstract void startDoc(int var1, int var2) throws IOException;

    public abstract void addPosition(int var1, BytesRef var2, int var3, int var4) throws IOException;

    public abstract void finishDoc() throws IOException;
}

