/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.util.h;

public abstract class MultiLevelSkipListWriter {
    protected int numberOfSkipLevels;
    private int skipInterval;
    private int skipMultiplier;
    private RAMOutputStream[] skipBuffer;

    protected MultiLevelSkipListWriter(int n2, int n3, int n4, int n5) {
        this.skipInterval = n2;
        this.skipMultiplier = n3;
        this.numberOfSkipLevels = n5 <= n2 ? 1 : 1 + h.a((long)(n5 / n2), n3);
        if (this.numberOfSkipLevels > n4) {
            this.numberOfSkipLevels = n4;
        }
    }

    protected MultiLevelSkipListWriter(int n2, int n3, int n4) {
        this(n2, n2, n3, n4);
    }

    protected void init() {
        this.skipBuffer = new RAMOutputStream[this.numberOfSkipLevels];
        for (int i2 = 0; i2 < this.numberOfSkipLevels; ++i2) {
            this.skipBuffer[i2] = new RAMOutputStream();
        }
    }

    protected void resetSkip() {
        if (this.skipBuffer == null) {
            this.init();
            return;
        }
        for (int i2 = 0; i2 < this.skipBuffer.length; ++i2) {
            this.skipBuffer[i2].reset();
        }
    }

    protected abstract void writeSkipData(int var1, IndexOutput var2) throws IOException;

    public void bufferSkip(int n2) throws IOException {
        assert (n2 % this.skipInterval == 0);
        int n3 = 1;
        n2 /= this.skipInterval;
        while (n2 % this.skipMultiplier == 0 && n3 < this.numberOfSkipLevels) {
            ++n3;
            n2 /= this.skipMultiplier;
        }
        long l2 = 0L;
        for (n2 = 0; n2 < n3; ++n2) {
            this.writeSkipData(n2, this.skipBuffer[n2]);
            long l3 = this.skipBuffer[n2].getFilePointer();
            if (n2 != 0) {
                this.skipBuffer[n2].writeVLong(l2);
            }
            l2 = l3;
        }
    }

    public long writeSkip(IndexOutput indexOutput) throws IOException {
        long l2 = indexOutput.getFilePointer();
        if (this.skipBuffer == null || this.skipBuffer.length == 0) {
            return l2;
        }
        for (int i2 = this.numberOfSkipLevels - 1; i2 > 0; --i2) {
            long l3 = this.skipBuffer[i2].getFilePointer();
            if (l3 <= 0L) continue;
            indexOutput.writeVLong(l3);
            this.skipBuffer[i2].writeTo(indexOutput);
        }
        this.skipBuffer[0].writeTo(indexOutput);
        return l2;
    }
}

