/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.b;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.util.NamedSPILoader;

public abstract class DocValuesFormat
implements NamedSPILoader.a {
    private final String name;

    protected DocValuesFormat(String string) {
        NamedSPILoader.checkServiceName(string);
        this.name = string;
    }

    public abstract DocValuesConsumer fieldsConsumer(SegmentWriteState var1) throws IOException;

    public abstract b fieldsProducer(SegmentReadState var1) throws IOException;

    @Override
    public final String getName() {
        return this.name;
    }

    public String toString() {
        return "DocValuesFormat(name=" + this.name + ")";
    }

    public static DocValuesFormat forName(String string) {
        return Holder.getLoader().lookup(string);
    }

    public static Set<String> availableDocValuesFormats() {
        return Holder.getLoader().availableServices();
    }

    public static void reloadDocValuesFormats(ClassLoader classLoader) {
        Holder.getLoader().reload(classLoader);
    }

    private static final class Holder {
        private static final NamedSPILoader<DocValuesFormat> LOADER = new NamedSPILoader<DocValuesFormat>(DocValuesFormat.class);

        static NamedSPILoader<DocValuesFormat> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a DocValuesFormat by name before all formats could be initialized. This likely happens if you call DocValuesFormat#forName from a DocValuesFormat's ctor.");
            }
            return LOADER;
        }
    }
}

