/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.IOException;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.b;
import org.apache.lucene.analysis.tokenattributes.c;
import org.apache.lucene.analysis.util.CharacterUtils;

public abstract class CharTokenizer
extends Tokenizer {
    private int offset = 0;
    private int bufferIndex = 0;
    private int dataLen = 0;
    private int finalOffset = 0;
    private final b termAtt = this.addAttribute(b.class);
    private final c offsetAtt = this.addAttribute(c.class);
    private final CharacterUtils charUtils = CharacterUtils.getInstance();
    private final CharacterUtils.CharacterBuffer ioBuffer = CharacterUtils.newCharacterBuffer(4096);

    protected abstract boolean isTokenChar(int var1);

    protected int normalize(int n2) {
        return n2;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        this.clearAttributes();
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        char[] cArray = this.termAtt.buffer();
        while (true) {
            if (this.bufferIndex >= this.dataLen) {
                this.offset += this.dataLen;
                this.charUtils.fill(this.ioBuffer, this.input);
                if (this.ioBuffer.getLength() == 0) {
                    this.dataLen = 0;
                    if (n2 > 0) break;
                    this.finalOffset = this.correctOffset(this.offset);
                    return false;
                }
                this.dataLen = this.ioBuffer.getLength();
                this.bufferIndex = 0;
            }
            int n5 = this.charUtils.codePointAt(this.ioBuffer.getBuffer(), this.bufferIndex, this.ioBuffer.getLength());
            int n6 = Character.charCount(n5);
            this.bufferIndex += n6;
            if (this.isTokenChar(n5)) {
                if (n2 == 0) {
                    assert (n3 == -1);
                    n4 = n3 = this.offset + this.bufferIndex - n6;
                } else if (n2 >= cArray.length - 1) {
                    cArray = this.termAtt.resizeBuffer(n2 + 2);
                }
                n4 += n6;
                if ((n2 += Character.toChars(this.normalize(n5), cArray, n2)) < 255) continue;
                break;
            }
            if (n2 > 0) break;
        }
        this.termAtt.setLength(n2);
        assert (n3 != -1);
        this.finalOffset = this.correctOffset(n4);
        this.offsetAtt.setOffset(this.correctOffset(n3), this.finalOffset);
        return true;
    }

    @Override
    public final void end() throws IOException {
        super.end();
        this.offsetAtt.setOffset(this.finalOffset, this.finalOffset);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.bufferIndex = 0;
        this.offset = 0;
        this.dataLen = 0;
        this.finalOffset = 0;
        this.ioBuffer.reset();
    }
}

