/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import org.apache.lucene.analysis.tokenattributes.CharTermAttributeImpl;
import org.apache.lucene.analysis.tokenattributes.c;
import org.apache.lucene.analysis.tokenattributes.e;
import org.apache.lucene.analysis.tokenattributes.f;
import org.apache.lucene.analysis.tokenattributes.h;

public class PackedTokenAttributeImpl
extends CharTermAttributeImpl
implements c,
e,
f,
h {
    private int startOffset;
    private int endOffset;
    private String type = "word";
    private int positionIncrement = 1;
    private int positionLength = 1;

    @Override
    public void setPositionIncrement(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Increment must be zero or greater: " + n2);
        }
        this.positionIncrement = n2;
    }

    @Override
    public int getPositionIncrement() {
        return this.positionIncrement;
    }

    @Override
    public final int startOffset() {
        return this.startOffset;
    }

    @Override
    public final int endOffset() {
        return this.endOffset;
    }

    @Override
    public void setOffset(int n2, int n3) {
        if (n2 < 0 || n3 < n2) {
            throw new IllegalArgumentException("startOffset must be non-negative, and endOffset must be >= startOffset, startOffset=" + n2 + ",endOffset=" + n3);
        }
        this.startOffset = n2;
        this.endOffset = n3;
    }

    @Override
    public final void setType(String string) {
        this.type = string;
    }

    @Override
    public void clear() {
        super.clear();
        this.positionLength = 1;
        this.positionIncrement = 1;
        this.endOffset = 0;
        this.startOffset = 0;
        this.type = "word";
    }

    @Override
    public PackedTokenAttributeImpl clone() {
        return (PackedTokenAttributeImpl)super.clone();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof PackedTokenAttributeImpl) {
            PackedTokenAttributeImpl packedTokenAttributeImpl = (PackedTokenAttributeImpl)object;
            return this.startOffset == packedTokenAttributeImpl.startOffset && this.endOffset == packedTokenAttributeImpl.endOffset && this.positionIncrement == packedTokenAttributeImpl.positionIncrement && this.positionLength == packedTokenAttributeImpl.positionLength && (this.type == null ? packedTokenAttributeImpl.type == null : this.type.equals(packedTokenAttributeImpl.type)) && super.equals(object);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n2 = (((super.hashCode() * 31 + this.startOffset) * 31 + this.endOffset) * 31 + this.positionIncrement) * 31 + this.positionLength;
        if (this.type != null) {
            n2 = n2 * 31 + this.type.hashCode();
        }
        return n2;
    }

    @Override
    public void reflectWith(org.apache.lucene.util.e e2) {
        super.reflectWith(e2);
        e2.reflect(c.class, "startOffset", this.startOffset);
        e2.reflect(c.class, "endOffset", this.endOffset);
        e2.reflect(e.class, "positionIncrement", this.positionIncrement);
        e2.reflect(f.class, "positionLength", this.positionLength);
        e2.reflect(h.class, "type", this.type);
    }
}

