/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.tokenattributes;

import java.nio.Buffer;
import java.nio.CharBuffer;
import org.apache.lucene.analysis.tokenattributes.b;
import org.apache.lucene.analysis.tokenattributes.g;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.d;
import org.apache.lucene.util.e;

public class CharTermAttributeImpl
extends d
implements Cloneable,
b,
g {
    private static int MIN_BUFFER_SIZE = 10;
    private char[] termBuffer = new char[ArrayUtil.oversize(MIN_BUFFER_SIZE, 2)];
    private int termLength = 0;
    protected BytesRefBuilder builder = new BytesRefBuilder();

    @Override
    public final char[] buffer() {
        return this.termBuffer;
    }

    @Override
    public final char[] resizeBuffer(int n2) {
        if (this.termBuffer.length < n2) {
            char[] cArray = new char[ArrayUtil.oversize(n2, 2)];
            System.arraycopy(this.termBuffer, 0, cArray, 0, this.termBuffer.length);
            this.termBuffer = cArray;
        }
        return this.termBuffer;
    }

    @Override
    public final b setLength(int n2) {
        if (n2 > this.termBuffer.length) {
            throw new IllegalArgumentException("length " + n2 + " exceeds the size of the termBuffer (" + this.termBuffer.length + ")");
        }
        this.termLength = n2;
        return this;
    }

    @Override
    public BytesRef getBytesRef() {
        this.builder.copyChars(this.termBuffer, 0, this.termLength);
        return this.builder.get();
    }

    @Override
    public final int length() {
        return this.termLength;
    }

    @Override
    public final char charAt(int n2) {
        if (n2 >= this.termLength) {
            throw new IndexOutOfBoundsException();
        }
        return this.termBuffer[n2];
    }

    @Override
    public final CharSequence subSequence(int n2, int n3) {
        if (n2 > this.termLength || n3 > this.termLength) {
            throw new IndexOutOfBoundsException();
        }
        return new String(this.termBuffer, n2, n3 - n2);
    }

    @Override
    public final b append(CharSequence charSequence) {
        if (charSequence == null) {
            return this.appendNull();
        }
        return this.append(charSequence, 0, charSequence.length());
    }

    @Override
    public final b append(CharSequence charSequence, int n2, int n3) {
        if (charSequence == null) {
            charSequence = "null";
        }
        int n4 = n3 - n2;
        int n5 = charSequence.length();
        if (n4 < 0 || n2 > n5 || n3 > n5) {
            throw new IndexOutOfBoundsException();
        }
        if (n4 == 0) {
            return this;
        }
        this.resizeBuffer(this.termLength + n4);
        if (n4 > 4) {
            if (charSequence instanceof String) {
                ((String)charSequence).getChars(n2, n3, this.termBuffer, this.termLength);
            } else if (charSequence instanceof StringBuilder) {
                ((StringBuilder)charSequence).getChars(n2, n3, this.termBuffer, this.termLength);
            } else if (charSequence instanceof b) {
                System.arraycopy(((b)charSequence).buffer(), n2, this.termBuffer, this.termLength, n4);
            } else if (charSequence instanceof CharBuffer && ((CharBuffer)charSequence).hasArray()) {
                charSequence = (CharBuffer)charSequence;
                System.arraycopy(((CharBuffer)charSequence).array(), ((CharBuffer)charSequence).arrayOffset() + ((Buffer)((Object)charSequence)).position() + n2, this.termBuffer, this.termLength, n4);
            } else if (charSequence instanceof StringBuffer) {
                ((StringBuffer)charSequence).getChars(n2, n3, this.termBuffer, this.termLength);
            } else {
                while (n2 < n3) {
                    this.termBuffer[this.termLength++] = charSequence.charAt(n2++);
                }
                return this;
            }
            this.termLength += n4;
            return this;
        }
        while (n2 < n3) {
            this.termBuffer[this.termLength++] = charSequence.charAt(n2++);
        }
        return this;
    }

    @Override
    public final b append(char c2) {
        this.resizeBuffer((int)(this.termLength + 1))[this.termLength++] = c2;
        return this;
    }

    @Override
    public final b append(String string) {
        if (string == null) {
            return this.appendNull();
        }
        int n2 = string.length();
        string.getChars(0, n2, this.resizeBuffer(this.termLength + n2), this.termLength);
        this.termLength += n2;
        return this;
    }

    private b appendNull() {
        this.resizeBuffer(this.termLength + 4);
        this.termBuffer[this.termLength++] = 110;
        this.termBuffer[this.termLength++] = 117;
        this.termBuffer[this.termLength++] = 108;
        this.termBuffer[this.termLength++] = 108;
        return this;
    }

    public int hashCode() {
        return this.termLength * 31 + ArrayUtil.hashCode(this.termBuffer, 0, this.termLength);
    }

    @Override
    public void clear() {
        this.termLength = 0;
    }

    @Override
    public CharTermAttributeImpl clone() {
        CharTermAttributeImpl charTermAttributeImpl = (CharTermAttributeImpl)super.clone();
        ((CharTermAttributeImpl)super.clone()).termBuffer = new char[this.termLength];
        System.arraycopy(this.termBuffer, 0, charTermAttributeImpl.termBuffer, 0, this.termLength);
        charTermAttributeImpl.builder = new BytesRefBuilder();
        charTermAttributeImpl.builder.copyBytes(this.builder.get());
        return charTermAttributeImpl;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof CharTermAttributeImpl) {
            object = (CharTermAttributeImpl)object;
            if (this.termLength != ((CharTermAttributeImpl)object).termLength) {
                return false;
            }
            for (int i2 = 0; i2 < this.termLength; ++i2) {
                if (this.termBuffer[i2] == ((CharTermAttributeImpl)object).termBuffer[i2]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String toString() {
        return new String(this.termBuffer, 0, this.termLength);
    }

    @Override
    public void reflectWith(e e2) {
        e2.reflect(b.class, "term", this.toString());
        e2.reflect(g.class, "bytes", this.getBytesRef());
    }
}

