/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.io.Reader;

final class ReusableStringReader
extends Reader {
    private int pos = 0;
    private int size = 0;
    private String s = null;

    ReusableStringReader() {
    }

    final void setValue(String string) {
        this.s = string;
        this.size = string.length();
        this.pos = 0;
    }

    @Override
    public final int read() {
        if (this.pos < this.size) {
            return this.s.charAt(this.pos++);
        }
        this.s = null;
        return -1;
    }

    @Override
    public final int read(char[] cArray, int n2, int n3) {
        if (this.pos < this.size) {
            n3 = Math.min(n3, this.size - this.pos);
            this.s.getChars(this.pos, this.pos + n3, cArray, n2);
            this.pos += n3;
            return n3;
        }
        this.s = null;
        return -1;
    }

    @Override
    public final void close() {
        this.pos = this.size;
        this.s = null;
    }
}

