/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.b;
import org.apache.lucene.analysis.tokenattributes.e;
import org.apache.lucene.analysis.tokenattributes.h;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.c;
import org.apache.lucene.util.d;

public final class NumericTokenStream
extends TokenStream {
    private final a numericAtt = this.addAttribute(a.class);
    private final h typeAtt = this.addAttribute(h.class);
    private final e posIncrAtt = this.addAttribute(e.class);
    private int valSize = 0;
    private final int precisionStep;

    public NumericTokenStream() {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, 16);
    }

    public NumericTokenStream(int n2) {
        this(AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, n2);
    }

    public NumericTokenStream(AttributeFactory attributeFactory, int n2) {
        super(new NumericAttributeFactory(attributeFactory));
        if (n2 <= 0) {
            throw new IllegalArgumentException("precisionStep must be >=1");
        }
        this.precisionStep = n2;
    }

    public final NumericTokenStream setLongValue(long l2) {
        this.valSize = 64;
        return this;
    }

    public final NumericTokenStream setIntValue(int n2) {
        this.valSize = 32;
        return this;
    }

    public final NumericTokenStream setDoubleValue(double d2) {
        Double.doubleToLongBits(d2);
        this.valSize = 64;
        return this;
    }

    public final NumericTokenStream setFloatValue(float f2) {
        Float.floatToIntBits(f2);
        this.valSize = 32;
        return this;
    }

    @Override
    public final void reset() {
        if (this.valSize == 0) {
            throw new IllegalStateException("call set???Value() before usage");
        }
    }

    @Override
    public final boolean incrementToken() {
        if (this.valSize == 0) {
            throw new IllegalStateException("call set???Value() before usage");
        }
        this.clearAttributes();
        int n2 = this.numericAtt.c();
        this.typeAtt.setType(n2 == 0 ? "fullPrecNumeric" : "lowerPrecNumeric");
        this.posIncrAtt.setPositionIncrement(n2 == 0 ? 1 : 0);
        return n2 < this.valSize;
    }

    public final int getPrecisionStep() {
        return this.precisionStep;
    }

    @Override
    public final String toString() {
        return this.getClass().getSimpleName() + "(precisionStep=" + this.precisionStep + " valueSize=" + this.numericAtt.b() + " shift=" + this.numericAtt.a() + ")";
    }

    private static final class NumericAttributeFactory
    extends AttributeFactory {
        private final AttributeFactory delegate;

        NumericAttributeFactory(AttributeFactory attributeFactory) {
            this.delegate = attributeFactory;
        }

        @Override
        public final d createAttributeInstance(Class<? extends c> clazz) {
            if (b.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException("NumericTokenStream does not support CharTermAttribute.");
            }
            return this.delegate.createAttributeInstance(clazz);
        }
    }

    public static interface a
    extends c {
        public int a();

        public int b();

        public int c();
    }
}

