/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.media.player;

import android.content.Context;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import com.netease.nimlib.j.d;
import com.netease.nimlib.sdk.media.player.OnPlayListener;
import java.io.File;

public final class AudioPlayer {
    public static final String TAG = "AudioPlayer";
    private MediaPlayer mPlayer;
    private String mAudioFile;
    private long mIntervalTime = 500L;
    private AudioManager audioManager;
    private OnPlayListener mListener;
    private int audioStreamType = 0;
    private static final int WHAT_COUNT_PLAY = 0;
    private static final int WHAT_DECODE_SUCCEED = 1;
    private static final int WHAT_DECODE_FAILED = 2;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message message) {
            switch (message.what) {
                case 0: {
                    if (AudioPlayer.this.mListener != null) {
                        AudioPlayer.this.mListener.onPlaying(AudioPlayer.this.mPlayer.getCurrentPosition());
                    }
                    this.sendEmptyMessageDelayed(0, AudioPlayer.this.mIntervalTime);
                    return;
                }
                case 2: {
                    d.e(AudioPlayer.TAG, "convert() error: " + AudioPlayer.this.mAudioFile);
                    return;
                }
                case 1: {
                    AudioPlayer.this.startInner();
                }
            }
        }
    };
    AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

        public void onAudioFocusChange(int n2) {
            switch (n2) {
                case 1: {
                    if (!AudioPlayer.this.isPlaying()) break;
                    AudioPlayer.this.mPlayer.setVolume(1.0f, 1.0f);
                    return;
                }
                case -1: {
                    AudioPlayer.this.stop();
                    return;
                }
                case -2: {
                    AudioPlayer.this.stop();
                    return;
                }
                case -3: {
                    if (!AudioPlayer.this.isPlaying()) break;
                    AudioPlayer.this.mPlayer.setVolume(0.1f, 0.1f);
                }
            }
        }
    };

    public AudioPlayer(Context context) {
        this(context, null, null);
    }

    public AudioPlayer(Context context, String string, OnPlayListener onPlayListener) {
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.mAudioFile = string;
        this.mListener = onPlayListener;
    }

    public final void setDataSource(String string) {
        if (!TextUtils.equals((CharSequence)string, (CharSequence)this.mAudioFile)) {
            this.mAudioFile = string;
        }
    }

    public final void setOnPlayListener(OnPlayListener onPlayListener) {
        this.mListener = onPlayListener;
    }

    public final OnPlayListener getOnPlayListener() {
        return this.mListener;
    }

    public final void start(int n2) {
        this.audioStreamType = n2;
        this.startPlay();
    }

    public final void stop() {
        if (this.mPlayer != null) {
            this.endPlay();
            if (this.mListener != null) {
                this.mListener.onInterrupt();
            }
        }
    }

    public final boolean isPlaying() {
        return this.mPlayer != null && this.mPlayer.isPlaying();
    }

    public final long getDuration() {
        if (this.mPlayer != null) {
            return this.mPlayer.getDuration();
        }
        return 0L;
    }

    public final long getCurrentPosition() {
        if (this.mPlayer != null) {
            return this.mPlayer.getCurrentPosition();
        }
        return 0L;
    }

    public final void seekTo(int n2) {
        this.mPlayer.seekTo(n2);
    }

    private void startPlay() {
        d.b(TAG, "start() called");
        this.endPlay();
        this.startInner();
    }

    private void endPlay() {
        this.audioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
        if (this.mPlayer != null) {
            this.mPlayer.stop();
            this.mPlayer.release();
            this.mPlayer = null;
            this.mHandler.removeMessages(0);
        }
    }

    private void startInner() {
        this.mPlayer = new MediaPlayer();
        this.mPlayer.setLooping(false);
        this.mPlayer.setAudioStreamType(this.audioStreamType);
        if (this.audioStreamType == 3) {
            this.audioManager.setSpeakerphoneOn(true);
        } else {
            this.audioManager.setSpeakerphoneOn(false);
        }
        this.audioManager.requestAudioFocus(this.onAudioFocusChangeListener, this.audioStreamType, 2);
        this.mPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

            public void onPrepared(MediaPlayer mediaPlayer) {
                d.b(AudioPlayer.TAG, "player:onPrepared");
                AudioPlayer.this.mHandler.sendEmptyMessage(0);
                if (AudioPlayer.this.mListener != null) {
                    AudioPlayer.this.mListener.onPrepared();
                }
            }
        });
        this.mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                d.b(AudioPlayer.TAG, "player:onCompletion");
                AudioPlayer.this.endPlay();
                if (AudioPlayer.this.mListener != null) {
                    AudioPlayer.this.mListener.onCompletion();
                }
            }
        });
        this.mPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

            public boolean onError(MediaPlayer mediaPlayer, int n2, int n3) {
                d.e(AudioPlayer.TAG, "player:onOnError");
                AudioPlayer.this.endPlay();
                if (AudioPlayer.this.mListener != null) {
                    AudioPlayer.this.mListener.onError(String.format("OnErrorListener what:%d extra:%d", n2, n3));
                }
                return true;
            }
        });
        try {
            if (this.mAudioFile == null) {
                if (this.mListener != null) {
                    this.mListener.onError("no datasource");
                }
                return;
            }
            this.mPlayer.setDataSource(this.mAudioFile);
            this.mPlayer.prepare();
            this.mPlayer.start();
            d.b(TAG, "player:start ok---->" + this.mAudioFile);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            d.e(TAG, "player:onOnError Exception\n" + exception2.toString());
            this.endPlay();
            if (this.mListener != null) {
                this.mListener.onError("Exception\n" + exception2.toString());
            }
            return;
        }
    }

    private void deleteOnExit() {
        File file = new File(this.mAudioFile);
        if (file.exists()) {
            file.deleteOnExit();
        }
    }
}

