/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nimlib.sdk.event.model;

import com.netease.nimlib.sdk.event.model.Event;
import com.netease.nimlib.sdk.event.model.NimEventType;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class NimOnlineStateEvent {
    public static final int EVENT_TYPE = NimEventType.ONLINE_STATE.getValue();
    public static final int MODIFY_EVENT_CONFIG = 10001;
    private static final String KEY_NIM_CONFIG = "online";

    public static boolean isOnlineStateEvent(Event event) {
        return event != null && event.getEventType() == EVENT_TYPE;
    }

    public static OnlineStateEventValue getOnlineStateEventValue(Event event) {
        if (!NimOnlineStateEvent.isOnlineStateEvent(event)) {
            return null;
        }
        return OnlineStateEventValue.getOnlineStateEventValue(event.getEventValue());
    }

    public static List<Integer> getOnlineClients(Event event) {
        ArrayList<Integer> arrayList = null;
        try {
            event = new JSONObject(event.getNimConfig()).getJSONArray(KEY_NIM_CONFIG);
            if (event == null) {
                return null;
            }
            arrayList = new ArrayList<Integer>();
            for (int i2 = 0; i2 < event.length(); ++i2) {
                int n2 = event.getInt(i2);
                arrayList.add(n2);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        return arrayList;
    }

    public static enum OnlineStateEventValue {
        Login(1),
        Logout(2),
        DisConnect(3);

        private int value;

        private OnlineStateEventValue(int n3) {
            this.value = n3;
        }

        public final int getValue() {
            return this.value;
        }

        public static OnlineStateEventValue getOnlineStateEventValue(int n2) {
            switch (n2) {
                case 0: {
                    return Login;
                }
                case 1: {
                    return Logout;
                }
                case 2: {
                    return DisConnect;
                }
            }
            return null;
        }
    }
}

