/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.util;

import java.lang.ref.SoftReference;

public class ThreadLocalCache {
    public static final int CHARS_CACH_INIT_SIZE = 1024;
    public static final int CHARS_CACH_MAX_SIZE = 131072;
    private static final ThreadLocal<SoftReference<char[]>> charsBufLocal = new ThreadLocal();
    public static final int BYTES_CACH_INIT_SIZE = 1024;
    public static final int BYTeS_CACH_MAX_SIZE = 131072;
    private static final ThreadLocal<SoftReference<byte[]>> bytesBufLocal = new ThreadLocal();

    public static void clearChars() {
        charsBufLocal.set(null);
    }

    public static char[] getChars(int length) {
        SoftReference<char[]> ref = charsBufLocal.get();
        if (ref == null) {
            return ThreadLocalCache.allocate(length);
        }
        char[] chars = ref.get();
        if (chars == null) {
            return ThreadLocalCache.allocate(length);
        }
        if (chars.length < length) {
            chars = ThreadLocalCache.allocate(length);
        }
        return chars;
    }

    private static char[] allocate(int length) {
        int allocateLength = ThreadLocalCache.getAllocateLength(1024, 131072, length);
        if (allocateLength <= 131072) {
            char[] chars = new char[allocateLength];
            charsBufLocal.set(new SoftReference<char[]>(chars));
            return chars;
        }
        return new char[length];
    }

    private static int getAllocateLength(int init, int max, int length) {
        int value = init;
        do {
            if (value < length) continue;
            return value;
        } while ((value *= 2) <= max);
        return length;
    }

    public static void clearBytes() {
        bytesBufLocal.set(null);
    }

    public static byte[] getBytes(int length) {
        SoftReference<byte[]> ref = bytesBufLocal.get();
        if (ref == null) {
            return ThreadLocalCache.allocateBytes(length);
        }
        byte[] bytes = ref.get();
        if (bytes == null) {
            return ThreadLocalCache.allocateBytes(length);
        }
        if (bytes.length < length) {
            bytes = ThreadLocalCache.allocateBytes(length);
        }
        return bytes;
    }

    private static byte[] allocateBytes(int length) {
        int allocateLength = ThreadLocalCache.getAllocateLength(1024, 131072, length);
        if (allocateLength <= 131072) {
            byte[] chars = new byte[allocateLength];
            bytesBufLocal.set(new SoftReference<byte[]>(chars));
            return chars;
        }
        return new byte[length];
    }
}

