/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nrtc.video.codec;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Surface;
import com.netease.nrtc.base.Trace;
import com.netease.nrtc.base.f.b;
import com.netease.nrtc.video.codec.CodecManager;
import com.netease.nrtc.video.codec.a;
import com.netease.nrtc.video.gl.SurfaceTextureHelper;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

@TargetApi(value=19)
@com.netease.nrtc.base.annotation.a
public class VideoHwDecoder {
    private Thread b;
    private MediaCodec c;
    private static VideoHwDecoder d = null;
    @com.netease.nrtc.base.annotation.a
    private int colorFormat;
    @com.netease.nrtc.base.annotation.a
    private int width;
    @com.netease.nrtc.base.annotation.a
    private int height;
    @com.netease.nrtc.base.annotation.a
    private int stride;
    @com.netease.nrtc.base.annotation.a
    private int sliceHeight;
    @com.netease.nrtc.base.annotation.a
    private ByteBuffer[] inputBuffers;
    @com.netease.nrtc.base.annotation.a
    private ByteBuffer[] outputBuffers;
    @com.netease.nrtc.base.annotation.a
    private boolean hasDecodedFirstFrame;
    private final Queue<TimeStamps> e = new LinkedList<TimeStamps>();
    private boolean f;
    private a g;
    private int h;
    private Surface i = null;
    private final Queue<DecodedOutputBufferInfo> j = new LinkedList<DecodedOutputBufferInfo>();
    Handler a = new Handler(Looper.myLooper());
    private long k;
    private Runnable l = new Runnable(){

        @Override
        public final void run() {
            VideoHwDecoder.nativeRunDeliverPendingOutputsTask(VideoHwDecoder.this.k);
        }
    };

    private void a() {
        if (this.b.getId() != Thread.currentThread().getId()) {
            throw new IllegalStateException("MediaCodecVideoDecoder previously operated on " + this.b + " but is now called on " + Thread.currentThread());
        }
    }

    @com.netease.nrtc.base.annotation.a
    boolean init(int n, int n2, int n3, SurfaceTextureHelper surfaceTextureHelper) {
        if (this.b != null) {
            Trace.b("VideoHwDecoder", "init error : forgot to release.");
            return false;
        }
        this.f = surfaceTextureHelper != null;
        a.a a2 = null;
        String string = null;
        if (n == 4) {
            string = "video/avc";
            a2 = CodecManager.f();
        }
        if (a2 == null) {
            Trace.b("VideoHwDecoder", "Can not find HW decoder for " + n);
            return false;
        }
        Trace.c("VideoHwDecoder", "Java initDecode: " + n + " : " + n2 + " x " + n3 + ". Color: 0x" + Integer.toHexString(a2.b) + ". Use Surface: " + this.f);
        d = this;
        this.b = Thread.currentThread();
        try {
            MediaFormat mediaFormat;
            block20: {
                this.width = n2;
                this.height = n3;
                this.stride = n2;
                this.sliceHeight = n3;
                if (this.f) {
                    this.g = new a(surfaceTextureHelper);
                    this.i = new Surface(surfaceTextureHelper.a);
                }
                mediaFormat = MediaFormat.createVideoFormat((String)string, (int)n2, (int)n3);
                if (!this.f) {
                    mediaFormat.setInteger("color-format", a2.b);
                }
                Trace.c("VideoHwDecoder", "  Format: " + mediaFormat);
                this.c = com.netease.nrtc.video.codec.a.a(a2.a);
                if (this.c == null) {
                    Trace.b("VideoHwDecoder", "Can not create media decoder");
                    return false;
                }
                surfaceTextureHelper = mediaFormat;
                if (!surfaceTextureHelper.containsKey("max-input-size")) {
                    n2 = surfaceTextureHelper.getInteger("height");
                    n3 = surfaceTextureHelper.getInteger("width");
                    switch (surfaceTextureHelper.getString("mime")) {
                        case "video/avc": {
                            n2 = (n3 + 15) / 16 * ((n2 + 15) / 16) << 4 << 4;
                            n3 = 2;
                            break;
                        }
                        case "video/x-vnd.on2.vp8": {
                            n2 = n3 * n2;
                            n3 = 2;
                            break;
                        }
                        case "video/hevc": 
                        case "video/x-vnd.on2.vp9": {
                            n2 = n3 * n2;
                            n3 = 4;
                            break;
                        }
                        default: {
                            break block20;
                        }
                    }
                    int n4 = n2 * 3 / (2 * n3);
                    surfaceTextureHelper.setInteger("max-input-size", n4);
                }
            }
            this.c.configure(mediaFormat, this.i, null, 0);
            this.c.start();
            this.colorFormat = a2.b;
            this.outputBuffers = this.c.getOutputBuffers();
            this.inputBuffers = this.c.getInputBuffers();
            this.e.clear();
            this.hasDecodedFirstFrame = false;
            this.j.clear();
            this.h = 0;
            Trace.a("VideoHwDecoder", "Input buffers: " + this.inputBuffers.length + ". Output buffers: " + this.outputBuffers.length);
            return true;
        }
        catch (Exception exception) {
            Trace.b("VideoHwDecoder", "initDecode failed" + exception.getMessage());
            return false;
        }
    }

    @com.netease.nrtc.base.annotation.a
    private void reset(int n, int n2) {
        if (this.b == null || this.c == null) {
            throw new RuntimeException("Incorrect reset call for non-initialized decoder.");
        }
        Trace.a("VideoHwDecoder", "reset: " + n + " x " + n2);
        this.c.flush();
        this.width = n;
        this.height = n2;
        this.e.clear();
        this.j.clear();
        this.hasDecodedFirstFrame = false;
        this.h = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @com.netease.nrtc.base.annotation.a
    private void release() {
        Trace.a("VideoHwDecoder", "release decoder.");
        this.a();
        Object object = new CountDownLatch(1);
        Object object2 = new Runnable((CountDownLatch)object){
            final /* synthetic */ CountDownLatch a;
            {
                this.a = countDownLatch;
            }

            @Override
            public final void run() {
                try {
                    Trace.c("VideoHwDecoder", "release decoder on release thread");
                    VideoHwDecoder.this.c.stop();
                    VideoHwDecoder.this.c.release();
                    Trace.a("VideoHwDecoder", "release decoder on release thread done");
                }
                catch (Exception exception) {
                    Trace.b("VideoHwDecoder", "decoder release failed" + exception.getMessage());
                }
                this.a.countDown();
            }
        };
        new Thread((Runnable)object2).start();
        if (!com.netease.nrtc.base.f.b.a((CountDownLatch)object, 5000L)) {
            Trace.b("VideoHwDecoder", "decoder release timeout");
        }
        this.c = null;
        this.b = null;
        d = null;
        if (this.f) {
            this.i.release();
            this.i = null;
            object = this.g;
            object2 = ((a)object).a;
            Trace.a("SurfaceTextureHelper", "stopListening()");
            ((SurfaceTextureHelper)object2).handler.removeCallbacks(((SurfaceTextureHelper)object2).d);
            com.netease.nrtc.base.f.b.a(((SurfaceTextureHelper)object2).handler, new Runnable((SurfaceTextureHelper)object2){
                final /* synthetic */ SurfaceTextureHelper a;
                {
                    this.a = surfaceTextureHelper;
                }

                public final void run() {
                    SurfaceTextureHelper.a(this.a, null);
                    SurfaceTextureHelper.b(this.a);
                }
            });
            object2 = ((a)object).b;
            synchronized (object2) {
                if (((a)object).d != null) {
                    ((a)object).a.returnTextureFrame();
                    ((a)object).d = null;
                }
            }
        }
        Trace.a("VideoHwDecoder", "release decoder done");
    }

    @com.netease.nrtc.base.annotation.a
    private int dequeueInputBuffer() {
        this.a();
        try {
            return this.c.dequeueInputBuffer(500000L);
        }
        catch (IllegalStateException illegalStateException) {
            Trace.b("VideoHwDecoder", "dequeueIntputBuffer failed " + illegalStateException.getMessage());
            return -2;
        }
    }

    @com.netease.nrtc.base.annotation.a
    private boolean queueInputBuffer(int n, int n2, long l, long l2) {
        this.a();
        try {
            this.inputBuffers[n].position(0);
            this.inputBuffers[n].limit(n2);
            this.e.add(new TimeStamps(SystemClock.elapsedRealtime(), l2));
            this.c.queueInputBuffer(n, 0, n2, l, 0);
            return true;
        }
        catch (IllegalStateException illegalStateException) {
            Trace.b("VideoHwDecoder", "decode failed" + illegalStateException.getMessage());
            return false;
        }
    }

    @com.netease.nrtc.base.annotation.a
    private void releaseOutputBuffer(int n) {
        this.a();
        if (this.f) {
            throw new IllegalStateException("releaseOutputBuffer() called for surface decoding.");
        }
        this.c.releaseOutputBuffer(n, false);
    }

    @com.netease.nrtc.base.annotation.a
    private DecodedOutputBufferInfo dequeueOutputBuffer(int n) {
        int n2;
        this.a();
        if (this.e.isEmpty()) {
            return null;
        }
        MediaCodec.BufferInfo bufferInfo = new MediaCodec.BufferInfo();
        block5: while (true) {
            n2 = this.c.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(n));
            switch (n2) {
                case -3: {
                    this.outputBuffers = this.c.getOutputBuffers();
                    Trace.c("VideoHwDecoder", "Decoder output buffers changed: " + this.outputBuffers.length);
                    if (!this.hasDecodedFirstFrame) continue block5;
                    throw new RuntimeException("Unexpected output buffer change event.");
                }
                case -2: {
                    MediaFormat mediaFormat = this.c.getOutputFormat();
                    Trace.c("VideoHwDecoder", "Decoder format changed: " + mediaFormat.toString());
                    int n3 = mediaFormat.getInteger("width");
                    if (mediaFormat.containsKey("crop-left") && mediaFormat.containsKey("crop-right")) {
                        n3 = mediaFormat.getInteger("crop-right") + 1 - mediaFormat.getInteger("crop-left");
                    }
                    int n4 = mediaFormat.getInteger("height");
                    if (mediaFormat.containsKey("crop-top") && mediaFormat.containsKey("crop-bottom")) {
                        n4 = mediaFormat.getInteger("crop-bottom") + 1 - mediaFormat.getInteger("crop-top");
                    }
                    if (this.hasDecodedFirstFrame && (n3 != this.width || n4 != this.height)) {
                        throw new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + n3 + "*" + n4);
                    }
                    this.width = n3;
                    this.height = n4;
                    if (!this.f && mediaFormat.containsKey("color-format")) {
                        this.colorFormat = mediaFormat.getInteger("color-format");
                        Trace.c("VideoHwDecoder", "Color: 0x" + Integer.toHexString(this.colorFormat));
                        if (!com.netease.nrtc.video.codec.a.c.contains(this.colorFormat)) {
                            throw new IllegalStateException("Non supported color format: " + this.colorFormat);
                        }
                    }
                    if (mediaFormat.containsKey("stride")) {
                        this.stride = mediaFormat.getInteger("stride");
                    }
                    if (mediaFormat.containsKey("slice-height")) {
                        this.sliceHeight = mediaFormat.getInteger("slice-height");
                    }
                    Trace.c("VideoHwDecoder", "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
                    this.stride = Math.max(this.width, this.stride);
                    this.sliceHeight = Math.max(this.height, this.sliceHeight);
                    continue block5;
                }
                case -1: {
                    return null;
                }
            }
            break;
        }
        this.hasDecodedFirstFrame = true;
        TimeStamps timeStamps = this.e.remove();
        long l = SystemClock.elapsedRealtime() - timeStamps.decodeStartTimeMs;
        if (l > 500L) {
            Trace.b("VideoHwDecoder", "Very high decode time: " + l + "ms.");
            l = 500L;
        }
        return new DecodedOutputBufferInfo(n2, bufferInfo.offset, bufferInfo.size, TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs), timeStamps.timeStampMs, l, SystemClock.elapsedRealtime());
    }

    @com.netease.nrtc.base.annotation.a
    private DecodedTextureBufferInfo dequeueTextureBuffer(int n) {
        this.a();
        if (!this.f) {
            throw new IllegalStateException("dequeueTexture() called for byte buffer decoding.");
        }
        Object object = this.dequeueOutputBuffer(n);
        if (object != null) {
            this.j.add((DecodedOutputBufferInfo)object);
        }
        this.b();
        object = this.g.a(n);
        if (object != null) {
            this.b();
            return object;
        }
        if (this.j.size() >= Math.min(3, this.outputBuffers.length) || n > 0 && !this.j.isEmpty()) {
            ++this.h;
            object = this.j.remove();
            if (n > 0) {
                Trace.b("VideoHwDecoder", "Draining decoder. Dropping frame with TS: " + ((DecodedOutputBufferInfo)object).presentationTimeStampMs + ". Total number of dropped frames: " + this.h);
            } else {
                Trace.b("VideoHwDecoder", "Too many output buffers " + this.j.size() + ". Dropping frame with TS: " + ((DecodedOutputBufferInfo)object).presentationTimeStampMs + ". Total number of dropped frames: " + this.h);
            }
            this.c.releaseOutputBuffer(((DecodedOutputBufferInfo)object).index, false);
            return new DecodedTextureBufferInfo(0, null, ((DecodedOutputBufferInfo)object).presentationTimeStampMs, ((DecodedOutputBufferInfo)object).timeStampMs, ((DecodedOutputBufferInfo)object).decodeTimeMs, SystemClock.elapsedRealtime() - ((DecodedOutputBufferInfo)object).endDecodeTimeMs);
        }
        return null;
    }

    private void b() {
        DecodedOutputBufferInfo decodedOutputBufferInfo;
        if (this.j.isEmpty() || this.g.a()) {
            return;
        }
        DecodedOutputBufferInfo decodedOutputBufferInfo2 = decodedOutputBufferInfo = this.j.remove();
        a a2 = this.g;
        if (a2.c != null) {
            Trace.b("VideoHwDecoder", "Unexpected addBufferToRender() called while waiting for a texture.");
            throw new IllegalStateException("Waiting for a texture.");
        }
        a2.c = decodedOutputBufferInfo2;
        this.c.releaseOutputBuffer(decodedOutputBufferInfo.index, true);
    }

    @com.netease.nrtc.base.annotation.a
    void deliverPendingOutputs(long l, int n) {
        this.k = l;
        this.a.postDelayed(this.l, (long)n);
    }

    @com.netease.nrtc.base.annotation.a
    void clearDeliverRunnable() {
        Trace.a("VideoHwDecoder", "clear pending deliver");
        this.a.removeCallbacks(this.l);
        this.k = 0L;
    }

    static native void nativeRunDeliverPendingOutputsTask(long var0);

    private static final class a
    implements SurfaceTextureHelper.a {
        final SurfaceTextureHelper a;
        final Object b = new Object();
        DecodedOutputBufferInfo c;
        DecodedTextureBufferInfo d;

        public a(SurfaceTextureHelper surfaceTextureHelper) {
            this.a = surfaceTextureHelper;
            a a2 = this;
            if (surfaceTextureHelper.b != null || surfaceTextureHelper.c != null) {
                throw new IllegalStateException("SurfaceTextureHelper listener has already been set.");
            }
            surfaceTextureHelper.c = a2;
            surfaceTextureHelper.handler.post(surfaceTextureHelper.d);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final boolean a() {
            Object object = this.b;
            synchronized (object) {
                return this.c != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void a(int n, float[] fArray) {
            Object object = this.b;
            synchronized (object) {
                if (this.d != null) {
                    Trace.b("VideoHwDecoder", "Unexpected onTextureFrameAvailable() called while already holding a texture.");
                    throw new IllegalStateException("Already holding a texture.");
                }
                this.d = new DecodedTextureBufferInfo(n, fArray, this.c.presentationTimeStampMs, this.c.timeStampMs, this.c.decodeTimeMs, SystemClock.elapsedRealtime() - this.c.endDecodeTimeMs);
                this.c = null;
                this.b.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final DecodedTextureBufferInfo a(int n) {
            Object object = this.b;
            synchronized (object) {
                if (this.d == null && n > 0 && this.a()) {
                    try {
                        this.b.wait(n);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                DecodedTextureBufferInfo decodedTextureBufferInfo = this.d;
                this.d = null;
                return decodedTextureBufferInfo;
            }
        }
    }

    @com.netease.nrtc.base.annotation.a
    private static class DecodedTextureBufferInfo {
        @com.netease.nrtc.base.annotation.a
        private final int textureID;
        @com.netease.nrtc.base.annotation.a
        private final float[] transformMatrix;
        @com.netease.nrtc.base.annotation.a
        private final long presentationTimeStampMs;
        @com.netease.nrtc.base.annotation.a
        private final long timeStampMs;
        @com.netease.nrtc.base.annotation.a
        private final long decodeTimeMs;
        @com.netease.nrtc.base.annotation.a
        private final long frameDelayMs;

        @com.netease.nrtc.base.annotation.a
        public DecodedTextureBufferInfo(int n, float[] fArray, long l, long l2, long l3, long l4) {
            this.textureID = n;
            this.transformMatrix = fArray;
            this.presentationTimeStampMs = l;
            this.timeStampMs = l2;
            this.decodeTimeMs = l3;
            this.frameDelayMs = l4;
        }
    }

    @com.netease.nrtc.base.annotation.a
    private static class DecodedOutputBufferInfo {
        @com.netease.nrtc.base.annotation.a
        private final int index;
        @com.netease.nrtc.base.annotation.a
        private final int offset;
        @com.netease.nrtc.base.annotation.a
        private final int size;
        @com.netease.nrtc.base.annotation.a
        private final long presentationTimeStampMs;
        @com.netease.nrtc.base.annotation.a
        private final long timeStampMs;
        @com.netease.nrtc.base.annotation.a
        private final long decodeTimeMs;
        @com.netease.nrtc.base.annotation.a
        private final long endDecodeTimeMs;

        @com.netease.nrtc.base.annotation.a
        public DecodedOutputBufferInfo(int n, int n2, int n3, long l, long l2, long l3, long l4) {
            this.index = n;
            this.offset = n2;
            this.size = n3;
            this.presentationTimeStampMs = l;
            this.timeStampMs = l2;
            this.decodeTimeMs = l3;
            this.endDecodeTimeMs = l4;
        }
    }

    @com.netease.nrtc.base.annotation.a
    private static class TimeStamps {
        @com.netease.nrtc.base.annotation.a
        private final long decodeStartTimeMs;
        @com.netease.nrtc.base.annotation.a
        private final long timeStampMs;

        @com.netease.nrtc.base.annotation.a
        public TimeStamps(long l, long l2) {
            this.decodeStartTimeMs = l;
            this.timeStampMs = l2;
        }
    }
}

