/*
 * Decompiled with CFR 0.152.
 */
package com.netease.vcloud.video.effect;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.os.Build;
import com.netease.vcloud.video.AbstractLog;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public abstract class VideoEffect {
    private static final String TAG = "VideoEffect";
    private boolean mUseFilter;
    private YUVData[] mArrayData;
    private YUVData mYUVData;
    private YUVData mYUVMirrorData;
    private BitmapData mWaterBitmap;
    private BitmapData[] mDynamicWaterBitmap;
    private int mDynamicIndex = 0;
    private int mDynamicFpsIndex = 0;
    private int mDynamicDrawCount = 0;
    private boolean mDynamicLooped = false;
    private boolean mIsDynamicClose = false;
    private BitmapData mGraffitiBitmap;
    private final Object mGraffitiLock = new Object();
    private final Object mWaterLock = new Object();
    private final Object mDynamicWaterLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addWaterMark(Bitmap bitmap, int x, int y) {
        Object object = this.mWaterLock;
        synchronized (object) {
            if (bitmap == null) {
                this.mWaterBitmap = null;
            } else if (this.mWaterBitmap == null) {
                void var3_4;
                void var2_3;
                void var1_1;
                this.mWaterBitmap = this.getBitmapData((Bitmap)var1_1, (int)var2_3, (int)var3_4);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDynamicWaterMark(Bitmap[] bitmapArray, int x, int y, int fps, int cameraFps, boolean looped) {
        Object object = this.mDynamicWaterLock;
        synchronized (object) {
            if (bitmapArray == null) {
                this.mDynamicWaterBitmap = null;
            } else if (this.mDynamicWaterBitmap == null) {
                this.mDynamicWaterBitmap = new BitmapData[bitmapArray.length];
                for (int i2 = 0; i2 < bitmapArray.length; ++i2) {
                    this.mDynamicWaterBitmap[i2] = this.getBitmapData(bitmapArray[i2], x, y);
                }
                this.mDynamicIndex = 0;
                this.mDynamicDrawCount = cameraFps / fps;
                if (this.mDynamicDrawCount == 0) {
                    this.mDynamicDrawCount = 1;
                }
                this.mDynamicLooped = looped;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void closeDynamicWaterMark(boolean close) {
        void var1_1;
        this.mIsDynamicClose = var1_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void addGraffiti(Bitmap bitmap, int x, int y) {
        Object object = this.mGraffitiLock;
        synchronized (object) {
            void var3_4;
            void var2_3;
            void var1_1;
            this.mGraffitiBitmap = this.getBitmapData((Bitmap)var1_1, (int)var2_3, (int)var3_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private BitmapData getBitmapData(Bitmap bitmap, int x, int y) {
        void var1_1;
        void var3_4;
        void var2_2;
        BitmapData bitmapData = new BitmapData();
        new BitmapData().width = bitmap.getWidth();
        bitmapData.height = bitmap.getHeight();
        bitmapData.x = var2_2;
        bitmapData.y = var3_4;
        ByteBuffer byteBuffer = ByteBuffer.allocate(bitmapData.width * bitmapData.height << 2);
        var1_1.copyPixelsToBuffer((Buffer)byteBuffer);
        bitmapData.data = byteBuffer.array();
        return bitmapData;
    }

    /*
     * WARNING - void declaration
     */
    public void init(Context context, boolean useFilter, boolean hasGLContext) {
        void var2_2;
        AbstractLog.d(TAG, "init:useFilter->" + useFilter + " hasGLContext->" + hasGLContext);
        VideoEffect.InitAll();
        this.mUseFilter = useFilter;
        if (var2_2 != false) {
            void var3_3;
            if (var3_3 != false) {
                this.filterInit(context);
            } else {
                void var1_1;
                this.filterInitWithoutGLContext((Context)var1_1);
            }
        }
        this.mArrayData = new YUVData[2];
    }

    public void unInit() {
        AbstractLog.d(TAG, "unInit:useFilter->" + this.mUseFilter);
        VideoEffect.UnInitAll();
        if (this.mUseFilter) {
            this.filterUnInit();
            this.mUseFilter = false;
        }
        this.mYUVData = null;
        this.mYUVMirrorData = null;
        this.mArrayData = null;
        this.mWaterBitmap = null;
        this.mDynamicWaterBitmap = null;
        this.mGraffitiBitmap = null;
    }

    public abstract boolean filterInit(Context var1);

    public abstract boolean filterInitWithoutGLContext(Context var1);

    public abstract void filterUnInit();

    public abstract void setFilterType(FilterType var1);

    public abstract void setFilterLevel(float var1);

    public abstract void setBeautyLevel(int var1);

    public abstract byte[] filterBufferToRGBA(DataFormat var1, byte[] var2, int var3, int var4);

    public abstract byte[] filterTextureToRGBA(int var1, int var2, int var3);

    /*
     * WARNING - void declaration
     */
    public YUVData[] TOYUV420(byte[] src, DataFormat dataFormat, int inWidth, int inHeight, int cameraRotation, int displayOrientation, int outWidth, int outHeight, boolean needMirrorData, boolean autoEffect) {
        void var3_3;
        void var2_2;
        void var1_1;
        int n2;
        block13: {
            block11: {
                block12: {
                    if (displayOrientation == 90) {
                        n2 = cameraRotation;
                    } else {
                        n2 = displayOrientation;
                        if (displayOrientation == 270 && Build.MODEL.contains("Nexus 6")) {
                            n2 = 90;
                        }
                    }
                    if (this.mYUVData == null) break block11;
                    if (n2 != 90 && n2 != 270) break block12;
                    if (this.mYUVData.width != outHeight || this.mYUVData.height != outWidth) {
                        this.initYUVData(outWidth, outHeight);
                    }
                    break block13;
                }
                if (this.mYUVData.width == outWidth && this.mYUVData.height == outHeight) break block13;
            }
            this.initYUVData(outWidth, outHeight);
        }
        this.mYUVData.width = outWidth;
        this.mYUVData.height = outHeight;
        VideoEffect.TOYUV((byte[])var1_1, var2_2.ordinal(), (int)var3_3, inHeight, n2, this.mYUVData.data, this.mYUVData.width, this.mYUVData.height);
        if (n2 == 90 || n2 == 270) {
            this.mYUVData.width = outHeight;
            this.mYUVData.height = outWidth;
        }
        if (needMirrorData) {
            this.yuvMirror(this.mYUVData.data, this.mYUVData.width, this.mYUVData.height);
        }
        if (autoEffect) {
            this.effectWater(needMirrorData);
            this.effectDynamicWater(needMirrorData);
            this.effectGraffiti(needMirrorData);
        }
        this.mArrayData[0] = this.mYUVData;
        this.mArrayData[1] = this.mYUVMirrorData;
        return this.mArrayData;
    }

    /*
     * WARNING - void declaration
     */
    public void effectWater(YUVData data) {
        if (this.mWaterBitmap != null) {
            void var1_1;
            this.addBitmap(data.data, data.width, var1_1.height, this.mWaterBitmap.data, this.mWaterBitmap.width, this.mWaterBitmap.height, this.mWaterBitmap.x, this.mWaterBitmap.y);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void effectDynamicWater(YUVData data, boolean next) {
        if (this.mDynamicWaterBitmap != null) {
            if (this.mDynamicIndex < this.mDynamicWaterBitmap.length) {
                void var2_2;
                void var1_1;
                this.addBitmap(data.data, data.width, var1_1.height, this.mDynamicWaterBitmap[this.mDynamicIndex].data, this.mDynamicWaterBitmap[this.mDynamicIndex].width, this.mDynamicWaterBitmap[this.mDynamicIndex].height, this.mDynamicWaterBitmap[this.mDynamicIndex].x, this.mDynamicWaterBitmap[this.mDynamicIndex].y);
                if (var2_2 != false) {
                    ++this.mDynamicFpsIndex;
                    if (this.mDynamicFpsIndex == this.mDynamicDrawCount) {
                        ++this.mDynamicIndex;
                        this.mDynamicFpsIndex = 0;
                        return;
                    }
                }
            } else if (this.mDynamicLooped) {
                this.mDynamicIndex = 0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void effectGraffiti(YUVData data) {
        if (this.mGraffitiBitmap != null) {
            Object object = this.mGraffitiLock;
            synchronized (object) {
                if (this.mGraffitiBitmap != null) {
                    void var1_1;
                    this.addBitmap(data.data, data.width, var1_1.height, this.mGraffitiBitmap.data, this.mGraffitiBitmap.width, this.mGraffitiBitmap.height, this.mGraffitiBitmap.x, this.mGraffitiBitmap.y);
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void initYUVData(int width, int height) {
        void var2_2;
        void var1_1;
        this.mYUVData = new YUVData(this);
        this.mYUVData.width = var1_1;
        this.mYUVData.height = var2_2;
        this.mYUVData.data = new byte[this.mYUVData.width * this.mYUVData.height * ImageFormat.getBitsPerPixel((int)17) / 8];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void effectWater(boolean needMirrorData) {
        if (this.mWaterBitmap != null) {
            Object object = this.mWaterLock;
            synchronized (object) {
                if (this.mWaterBitmap != null) {
                    void var1_1;
                    this.addBitmap(this.mYUVData.data, this.mYUVData.width, this.mYUVData.height, this.mWaterBitmap.data, this.mWaterBitmap.width, this.mWaterBitmap.height, this.mWaterBitmap.x, this.mWaterBitmap.y);
                    if (var1_1 != false) {
                        this.addBitmap(this.mYUVMirrorData.data, this.mYUVMirrorData.width, this.mYUVMirrorData.height, this.mWaterBitmap.data, this.mWaterBitmap.width, this.mWaterBitmap.height, this.mWaterBitmap.x, this.mWaterBitmap.y);
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void effectDynamicWater(boolean needMirrorData) {
        if (this.mDynamicWaterBitmap != null) {
            Object object = this.mDynamicWaterLock;
            synchronized (object) {
                if (this.mDynamicWaterBitmap != null && !this.mIsDynamicClose) {
                    if (this.mDynamicIndex < this.mDynamicWaterBitmap.length) {
                        void var1_1;
                        this.addBitmap(this.mYUVData.data, this.mYUVData.width, this.mYUVData.height, this.mDynamicWaterBitmap[this.mDynamicIndex].data, this.mDynamicWaterBitmap[this.mDynamicIndex].width, this.mDynamicWaterBitmap[this.mDynamicIndex].height, this.mDynamicWaterBitmap[this.mDynamicIndex].x, this.mDynamicWaterBitmap[this.mDynamicIndex].y);
                        if (var1_1 != false) {
                            this.addBitmap(this.mYUVMirrorData.data, this.mYUVMirrorData.width, this.mYUVMirrorData.height, this.mDynamicWaterBitmap[this.mDynamicIndex].data, this.mDynamicWaterBitmap[this.mDynamicIndex].width, this.mDynamicWaterBitmap[this.mDynamicIndex].height, this.mDynamicWaterBitmap[this.mDynamicIndex].x, this.mDynamicWaterBitmap[this.mDynamicIndex].y);
                        }
                        ++this.mDynamicFpsIndex;
                        if (this.mDynamicFpsIndex == this.mDynamicDrawCount) {
                            ++this.mDynamicIndex;
                            this.mDynamicFpsIndex = 0;
                        }
                    } else if (this.mDynamicLooped) {
                        this.mDynamicIndex = 0;
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void effectGraffiti(boolean needMirrorData) {
        if (this.mGraffitiBitmap != null) {
            Object object = this.mGraffitiLock;
            synchronized (object) {
                if (this.mGraffitiBitmap != null) {
                    void var1_1;
                    this.addBitmap(this.mYUVData.data, this.mYUVData.width, this.mYUVData.height, this.mGraffitiBitmap.data, this.mGraffitiBitmap.width, this.mGraffitiBitmap.height, this.mGraffitiBitmap.x, this.mGraffitiBitmap.y);
                    if (var1_1 != false) {
                        this.addBitmap(this.mYUVMirrorData.data, this.mYUVMirrorData.width, this.mYUVMirrorData.height, this.mGraffitiBitmap.data, this.mGraffitiBitmap.width, this.mGraffitiBitmap.height, this.mGraffitiBitmap.x, this.mGraffitiBitmap.y);
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void yuvMirror(byte[] srcYuv, int width, int height) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (this.mYUVMirrorData == null || this.mYUVMirrorData.width != width || this.mYUVMirrorData.height != height) {
            this.mYUVMirrorData = new YUVData(this);
            this.mYUVMirrorData.width = width;
            this.mYUVMirrorData.height = height;
            this.mYUVMirrorData.data = new byte[this.mYUVMirrorData.width * this.mYUVMirrorData.height * ImageFormat.getBitsPerPixel((int)17) / 8];
        }
        VideoEffect.YUVMirror((byte[])var1_1, (int)var2_2, (int)var3_3, this.mYUVMirrorData.data);
    }

    /*
     * WARNING - void declaration
     */
    private void addBitmap(byte[] yuv, int width, int height, byte[] bitmap, int bitmapWidth, int bitmapHeight, int x, int y) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (x < 0) {
            x = 0;
        } else if (bitmapWidth + x > width) {
            x = width - bitmapWidth;
        }
        if (y < 0) {
            y = 0;
        } else if (bitmapHeight + y > height) {
            y = height - bitmapHeight;
        }
        VideoEffect.AddBitmap((byte[])var1_1, (int)var2_2, (int)var3_3, bitmap, bitmapWidth, bitmapHeight, x, y);
    }

    public static native int TOARGB(byte[] var0, int var1, int var2, int var3, byte[] var4);

    public static native int glReadPixelsPBO(int var0, int var1, int var2, int var3, int var4, int var5);

    private static native int TOYUV(byte[] var0, int var1, int var2, int var3, int var4, byte[] var5, int var6, int var7);

    private static native int AddBitmap(byte[] var0, int var1, int var2, byte[] var3, int var4, int var5, int var6, int var7);

    private static native int YUVMirror(byte[] var0, int var1, int var2, byte[] var3);

    private static native int InitAll();

    private static native int UnInitAll();

    static {
        System.loadLibrary("videoeffect");
    }

    class BitmapData {
        public byte[] data;
        public int width;
        public int height;
        public int x;
        public int y;

        private BitmapData() {
        }
    }

    public class YUVData {
        public byte[] data;
        public int width;
        public int height;
        final /* synthetic */ VideoEffect this$0;

        /*
         * WARNING - void declaration
         */
        public YUVData(VideoEffect this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }
    }

    public static enum FilterType {
        none,
        brooklyn,
        calm,
        clean,
        fairytale,
        nature,
        healthy,
        pixar,
        tender,
        whiten;

    }

    public static enum DataFormat {
        YUV420,
        NV21,
        NV12,
        RGBA;

    }
}

