/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nrtc.voice.codec;

import android.annotation.SuppressLint;
import android.media.MediaCodec;
import android.media.MediaCodecList;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.os.Build;
import com.netease.nrtc.base.Trace;
import com.netease.nrtc.base.g;
import com.netease.nrtc.utility.a.a;
import com.netease.nrtc.utility.a.b;
import java.io.File;
import java.nio.ByteBuffer;

@com.netease.nrtc.base.annotation.a
class AudioFileDecoder {
    private MediaExtractor b;
    private MediaFormat c;
    private MediaCodec d;
    private boolean e = false;
    private boolean f = false;
    private boolean g = false;
    private ByteBuffer h;

    AudioFileDecoder() {
    }

    @SuppressLint(value={"NewApi"})
    @com.netease.nrtc.base.annotation.a
    public boolean init(String string) {
        Trace.a("AudioFileDecoder", "init");
        if (com.netease.nrtc.base.g.a((CharSequence)string)) {
            Trace.b("AudioFileDecoder", "init audio decoder error, file is empty!");
            return false;
        }
        if (!new File(string).exists()) {
            Trace.b("AudioFileDecoder", "init audio decoder error, file is not exists!");
            return false;
        }
        try {
            int n;
            this.b = new MediaExtractor();
            this.b.setDataSource(string);
            int n2 = this.b.getTrackCount();
            for (n = 0; n < n2; ++n) {
                this.b.unselectTrack(n);
            }
            for (n = 0; n < n2; ++n) {
                this.c = this.b.getTrackFormat(n);
                String string2 = this.c.getString("mime");
                if (!string2.contains("audio/") || string2.equals(com.netease.nrtc.utility.a.a.a.get(Build.MODEL))) continue;
                this.b.selectTrack(n);
                if (com.netease.nrtc.utility.a.b.a(22)) {
                    string2 = new MediaCodecList(0).findDecoderForFormat(this.c);
                    if (com.netease.nrtc.base.g.b(string2)) {
                        this.d = MediaCodec.createByCodecName((String)string2);
                        Trace.a("AudioFileDecoder", "create codec by name: " + string2);
                    }
                } else {
                    this.d = MediaCodec.createDecoderByType((String)string2);
                    Trace.a("AudioFileDecoder", "create codec by type: " + string2);
                }
                if (this.d == null) continue;
                this.d.configure(this.c, null, null, 0);
                Trace.a("AudioFileDecoder", "configure codec:" + this.c.toString());
                break;
            }
            if (this.d != null) {
                this.d.start();
                return true;
            }
        }
        catch (Exception exception) {
            Trace.b("AudioFileDecoder", "init audio decoder exception, " + exception.getMessage());
            this.release();
        }
        return false;
    }

    @com.netease.nrtc.base.annotation.a
    public void release() {
        Trace.a("AudioFileDecoder", "release file decoder");
        if (this.d != null) {
            if (com.netease.nrtc.utility.a.b.a(18)) {
                Trace.a("AudioFileDecoder", "release codec:" + this.d.getName());
            } else {
                Trace.a("AudioFileDecoder", "release codec");
            }
            this.d.stop();
            this.d.release();
            this.d = null;
        }
        if (this.b != null) {
            this.b.release();
            this.b = null;
        }
        this.e = false;
        this.f = false;
        this.g = false;
    }

    @com.netease.nrtc.base.annotation.a
    public int getChannelCount() {
        return this.c.getInteger("channel-count");
    }

    @com.netease.nrtc.base.annotation.a
    public int getSampleRate() {
        return this.c.getInteger("sample-rate");
    }

    @com.netease.nrtc.base.annotation.a
    public long getDurationUs() {
        return this.c.getLong("durationUs");
    }

    @com.netease.nrtc.base.annotation.a
    public void rewind() {
        this.b.seekTo(0L, 1);
        this.d.flush();
        this.e = false;
        this.f = false;
        this.g = false;
    }

    @com.netease.nrtc.base.annotation.a
    public boolean isOutputReady() {
        return this.g;
    }

    @com.netease.nrtc.base.annotation.a
    public ByteBuffer getOutputBuffer() {
        return this.h;
    }

    @com.netease.nrtc.base.annotation.a
    public boolean decodeFrame() {
        int n;
        if (!this.e) {
            int n2 = this.d.dequeueInputBuffer(0L);
            if (n2 >= 0) {
                ByteBuffer byteBuffer = com.netease.nrtc.utility.a.b.a(21) ? this.d.getInputBuffer(n2) : this.d.getInputBuffers()[n2];
                assert (byteBuffer != null);
                int n3 = this.b.readSampleData(byteBuffer, 0);
                if (n3 <= 0) {
                    n3 = 0;
                    this.e = true;
                }
                long l = this.b.getSampleTime();
                n = this.b.getSampleFlags();
                if (this.e) {
                    n |= 4;
                }
                this.d.queueInputBuffer(n2, 0, n3, l, n);
                this.b.advance();
            } else {
                Trace.c("AudioFileDecoder", "decoder dequeue input buffer error : " + n2);
            }
        }
        if (!this.f) {
            Object object = new MediaCodec.BufferInfo();
            n = this.d.dequeueOutputBuffer(object, 0L);
            this.g = false;
            switch (n) {
                case -1: {
                    Trace.c("AudioFileDecoder", "decode:INFO_TRY_AGAIN_LATER");
                    break;
                }
                case -2: {
                    Trace.a("AudioFileDecoder", "decode:INFO_OUTPUT_FORMAT_CHANGED");
                    Trace.a("AudioFileDecoder", "decode output new format:" + this.d.getOutputFormat().toString());
                    break;
                }
                case -3: {
                    Trace.c("AudioFileDecoder", "decode:INFO_OUTPUT_BUFFERS_CHANGED");
                    break;
                }
                default: {
                    if (n >= 0) {
                        if ((object.flags & 4) == 4) {
                            this.f = true;
                        }
                        if (com.netease.nrtc.utility.a.b.a(21)) {
                            ByteBuffer byteBuffer = this.d.getOutputBuffer(n);
                            object = this;
                            if (object.h == null || object.h.capacity() < byteBuffer.limit()) {
                                if (object.h != null) {
                                    object.h.clear();
                                    object.h = null;
                                }
                                object.h = ByteBuffer.allocateDirect(byteBuffer.limit());
                            }
                            object.h.position(0);
                            object.h.put(byteBuffer);
                        } else {
                            ByteBuffer byteBuffer = this.d.getOutputBuffers()[n];
                            int n4 = object.size;
                            object = this;
                            if (object.h == null || object.h.capacity() < n4) {
                                if (object.h != null) {
                                    object.h.clear();
                                    object.h = null;
                                }
                                object.h = ByteBuffer.allocateDirect(n4);
                            }
                            object.h.position(0);
                            byteBuffer.limit(n4);
                            object.h.put(byteBuffer);
                        }
                        this.d.releaseOutputBuffer(n, false);
                        this.g = true;
                        break;
                    }
                    Trace.b("AudioFileDecoder", "decoder dequeue output buffer error : " + n);
                }
            }
        }
        return !this.f;
    }
}

