/*
 * Decompiled with CFR 0.152.
 */
package com.netease.nrtc.engine.rawapi;

import com.netease.nrtc.base.a;
import com.netease.nrtc.base.annotation.AccessPolicy;
import com.netease.nrtc.base.annotation.Privilege;
import com.netease.nrtc.base.annotation.b;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class RtcParameters {
    public static final String MEDIA_CODEC_AUTO = "media_codec_auto";
    public static final String MEDIA_CODEC_HARDWARE = "media_codec_hardware";
    public static final String MEDIA_CODEC_SOFTWARE = "media_codec_software";
    public static final String AUDIO_EFFECT_MODE_DISABLE = "audio_effect_mode_disable";
    public static final String AUDIO_EFFECT_MODE_PLATFORM_BUILTIN_PRIORITY = "audio_effect_mode_platform_builtin_priority";
    public static final String AUDIO_EFFECT_MODE_SDK_BUILTIN_PRIORITY = "audio_effect_mode_sdk_builtin_priority";
    @b(a=Integer.class, b={0, 1, 2, 3}, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_DEVICE_DEFAULT_ROTATION = "key_device_default_rotation";
    @b(a=Integer.class, b={0, 1, 2, 3}, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_DEVICE_ROTATION_FIXED_OFFSET = "key_device_rotation_fixed_offset";
    @b(a=String.class, c={"media_codec_auto", "media_codec_hardware", "media_codec_software"}, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_ENCODER_MODE = "key_video_encoder_mode";
    @b(a=String.class, c={"media_codec_auto", "media_codec_hardware", "media_codec_software"}, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_DECODER_MODE = "key_video_decoder_mode";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.READ)
    public static final String KEY_VIDEO_SUPPORTED_HW_ENCODER = "key_video_supported_hw_encoder";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.READ)
    public static final String KEY_VIDEO_SUPPORTED_HW_DECODER = "key_video_supported_hw_decoder";
    @b(a=Boolean.class, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_SERVER_AUDIO_RECORD = "key_server_audio_record";
    @b(a=Boolean.class, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_SERVER_VIDEO_RECORD = "key_server_video_record";
    @b(a=Boolean.class, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_SERVER_LIVE_RECORD = "key_server_live_record";
    @b(a=Boolean.class, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_CALL_PROXIMITY = "key_audio_call_proximity";
    @b(a=Integer.class, b={1, 2, 3, 4, 5, 0}, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_QUALITY = "key_video_quality";
    @b(a=Integer.class, b={5, 10, 15, 20, 25}, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_FRAME_RATE = "key_video_frame_rate";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_ROTATE_IN_RENDING = "key_video_rotate_in_rending";
    @b(a=Boolean.class, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_DEFAULT_FRONT_CAMERA = "key_video_default_front_camera";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_MUTE_LOCAL_STREAM = "key_audio_mute_local_stream";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_MUTE_LOCAL_STREAM = "key_video_mute_local_stream";
    @b(a=Integer.class, b={1, 0}, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_SESSION_MULTI_MODE_USER_ROLE = "key_session_multi_mode_user_role";
    @b(a=Boolean.class, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_SESSION_MULTI_MODE = "key_session_multi_mode";
    @b(a=Boolean.class, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_SESSION_WEBRTC_COMPAT = "key_session_webrtc_compat";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_FPS_REPORTED = "key_video_fps_reported";
    @b(a=Integer.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_MAX_BITRATE = "key_video_max_bitrate";
    @b(a=String.class, c={"audio_effect_mode_disable", "audio_effect_mode_platform_builtin_priority", "audio_effect_mode_sdk_builtin_priority"}, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_EFFECT_NOISE_SUPPRESSOR = "key_audio_effect_noise_suppressor";
    @b(a=String.class, c={"audio_effect_mode_disable", "audio_effect_mode_platform_builtin_priority", "audio_effect_mode_sdk_builtin_priority"}, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_EFFECT_ACOUSTIC_ECHO_CANCELER = "key_audio_effect_acoustic_echo_canceler";
    @b(a=String.class, c={"audio_effect_mode_disable", "audio_effect_mode_platform_builtin_priority", "audio_effect_mode_sdk_builtin_priority"}, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_EFFECT_AUTOMATIC_GAIN_CONTROL = "key_audio_effect_automatic_gain_control";
    @b(a=Boolean.class, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_SESSION_LIVE_MODE = "key_session_live_mode";
    @b(a=String.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_SESSION_LIVE_URL = "key_session_live_url";
    @b(a=Boolean.class, d=false, e=Privilege.PROTECTED, f=AccessPolicy.WRITE)
    public static final String KEY_NET_P2P = "key_net_p2p";
    @b(a=Integer.class, b={1, 0, 2, 3, 4}, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_SESSION_LIVE_PIP_MODE = "key_session_live_pip_mode";
    @b(a=String.class, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_SESSION_LIVE_PIP_MODE_ENHANCE = "key_session_live_pip_mode_enhance";
    @b(a=Boolean.class, d=false, e=Privilege.PROTECTED, f=AccessPolicy.WRITE)
    public static final String KEY_MONSTER_MODE = "key_monster_mode";
    @b(a=Boolean.class, d=false, e=Privilege.PROTECTED, f=AccessPolicy.READ)
    public static final String KEY_MONSTER_SUPPORTED = "key_monster_supported";
    @b(a=String.class, d=false, e=Privilege.PROTECTED, f=AccessPolicy.WRITE)
    public static final String KEY_SESSION_PRIVATE_SERVER = "key_session_private_server";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_FRAME_FILTER = "key_video_frame_filter";
    @b(a=Integer.class, b={1, 13}, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_FRAME_FILTER_FORMAT = "key_video_frame_filter_format";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_FRAME_FILTER = "key_audio_frame_filter";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_REPORT_SPEAKER = "key_audio_report_speaker";
    @b(a=Integer.class, b={1, 6}, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_OS_CATEGORY = "key_os_category";
    @b(a=Float.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_MIXING_STREAM_VOLUME = "key_audio_mixing_stream_volume";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_DTX_ENABLE = "key_audio_dtx_enable";
    @b(a=Integer.class, d=true, b={0, 2, 3, 1}, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_CAPTURE_ORIENTATION = "key_video_capture_orientation";
    @b(a=Integer.class, b={0, 4, 2, 3, 1, 5}, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_FIXED_CROP_RATIO = "key_video_fixed_crop_ratio";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_LOCAL_PREVIEW_MIRROR = "key_video_local_preview_mirror";
    @b(a=Boolean.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_VIDEO_TRANSPORT_MIRROR = "key_video_transport_mirror";
    @b(a=Boolean.class, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_HIGH_QUALITY = "key_audio_high_quality";
    @b(a=Integer.class, d=true, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_ADJUST_PLAYBACK_SIGNAL_VOLUME = "key_audio_adjust_playback_signal_volume";
    @b(a=Boolean.class, d=false, e=Privilege.PUBLIC, f=AccessPolicy.WRITE)
    public static final String KEY_AUDIO_HOWLING_SUPPRESS = "key_audio_howling_suppress";
    private final HashMap<String, Object> mParameters = new HashMap();
    private static HashMap<String, b> mKeys;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initKeysStatic() {
        if (mKeys == null) {
            Class<RtcParameters> clazz = RtcParameters.class;
            synchronized (RtcParameters.class) {
                if (mKeys == null) {
                    mKeys = new HashMap();
                    for (Field field : com.netease.nrtc.base.e.b.a(RtcParameters.class)) {
                        b b2 = com.netease.nrtc.base.e.b.a(field, b.class);
                        if (b2 == null) continue;
                        try {
                            mKeys.put((String)field.get(null), b2);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            illegalAccessException.printStackTrace();
                        }
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        }
    }

    public RtcParameters() {
        RtcParameters.initKeysStatic();
    }

    public static boolean runtimeSupported(String object) {
        RtcParameters.initKeysStatic();
        object = mKeys.get(object);
        return object != null && object.d();
    }

    public static boolean writeSupported(String object) {
        RtcParameters.initKeysStatic();
        object = mKeys.get(object);
        return object != null && object.f() == AccessPolicy.WRITE;
    }

    public static boolean checkPrivilege(String object, Privilege privilege) {
        RtcParameters.initKeysStatic();
        object = mKeys.get(object);
        switch (object.e()) {
            case PUBLIC: {
                return true;
            }
            case PROTECTED: {
                return privilege == Privilege.PROTECTED || privilege == Privilege.PRIVATE;
            }
            case PRIVATE: {
                return privilege == Privilege.PRIVATE;
            }
        }
        return false;
    }

    public static Set<String> getReadableKeys(Privilege privilege) {
        RtcParameters.initKeysStatic();
        HashSet<String> hashSet = new HashSet<String>(mKeys.size());
        for (String string : mKeys.keySet()) {
            if (mKeys.get(string).e() == Privilege.PUBLIC) {
                hashSet.add(string);
                continue;
            }
            if (mKeys.get(string).e() != Privilege.PROTECTED || privilege != Privilege.PROTECTED) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public static Set<String> getReadableKeys(Set<String> object, Privilege privilege) {
        RtcParameters.initKeysStatic();
        HashSet<String> hashSet = new HashSet<String>(mKeys.size());
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            b b2 = mKeys.get(string);
            if (b2.e() == Privilege.PUBLIC) {
                hashSet.add(string);
                continue;
            }
            if (b2.e() != Privilege.PROTECTED || privilege != Privilege.PROTECTED) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public static Class<?> getKeyType(String string) {
        RtcParameters.initKeysStatic();
        for (String string2 : mKeys.keySet()) {
            if (!string2.equals(string)) continue;
            return mKeys.get(string2).a();
        }
        return null;
    }

    public static Set<String> getWritableKeys(Set<String> object, Privilege privilege) {
        RtcParameters.initKeysStatic();
        HashSet<String> hashSet = new HashSet<String>(mKeys.size());
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            b b2 = mKeys.get(string);
            if (b2.f() != AccessPolicy.WRITE) continue;
            if (b2.e() == Privilege.PUBLIC) {
                hashSet.add(string);
                continue;
            }
            if (b2.e() != Privilege.PROTECTED || privilege != Privilege.PROTECTED) continue;
            hashSet.add(string);
        }
        return hashSet;
    }

    public final void setRequestKeys(Set<String> object) {
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.setObject(string, null);
        }
    }

    public final void setRequestKey(String string) {
        this.setObject(string, null);
    }

    public final boolean getBoolean(String string) {
        return (Boolean)this.mParameters.get(string);
    }

    public final int getInteger(String string) {
        return (Integer)this.mParameters.get(string);
    }

    public final void setInteger(String string, Integer n) {
        this.setObject(string, n);
    }

    public final void setFloat(String string, Float f2) {
        this.setObject(string, f2);
    }

    public final float getFloat(String string) {
        return ((Float)this.mParameters.get(string)).floatValue();
    }

    public final void setString(String string, String string2) {
        this.setObject(string, string2);
    }

    public final void setBoolean(String string, Boolean bl) {
        this.setObject(string, bl);
    }

    public final void setObject(String string, Object object) {
        com.netease.nrtc.base.b.a(string, (Object)"name is null");
        b b2 = mKeys.get(string);
        if (b2 == null) {
            throw new IllegalArgumentException(string.toUpperCase() + " unsupported!");
        }
        if (b2.e() == Privilege.PRIVATE) {
            throw new IllegalArgumentException(string.toUpperCase() + " is a private key!");
        }
        if (object != null) {
            if (!b2.a().isInstance(object)) {
                throw new IllegalArgumentException(string.toUpperCase() + " target type illegal, need " + b2.a().getName() + ".");
            }
            if (b2.b().length > 0 && !a.a(b2.b(), (Integer)object)) {
                throw new IllegalArgumentException(string.toUpperCase() + " target value illegal, please use " + Arrays.toString(b2.b()));
            }
            if (b2.c().length > 0 && !a.a(b2.c(), object)) {
                throw new IllegalArgumentException(string.toUpperCase() + " target value illegal, please use " + Arrays.toString(b2.c()));
            }
        }
        this.mParameters.put(string, object);
    }

    public final Object getObject(String string) {
        return this.mParameters.get(string);
    }

    public final String getString(String string) {
        return (String)this.mParameters.get(string);
    }

    public final boolean containsKey(String string) {
        return this.mParameters.containsKey(string);
    }

    public Set<String> keys() {
        return this.mParameters.keySet();
    }

    public void clear() {
        this.mParameters.clear();
    }

    public void removeParameters(String string) {
        this.mParameters.remove(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.mParameters.keySet()) {
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(this.mParameters.get(string));
            stringBuilder.append(";");
        }
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        return stringBuilder.toString();
    }
}

