/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.network;

import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.Process;
import android.text.TextUtils;
import com.xiaomi.channel.commonutils.network.d;
import com.xiaomi.network.Fallback;
import com.xiaomi.network.Fallbacks;
import com.xiaomi.network.HostFilter;
import com.xiaomi.network.a;
import com.xiaomi.network.b;
import com.xiaomi.network.c;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HostManager {
    protected Map<String, Fallbacks> mHostsMapping = new HashMap<String, Fallbacks>();
    protected static Map<String, ArrayList<String>> mReservedHosts = new HashMap<String, ArrayList<String>>();
    protected Context sAppContext;
    private HostFilter sHostFilter;
    protected HttpGet sHttpGetter;
    private String sUserId = "0";
    private long remoteRequestFailureCount = 0L;
    private final long MAX_REQUEST_FAILURE_CNT = 15L;
    private long lastRemoteRequestTimestamp = 0L;
    private String currentISP = "isp_prov_city_country_ip";
    private static HostManager sInstance;
    private static HostManagerFactory factory;
    private static String sAppName;
    private static String sAppVersion;
    protected static boolean hostLoaded;

    public static synchronized HostManager getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("the host manager is not initialized yet.");
        }
        return sInstance;
    }

    public static synchronized void setHostManagerFactory(HostManagerFactory hostManagerFactory) {
        factory = hostManagerFactory;
        sInstance = null;
    }

    public static synchronized void init(Context context, HostFilter hostFilter, HttpGet httpGet, String string, String string2, String string3) {
        if (sInstance == null) {
            sInstance = factory == null ? new HostManager(context, hostFilter, httpGet, string, string2, string3) : factory.a(context, hostFilter, httpGet, string);
        }
    }

    protected HostManager(Context context, HostFilter hostFilter, HttpGet httpGet, String string, String string2, String string3) {
        this.sAppContext = context.getApplicationContext();
        if (this.sAppContext == null) {
            this.sAppContext = context;
        }
        this.sHttpGetter = httpGet;
        this.sHostFilter = hostFilter == null ? new a(this) : hostFilter;
        this.sUserId = string;
        sAppName = string2 != null ? string2 : context.getPackageName();
        sAppVersion = string3 != null ? string3 : this.getVersionName();
    }

    public String getActiveNetworkLabel() {
        block7: {
            if (this.sAppContext == null) {
                return "unknown";
            }
            try {
                ConnectivityManager connectivityManager = (ConnectivityManager)this.sAppContext.getSystemService("connectivity");
                if (connectivityManager == null) {
                    return "unknown";
                }
                NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
                if (networkInfo == null) {
                    return "unknown";
                }
                if (networkInfo.getType() == 1) {
                    WifiManager wifiManager = (WifiManager)this.sAppContext.getSystemService("wifi");
                    if (wifiManager != null && wifiManager.getConnectionInfo() != null) {
                        return "WIFI-" + wifiManager.getConnectionInfo().getSSID();
                    }
                    break block7;
                }
                return networkInfo.getTypeName() + "-" + networkInfo.getSubtypeName();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return "unknown";
    }

    public Fallback getFallbacksByURL(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("the url is empty");
        }
        URL uRL = new URL(string);
        String string2 = uRL.getHost();
        return this.getFallbacksByHost(string2, true);
    }

    public Fallback getFallbacksByHost(String string) {
        return this.getFallbacksByHost(string, true);
    }

    public Fallback getFallbacksByHost(String string, boolean bl2) {
        Fallback fallback;
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("the host is empty");
        }
        if (!this.sHostFilter.a(string)) {
            return null;
        }
        Fallback fallback2 = this.getLocalFallback(string);
        if (fallback2 != null && fallback2.b()) {
            return fallback2;
        }
        if (bl2 && d.d(this.sAppContext) && (fallback = this.requestRemoteFallback(string)) != null) {
            return fallback;
        }
        fallback = new b(this, string, fallback2);
        return fallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Fallback getLocalFallback(String string) {
        Fallbacks fallbacks = null;
        Object object = this.mHostsMapping;
        synchronized (object) {
            this.checkHostMapping();
            fallbacks = this.mHostsMapping.get(string);
        }
        if (fallbacks != null && (object = fallbacks.getFallback()) != null) {
            return object;
        }
        return null;
    }

    protected Fallback requestRemoteFallback(String string) {
        if (System.currentTimeMillis() - this.lastRemoteRequestTimestamp > this.remoteRequestFailureCount * 60L * 1000L) {
            this.lastRemoteRequestTimestamp = System.currentTimeMillis();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            Fallback fallback = this.requestRemoteFallbacks(arrayList).get(0);
            if (fallback != null) {
                this.remoteRequestFailureCount = 0L;
                return fallback;
            }
            if (this.remoteRequestFailureCount < 15L) {
                ++this.remoteRequestFailureCount;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArrayList<Fallback> requestRemoteFallbacks(ArrayList<String> arrayList) {
        this.purge();
        Object object2 = this.mHostsMapping;
        synchronized (object2) {
            this.checkHostMapping();
            for (String object3 : this.mHostsMapping.keySet()) {
                if (arrayList.contains(object3)) continue;
                arrayList.add(object3);
            }
        }
        object2 = mReservedHosts;
        synchronized (object2) {
            for (String string : mReservedHosts.keySet()) {
                if (arrayList.contains(string)) continue;
                arrayList.add(string);
            }
        }
        if (!arrayList.contains(this.getHost())) {
            arrayList.add(this.getHost());
        }
        object2 = new ArrayList(arrayList.size());
        for (int i2 = 0; i2 < arrayList.size(); ++i2) {
            ((ArrayList)object2).add(null);
        }
        try {
            JSONObject jSONObject;
            String string = d.f(this.sAppContext) ? "wifi" : "wap";
            String string2 = this.getRemoteFallbackJSON(arrayList, string, this.sUserId);
            if (!TextUtils.isEmpty((CharSequence)string2) && "OK".equalsIgnoreCase((jSONObject = new JSONObject(string2)).getString("S"))) {
                JSONObject jSONObject2 = jSONObject.getJSONObject("R");
                String string3 = jSONObject2.getString("province");
                String string4 = jSONObject2.getString("city");
                String string5 = jSONObject2.getString("isp");
                String string6 = jSONObject2.getString("ip");
                String string7 = jSONObject2.getString("country");
                JSONObject jSONObject3 = jSONObject2.getJSONObject(string);
                String string8 = string;
                if (string8.equals("wap")) {
                    string8 = this.getActiveNetworkLabel();
                }
                com.xiaomi.channel.commonutils.logger.b.a("get bucket: ip = " + string6 + " net = " + string5 + string8 + " hosts = " + jSONObject3.toString());
                for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                    String string9 = arrayList.get(i2);
                    JSONArray jSONArray = jSONObject3.optJSONArray(string9);
                    if (jSONArray == null) {
                        com.xiaomi.channel.commonutils.logger.b.a("no bucket found for " + string9);
                        continue;
                    }
                    Fallback fallback = new Fallback(string9);
                    for (int i3 = 0; i3 < jSONArray.length(); ++i3) {
                        String string10 = jSONArray.getString(i3);
                        if (TextUtils.isEmpty((CharSequence)string10)) continue;
                        fallback.a(new c(string10, jSONArray.length() - i3));
                    }
                    ((ArrayList)object2).set(i2, fallback);
                    fallback.g = string7;
                    fallback.c = string3;
                    fallback.e = string5;
                    fallback.f = string6;
                    fallback.d = string4;
                    if (jSONObject2.has("stat-percent")) {
                        fallback.a(jSONObject2.getDouble("stat-percent"));
                    }
                    if (jSONObject2.has("stat-domain")) {
                        fallback.b(jSONObject2.getString("stat-domain"));
                    }
                    if (jSONObject2.has("ttl")) {
                        fallback.a((long)jSONObject2.getInt("ttl") * 1000L);
                    }
                    this.setCurrentISP(fallback.e());
                }
            }
        }
        catch (Exception exception) {
            com.xiaomi.channel.commonutils.logger.b.a("failed to get bucket " + exception.getMessage());
        }
        for (int i5 = 0; i5 < arrayList.size(); ++i5) {
            Fallback fallback = (Fallback)((ArrayList)object2).get(i5);
            if (fallback == null) continue;
            this.updateFallbacks(arrayList.get(i5), fallback);
        }
        this.persist();
        return object2;
    }

    protected String getHost() {
        return "resolver.gslb.mi-idc.com";
    }

    protected String getRemoteFallbackJSON(ArrayList<String> arrayList, String string, String string2) {
        ArrayList<Object> arrayList2 = new ArrayList<String>();
        ArrayList<com.xiaomi.channel.commonutils.network.a> arrayList3 = new ArrayList<com.xiaomi.channel.commonutils.network.a>();
        arrayList3.add(new com.xiaomi.channel.commonutils.network.a("type", string));
        arrayList3.add(new com.xiaomi.channel.commonutils.network.a("uuid", string2));
        arrayList3.add(new com.xiaomi.channel.commonutils.network.a("list", HostManager.join(arrayList, ",")));
        Fallback fallback = this.getLocalFallback("resolver.gslb.mi-idc.com");
        String string3 = String.format("http://%1$s/gslb/gslb/getbucket.asp?ver=3.0", "resolver.gslb.mi-idc.com");
        if (fallback == null) {
            arrayList2.add(string3);
        } else {
            arrayList2 = fallback.a(string3);
        }
        IOException iOException = null;
        for (String string4 : arrayList2) {
            Uri.Builder builder = Uri.parse((String)string4).buildUpon();
            for (com.xiaomi.channel.commonutils.network.c c2 : arrayList3) {
                builder.appendQueryParameter(c2.a(), c2.b());
            }
            try {
                if (this.sHttpGetter == null) {
                    return d.a(this.sAppContext, new URL(builder.toString()));
                }
                return this.sHttpGetter.a(builder.toString());
            }
            catch (IOException iOException2) {
                com.xiaomi.channel.commonutils.logger.b.a("network ioErr: " + iOException2.getMessage());
                iOException = iOException2;
            }
        }
        if (iOException != null) {
            throw iOException;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            this.mHostsMapping.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFallbacks(String string, Fallback fallback) {
        if (TextUtils.isEmpty((CharSequence)string) || fallback == null) {
            throw new IllegalArgumentException("the argument is invalid " + string + ", " + fallback);
        }
        if (this.sHostFilter.a(string)) {
            Map<String, Fallbacks> map = this.mHostsMapping;
            synchronized (map) {
                this.checkHostMapping();
                if (this.mHostsMapping.containsKey(string)) {
                    Fallbacks fallbacks = this.mHostsMapping.get(string);
                    fallbacks.addFallback(fallback);
                } else {
                    Fallbacks fallbacks = new Fallbacks(string);
                    fallbacks.addFallback(fallback);
                    this.mHostsMapping.put(string, fallbacks);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshFallbacks() {
        int n2;
        ArrayList<String> arrayList = null;
        Object object = this.mHostsMapping;
        synchronized (object) {
            this.checkHostMapping();
            arrayList = new ArrayList<String>(this.mHostsMapping.keySet());
            for (n2 = arrayList.size() - 1; n2 >= 0; --n2) {
                Fallbacks fallbacks = this.mHostsMapping.get(arrayList.get(n2));
                if (fallbacks == null || fallbacks.getFallback() == null) continue;
                arrayList.remove(n2);
            }
        }
        object = this.requestRemoteFallbacks(arrayList);
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            if (((ArrayList)object).get(n2) == null) continue;
            this.updateFallbacks(arrayList.get(n2), (Fallback)((ArrayList)object).get(n2));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String loadHosts() {
        BufferedReader bufferedReader;
        block6: {
            String string;
            bufferedReader = null;
            try {
                File file = new File(this.sAppContext.getFilesDir(), this.getProcessName());
                if (!file.isFile()) break block6;
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                StringBuilder stringBuilder = new StringBuilder();
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string2);
                }
                string = stringBuilder.toString();
            }
            catch (Throwable throwable) {
                try {
                    com.xiaomi.channel.commonutils.logger.b.a("load host exception " + throwable.getMessage());
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
                finally {
                    com.xiaomi.channel.commonutils.file.a.a(bufferedReader);
                }
            }
            com.xiaomi.channel.commonutils.file.a.a(bufferedReader);
            return string;
        }
        com.xiaomi.channel.commonutils.file.a.a(bufferedReader);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkHostMapping() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            if (!hostLoaded) {
                hostLoaded = true;
                this.mHostsMapping.clear();
                try {
                    String string = this.loadHosts();
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        this.fromJSON(string);
                        com.xiaomi.channel.commonutils.logger.b.a("loading the new hosts succeed");
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    com.xiaomi.channel.commonutils.logger.b.a("load host exception " + throwable.getMessage());
                }
            } else {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addReservedHost(String string, String string2) {
        ArrayList<String> arrayList = mReservedHosts.get(string);
        Map<String, ArrayList<String>> map = mReservedHosts;
        synchronized (map) {
            if (arrayList == null) {
                arrayList = new ArrayList();
                arrayList.add(string2);
                mReservedHosts.put(string, arrayList);
            } else if (!arrayList.contains(string2)) {
                arrayList.add(string2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() {
        this.purge();
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            try {
                FileOutputStream fileOutputStream = this.sAppContext.openFileOutput(this.getProcessName(), 0);
                BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(fileOutputStream));
                String string = this.toJSON().toString();
                if (!TextUtils.isEmpty((CharSequence)string)) {
                    bufferedWriter.write(string);
                }
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    protected String getProcessName() {
        List list = ((ActivityManager)this.sAppContext.getSystemService("activity")).getRunningAppProcesses();
        if (list != null) {
            for (ActivityManager.RunningAppProcessInfo runningAppProcessInfo : list) {
                if (runningAppProcessInfo.pid != Process.myPid()) continue;
                return runningAppProcessInfo.processName;
            }
        }
        return "com.xiaomi";
    }

    public static <T> String join(Collection<T> collection, String string) {
        if (collection == null || collection.isEmpty()) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(iterator.next());
            if (!iterator.hasNext()) continue;
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String join(String[] stringArray, String string) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(stringArray[0]);
        for (int i2 = 1; i2 < stringArray.length; ++i2) {
            stringBuilder.append(string);
            stringBuilder.append(stringArray[i2]);
        }
        return stringBuilder.toString();
    }

    private String getVersionName() {
        try {
            PackageInfo packageInfo = this.sAppContext.getPackageManager().getPackageInfo(this.sAppContext.getPackageName(), 16384);
            if (packageInfo != null) {
                return packageInfo.versionName;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purge() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            for (Fallbacks object : this.mHostsMapping.values()) {
                object.purge(false);
            }
            boolean bl2 = false;
            block4: while (!bl2) {
                bl2 = true;
                for (String string : this.mHostsMapping.keySet()) {
                    if (!this.mHostsMapping.get(string).getFallbacks().isEmpty()) continue;
                    this.mHostsMapping.remove(string);
                    bl2 = false;
                    continue block4;
                }
            }
        }
    }

    public void setCurrentISP(String string) {
        this.currentISP = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONArray toJSON() {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            JSONArray jSONArray = new JSONArray();
            for (Fallbacks fallbacks : this.mHostsMapping.values()) {
                jSONArray.put((Object)fallbacks.toJSON());
            }
            return jSONArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fromJSON(String string) {
        Map<String, Fallbacks> map = this.mHostsMapping;
        synchronized (map) {
            this.mHostsMapping.clear();
            JSONArray jSONArray = new JSONArray(string);
            for (int i2 = 0; i2 < jSONArray.length(); ++i2) {
                Fallbacks fallbacks = new Fallbacks().fromJSON(jSONArray.getJSONObject(i2));
                this.mHostsMapping.put(fallbacks.getHost(), fallbacks);
            }
        }
    }

    static {
        hostLoaded = false;
    }

    public static interface HttpGet {
        public String a(String var1);
    }

    public static interface HostManagerFactory {
        public HostManager a(Context var1, HostFilter var2, HttpGet var3, String var4);
    }
}

